package costmanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccumulatedType enumerates the values for accumulated type.
type AccumulatedType string

const (
	// AccumulatedTypeFalse ...
	AccumulatedTypeFalse AccumulatedType = "false"
	// AccumulatedTypeTrue ...
	AccumulatedTypeTrue AccumulatedType = "true"
)

// PossibleAccumulatedTypeValues returns an array of possible values for the AccumulatedType const type.
func PossibleAccumulatedTypeValues() []AccumulatedType {
	return []AccumulatedType{AccumulatedTypeFalse, AccumulatedTypeTrue}
}

// AlertCategory enumerates the values for alert category.
type AlertCategory string

const (
	// AlertCategoryBilling ...
	AlertCategoryBilling AlertCategory = "Billing"
	// AlertCategoryCost ...
	AlertCategoryCost AlertCategory = "Cost"
	// AlertCategorySystem ...
	AlertCategorySystem AlertCategory = "System"
	// AlertCategoryUsage ...
	AlertCategoryUsage AlertCategory = "Usage"
)

// PossibleAlertCategoryValues returns an array of possible values for the AlertCategory const type.
func PossibleAlertCategoryValues() []AlertCategory {
	return []AlertCategory{AlertCategoryBilling, AlertCategoryCost, AlertCategorySystem, AlertCategoryUsage}
}

// AlertCriteria enumerates the values for alert criteria.
type AlertCriteria string

const (
	// AlertCriteriaCostThresholdExceeded ...
	AlertCriteriaCostThresholdExceeded AlertCriteria = "CostThresholdExceeded"
	// AlertCriteriaCreditThresholdApproaching ...
	AlertCriteriaCreditThresholdApproaching AlertCriteria = "CreditThresholdApproaching"
	// AlertCriteriaCreditThresholdReached ...
	AlertCriteriaCreditThresholdReached AlertCriteria = "CreditThresholdReached"
	// AlertCriteriaCrossCloudCollectionError ...
	AlertCriteriaCrossCloudCollectionError AlertCriteria = "CrossCloudCollectionError"
	// AlertCriteriaCrossCloudNewDataAvailable ...
	AlertCriteriaCrossCloudNewDataAvailable AlertCriteria = "CrossCloudNewDataAvailable"
	// AlertCriteriaForecastCostThresholdExceeded ...
	AlertCriteriaForecastCostThresholdExceeded AlertCriteria = "ForecastCostThresholdExceeded"
	// AlertCriteriaForecastUsageThresholdExceeded ...
	AlertCriteriaForecastUsageThresholdExceeded AlertCriteria = "ForecastUsageThresholdExceeded"
	// AlertCriteriaGeneralThresholdError ...
	AlertCriteriaGeneralThresholdError AlertCriteria = "GeneralThresholdError"
	// AlertCriteriaInvoiceDueDateApproaching ...
	AlertCriteriaInvoiceDueDateApproaching AlertCriteria = "InvoiceDueDateApproaching"
	// AlertCriteriaInvoiceDueDateReached ...
	AlertCriteriaInvoiceDueDateReached AlertCriteria = "InvoiceDueDateReached"
	// AlertCriteriaMultiCurrency ...
	AlertCriteriaMultiCurrency AlertCriteria = "MultiCurrency"
	// AlertCriteriaQuotaThresholdApproaching ...
	AlertCriteriaQuotaThresholdApproaching AlertCriteria = "QuotaThresholdApproaching"
	// AlertCriteriaQuotaThresholdReached ...
	AlertCriteriaQuotaThresholdReached AlertCriteria = "QuotaThresholdReached"
	// AlertCriteriaUsageThresholdExceeded ...
	AlertCriteriaUsageThresholdExceeded AlertCriteria = "UsageThresholdExceeded"
)

// PossibleAlertCriteriaValues returns an array of possible values for the AlertCriteria const type.
func PossibleAlertCriteriaValues() []AlertCriteria {
	return []AlertCriteria{AlertCriteriaCostThresholdExceeded, AlertCriteriaCreditThresholdApproaching, AlertCriteriaCreditThresholdReached, AlertCriteriaCrossCloudCollectionError, AlertCriteriaCrossCloudNewDataAvailable, AlertCriteriaForecastCostThresholdExceeded, AlertCriteriaForecastUsageThresholdExceeded, AlertCriteriaGeneralThresholdError, AlertCriteriaInvoiceDueDateApproaching, AlertCriteriaInvoiceDueDateReached, AlertCriteriaMultiCurrency, AlertCriteriaQuotaThresholdApproaching, AlertCriteriaQuotaThresholdReached, AlertCriteriaUsageThresholdExceeded}
}

// AlertOperator enumerates the values for alert operator.
type AlertOperator string

const (
	// AlertOperatorEqualTo ...
	AlertOperatorEqualTo AlertOperator = "EqualTo"
	// AlertOperatorGreaterThan ...
	AlertOperatorGreaterThan AlertOperator = "GreaterThan"
	// AlertOperatorGreaterThanOrEqualTo ...
	AlertOperatorGreaterThanOrEqualTo AlertOperator = "GreaterThanOrEqualTo"
	// AlertOperatorLessThan ...
	AlertOperatorLessThan AlertOperator = "LessThan"
	// AlertOperatorLessThanOrEqualTo ...
	AlertOperatorLessThanOrEqualTo AlertOperator = "LessThanOrEqualTo"
	// AlertOperatorNone ...
	AlertOperatorNone AlertOperator = "None"
)

// PossibleAlertOperatorValues returns an array of possible values for the AlertOperator const type.
func PossibleAlertOperatorValues() []AlertOperator {
	return []AlertOperator{AlertOperatorEqualTo, AlertOperatorGreaterThan, AlertOperatorGreaterThanOrEqualTo, AlertOperatorLessThan, AlertOperatorLessThanOrEqualTo, AlertOperatorNone}
}

// AlertSource enumerates the values for alert source.
type AlertSource string

const (
	// AlertSourcePreset ...
	AlertSourcePreset AlertSource = "Preset"
	// AlertSourceUser ...
	AlertSourceUser AlertSource = "User"
)

// PossibleAlertSourceValues returns an array of possible values for the AlertSource const type.
func PossibleAlertSourceValues() []AlertSource {
	return []AlertSource{AlertSourcePreset, AlertSourceUser}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// AlertStatusActive ...
	AlertStatusActive AlertStatus = "Active"
	// AlertStatusDismissed ...
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusNone ...
	AlertStatusNone AlertStatus = "None"
	// AlertStatusOverridden ...
	AlertStatusOverridden AlertStatus = "Overridden"
	// AlertStatusResolved ...
	AlertStatusResolved AlertStatus = "Resolved"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{AlertStatusActive, AlertStatusDismissed, AlertStatusNone, AlertStatusOverridden, AlertStatusResolved}
}

// AlertTimeGrainType enumerates the values for alert time grain type.
type AlertTimeGrainType string

const (
	// AlertTimeGrainTypeAnnually ...
	AlertTimeGrainTypeAnnually AlertTimeGrainType = "Annually"
	// AlertTimeGrainTypeBillingAnnual ...
	AlertTimeGrainTypeBillingAnnual AlertTimeGrainType = "BillingAnnual"
	// AlertTimeGrainTypeBillingMonth ...
	AlertTimeGrainTypeBillingMonth AlertTimeGrainType = "BillingMonth"
	// AlertTimeGrainTypeBillingQuarter ...
	AlertTimeGrainTypeBillingQuarter AlertTimeGrainType = "BillingQuarter"
	// AlertTimeGrainTypeMonthly ...
	AlertTimeGrainTypeMonthly AlertTimeGrainType = "Monthly"
	// AlertTimeGrainTypeNone ...
	AlertTimeGrainTypeNone AlertTimeGrainType = "None"
	// AlertTimeGrainTypeQuarterly ...
	AlertTimeGrainTypeQuarterly AlertTimeGrainType = "Quarterly"
)

// PossibleAlertTimeGrainTypeValues returns an array of possible values for the AlertTimeGrainType const type.
func PossibleAlertTimeGrainTypeValues() []AlertTimeGrainType {
	return []AlertTimeGrainType{AlertTimeGrainTypeAnnually, AlertTimeGrainTypeBillingAnnual, AlertTimeGrainTypeBillingMonth, AlertTimeGrainTypeBillingQuarter, AlertTimeGrainTypeMonthly, AlertTimeGrainTypeNone, AlertTimeGrainTypeQuarterly}
}

// AlertType enumerates the values for alert type.
type AlertType string

const (
	// AlertTypeBudget ...
	AlertTypeBudget AlertType = "Budget"
	// AlertTypeBudgetForecast ...
	AlertTypeBudgetForecast AlertType = "BudgetForecast"
	// AlertTypeCredit ...
	AlertTypeCredit AlertType = "Credit"
	// AlertTypeGeneral ...
	AlertTypeGeneral AlertType = "General"
	// AlertTypeInvoice ...
	AlertTypeInvoice AlertType = "Invoice"
	// AlertTypeQuota ...
	AlertTypeQuota AlertType = "Quota"
	// AlertTypeXCloud ...
	AlertTypeXCloud AlertType = "xCloud"
)

// PossibleAlertTypeValues returns an array of possible values for the AlertType const type.
func PossibleAlertTypeValues() []AlertType {
	return []AlertType{AlertTypeBudget, AlertTypeBudgetForecast, AlertTypeCredit, AlertTypeGeneral, AlertTypeInvoice, AlertTypeQuota, AlertTypeXCloud}
}

// ChartType enumerates the values for chart type.
type ChartType string

const (
	// ChartTypeArea ...
	ChartTypeArea ChartType = "Area"
	// ChartTypeGroupedColumn ...
	ChartTypeGroupedColumn ChartType = "GroupedColumn"
	// ChartTypeLine ...
	ChartTypeLine ChartType = "Line"
	// ChartTypeStackedColumn ...
	ChartTypeStackedColumn ChartType = "StackedColumn"
	// ChartTypeTable ...
	ChartTypeTable ChartType = "Table"
)

// PossibleChartTypeValues returns an array of possible values for the ChartType const type.
func PossibleChartTypeValues() []ChartType {
	return []ChartType{ChartTypeArea, ChartTypeGroupedColumn, ChartTypeLine, ChartTypeStackedColumn, ChartTypeTable}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// DirectionAscending ...
	DirectionAscending Direction = "Ascending"
	// DirectionDescending ...
	DirectionDescending Direction = "Descending"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{DirectionAscending, DirectionDescending}
}

// ExecutionStatus enumerates the values for execution status.
type ExecutionStatus string

const (
	// ExecutionStatusCompleted ...
	ExecutionStatusCompleted ExecutionStatus = "Completed"
	// ExecutionStatusDataNotAvailable ...
	ExecutionStatusDataNotAvailable ExecutionStatus = "DataNotAvailable"
	// ExecutionStatusFailed ...
	ExecutionStatusFailed ExecutionStatus = "Failed"
	// ExecutionStatusInProgress ...
	ExecutionStatusInProgress ExecutionStatus = "InProgress"
	// ExecutionStatusNewDataNotAvailable ...
	ExecutionStatusNewDataNotAvailable ExecutionStatus = "NewDataNotAvailable"
	// ExecutionStatusQueued ...
	ExecutionStatusQueued ExecutionStatus = "Queued"
	// ExecutionStatusTimeout ...
	ExecutionStatusTimeout ExecutionStatus = "Timeout"
)

// PossibleExecutionStatusValues returns an array of possible values for the ExecutionStatus const type.
func PossibleExecutionStatusValues() []ExecutionStatus {
	return []ExecutionStatus{ExecutionStatusCompleted, ExecutionStatusDataNotAvailable, ExecutionStatusFailed, ExecutionStatusInProgress, ExecutionStatusNewDataNotAvailable, ExecutionStatusQueued, ExecutionStatusTimeout}
}

// ExecutionType enumerates the values for execution type.
type ExecutionType string

const (
	// ExecutionTypeOnDemand ...
	ExecutionTypeOnDemand ExecutionType = "OnDemand"
	// ExecutionTypeScheduled ...
	ExecutionTypeScheduled ExecutionType = "Scheduled"
)

// PossibleExecutionTypeValues returns an array of possible values for the ExecutionType const type.
func PossibleExecutionTypeValues() []ExecutionType {
	return []ExecutionType{ExecutionTypeOnDemand, ExecutionTypeScheduled}
}

// ExportType enumerates the values for export type.
type ExportType string

const (
	// ExportTypeActualCost ...
	ExportTypeActualCost ExportType = "ActualCost"
	// ExportTypeAmortizedCost ...
	ExportTypeAmortizedCost ExportType = "AmortizedCost"
	// ExportTypeUsage ...
	ExportTypeUsage ExportType = "Usage"
)

// PossibleExportTypeValues returns an array of possible values for the ExportType const type.
func PossibleExportTypeValues() []ExportType {
	return []ExportType{ExportTypeActualCost, ExportTypeAmortizedCost, ExportTypeUsage}
}

// ExternalCloudProviderType enumerates the values for external cloud provider type.
type ExternalCloudProviderType string

const (
	// ExternalCloudProviderTypeExternalBillingAccounts ...
	ExternalCloudProviderTypeExternalBillingAccounts ExternalCloudProviderType = "externalBillingAccounts"
	// ExternalCloudProviderTypeExternalSubscriptions ...
	ExternalCloudProviderTypeExternalSubscriptions ExternalCloudProviderType = "externalSubscriptions"
)

// PossibleExternalCloudProviderTypeValues returns an array of possible values for the ExternalCloudProviderType const type.
func PossibleExternalCloudProviderTypeValues() []ExternalCloudProviderType {
	return []ExternalCloudProviderType{ExternalCloudProviderTypeExternalBillingAccounts, ExternalCloudProviderTypeExternalSubscriptions}
}

// ForecastTimeframeType enumerates the values for forecast timeframe type.
type ForecastTimeframeType string

const (
	// ForecastTimeframeTypeBillingMonthToDate ...
	ForecastTimeframeTypeBillingMonthToDate ForecastTimeframeType = "BillingMonthToDate"
	// ForecastTimeframeTypeCustom ...
	ForecastTimeframeTypeCustom ForecastTimeframeType = "Custom"
	// ForecastTimeframeTypeMonthToDate ...
	ForecastTimeframeTypeMonthToDate ForecastTimeframeType = "MonthToDate"
	// ForecastTimeframeTypeTheLastBillingMonth ...
	ForecastTimeframeTypeTheLastBillingMonth ForecastTimeframeType = "TheLastBillingMonth"
	// ForecastTimeframeTypeTheLastMonth ...
	ForecastTimeframeTypeTheLastMonth ForecastTimeframeType = "TheLastMonth"
	// ForecastTimeframeTypeWeekToDate ...
	ForecastTimeframeTypeWeekToDate ForecastTimeframeType = "WeekToDate"
)

// PossibleForecastTimeframeTypeValues returns an array of possible values for the ForecastTimeframeType const type.
func PossibleForecastTimeframeTypeValues() []ForecastTimeframeType {
	return []ForecastTimeframeType{ForecastTimeframeTypeBillingMonthToDate, ForecastTimeframeTypeCustom, ForecastTimeframeTypeMonthToDate, ForecastTimeframeTypeTheLastBillingMonth, ForecastTimeframeTypeTheLastMonth, ForecastTimeframeTypeWeekToDate}
}

// ForecastType enumerates the values for forecast type.
type ForecastType string

const (
	// ForecastTypeActualCost ...
	ForecastTypeActualCost ForecastType = "ActualCost"
	// ForecastTypeAmortizedCost ...
	ForecastTypeAmortizedCost ForecastType = "AmortizedCost"
	// ForecastTypeUsage ...
	ForecastTypeUsage ForecastType = "Usage"
)

// PossibleForecastTypeValues returns an array of possible values for the ForecastType const type.
func PossibleForecastTypeValues() []ForecastType {
	return []ForecastType{ForecastTypeActualCost, ForecastTypeAmortizedCost, ForecastTypeUsage}
}

// FormatType enumerates the values for format type.
type FormatType string

const (
	// FormatTypeCsv ...
	FormatTypeCsv FormatType = "Csv"
)

// PossibleFormatTypeValues returns an array of possible values for the FormatType const type.
func PossibleFormatTypeValues() []FormatType {
	return []FormatType{FormatTypeCsv}
}

// FunctionType enumerates the values for function type.
type FunctionType string

const (
	// FunctionTypeAvg ...
	FunctionTypeAvg FunctionType = "Avg"
	// FunctionTypeMax ...
	FunctionTypeMax FunctionType = "Max"
	// FunctionTypeMin ...
	FunctionTypeMin FunctionType = "Min"
	// FunctionTypeSum ...
	FunctionTypeSum FunctionType = "Sum"
)

// PossibleFunctionTypeValues returns an array of possible values for the FunctionType const type.
func PossibleFunctionTypeValues() []FunctionType {
	return []FunctionType{FunctionTypeAvg, FunctionTypeMax, FunctionTypeMin, FunctionTypeSum}
}

// GranularityType enumerates the values for granularity type.
type GranularityType string

const (
	// GranularityTypeDaily ...
	GranularityTypeDaily GranularityType = "Daily"
)

// PossibleGranularityTypeValues returns an array of possible values for the GranularityType const type.
func PossibleGranularityTypeValues() []GranularityType {
	return []GranularityType{GranularityTypeDaily}
}

// KpiTypeType enumerates the values for kpi type type.
type KpiTypeType string

const (
	// KpiTypeTypeBudget ...
	KpiTypeTypeBudget KpiTypeType = "Budget"
	// KpiTypeTypeForecast ...
	KpiTypeTypeForecast KpiTypeType = "Forecast"
)

// PossibleKpiTypeTypeValues returns an array of possible values for the KpiTypeType const type.
func PossibleKpiTypeTypeValues() []KpiTypeType {
	return []KpiTypeType{KpiTypeTypeBudget, KpiTypeTypeForecast}
}

// MetricType enumerates the values for metric type.
type MetricType string

const (
	// MetricTypeActualCost ...
	MetricTypeActualCost MetricType = "ActualCost"
	// MetricTypeAHUB ...
	MetricTypeAHUB MetricType = "AHUB"
	// MetricTypeAmortizedCost ...
	MetricTypeAmortizedCost MetricType = "AmortizedCost"
)

// PossibleMetricTypeValues returns an array of possible values for the MetricType const type.
func PossibleMetricTypeValues() []MetricType {
	return []MetricType{MetricTypeActualCost, MetricTypeAHUB, MetricTypeAmortizedCost}
}

// OperationStatusType enumerates the values for operation status type.
type OperationStatusType string

const (
	// OperationStatusTypeCompleted ...
	OperationStatusTypeCompleted OperationStatusType = "Completed"
	// OperationStatusTypeFailed ...
	OperationStatusTypeFailed OperationStatusType = "Failed"
	// OperationStatusTypeRunning ...
	OperationStatusTypeRunning OperationStatusType = "Running"
)

// PossibleOperationStatusTypeValues returns an array of possible values for the OperationStatusType const type.
func PossibleOperationStatusTypeValues() []OperationStatusType {
	return []OperationStatusType{OperationStatusTypeCompleted, OperationStatusTypeFailed, OperationStatusTypeRunning}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// OperatorTypeContains ...
	OperatorTypeContains OperatorType = "Contains"
	// OperatorTypeIn ...
	OperatorTypeIn OperatorType = "In"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{OperatorTypeContains, OperatorTypeIn}
}

// PivotTypeType enumerates the values for pivot type type.
type PivotTypeType string

const (
	// PivotTypeTypeDimension ...
	PivotTypeTypeDimension PivotTypeType = "Dimension"
	// PivotTypeTypeTagKey ...
	PivotTypeTypeTagKey PivotTypeType = "TagKey"
)

// PossiblePivotTypeTypeValues returns an array of possible values for the PivotTypeType const type.
func PossiblePivotTypeTypeValues() []PivotTypeType {
	return []PivotTypeType{PivotTypeTypeDimension, PivotTypeTypeTagKey}
}

// QueryColumnType enumerates the values for query column type.
type QueryColumnType string

const (
	// QueryColumnTypeDimension ...
	QueryColumnTypeDimension QueryColumnType = "Dimension"
	// QueryColumnTypeTag ...
	QueryColumnTypeTag QueryColumnType = "Tag"
)

// PossibleQueryColumnTypeValues returns an array of possible values for the QueryColumnType const type.
func PossibleQueryColumnTypeValues() []QueryColumnType {
	return []QueryColumnType{QueryColumnTypeDimension, QueryColumnTypeTag}
}

// RecurrenceType enumerates the values for recurrence type.
type RecurrenceType string

const (
	// RecurrenceTypeAnnually ...
	RecurrenceTypeAnnually RecurrenceType = "Annually"
	// RecurrenceTypeDaily ...
	RecurrenceTypeDaily RecurrenceType = "Daily"
	// RecurrenceTypeMonthly ...
	RecurrenceTypeMonthly RecurrenceType = "Monthly"
	// RecurrenceTypeWeekly ...
	RecurrenceTypeWeekly RecurrenceType = "Weekly"
)

// PossibleRecurrenceTypeValues returns an array of possible values for the RecurrenceType const type.
func PossibleRecurrenceTypeValues() []RecurrenceType {
	return []RecurrenceType{RecurrenceTypeAnnually, RecurrenceTypeDaily, RecurrenceTypeMonthly, RecurrenceTypeWeekly}
}

// ReportConfigColumnType enumerates the values for report config column type.
type ReportConfigColumnType string

const (
	// ReportConfigColumnTypeDimension ...
	ReportConfigColumnTypeDimension ReportConfigColumnType = "Dimension"
	// ReportConfigColumnTypeTag ...
	ReportConfigColumnTypeTag ReportConfigColumnType = "Tag"
)

// PossibleReportConfigColumnTypeValues returns an array of possible values for the ReportConfigColumnType const type.
func PossibleReportConfigColumnTypeValues() []ReportConfigColumnType {
	return []ReportConfigColumnType{ReportConfigColumnTypeDimension, ReportConfigColumnTypeTag}
}

// ReportGranularityType enumerates the values for report granularity type.
type ReportGranularityType string

const (
	// ReportGranularityTypeDaily ...
	ReportGranularityTypeDaily ReportGranularityType = "Daily"
	// ReportGranularityTypeMonthly ...
	ReportGranularityTypeMonthly ReportGranularityType = "Monthly"
)

// PossibleReportGranularityTypeValues returns an array of possible values for the ReportGranularityType const type.
func PossibleReportGranularityTypeValues() []ReportGranularityType {
	return []ReportGranularityType{ReportGranularityTypeDaily, ReportGranularityTypeMonthly}
}

// ReportTimeframeType enumerates the values for report timeframe type.
type ReportTimeframeType string

const (
	// ReportTimeframeTypeCustom ...
	ReportTimeframeTypeCustom ReportTimeframeType = "Custom"
	// ReportTimeframeTypeMonthToDate ...
	ReportTimeframeTypeMonthToDate ReportTimeframeType = "MonthToDate"
	// ReportTimeframeTypeWeekToDate ...
	ReportTimeframeTypeWeekToDate ReportTimeframeType = "WeekToDate"
	// ReportTimeframeTypeYearToDate ...
	ReportTimeframeTypeYearToDate ReportTimeframeType = "YearToDate"
)

// PossibleReportTimeframeTypeValues returns an array of possible values for the ReportTimeframeType const type.
func PossibleReportTimeframeTypeValues() []ReportTimeframeType {
	return []ReportTimeframeType{ReportTimeframeTypeCustom, ReportTimeframeTypeMonthToDate, ReportTimeframeTypeWeekToDate, ReportTimeframeTypeYearToDate}
}

// StartOn enumerates the values for start on.
type StartOn string

const (
	// StartOnLastUsed ...
	StartOnLastUsed StartOn = "LastUsed"
	// StartOnScopePicker ...
	StartOnScopePicker StartOn = "ScopePicker"
	// StartOnSpecificScope ...
	StartOnSpecificScope StartOn = "SpecificScope"
)

// PossibleStartOnValues returns an array of possible values for the StartOn const type.
func PossibleStartOnValues() []StartOn {
	return []StartOn{StartOnLastUsed, StartOnScopePicker, StartOnSpecificScope}
}

// StatusType enumerates the values for status type.
type StatusType string

const (
	// StatusTypeActive ...
	StatusTypeActive StatusType = "Active"
	// StatusTypeInactive ...
	StatusTypeInactive StatusType = "Inactive"
)

// PossibleStatusTypeValues returns an array of possible values for the StatusType const type.
func PossibleStatusTypeValues() []StatusType {
	return []StatusType{StatusTypeActive, StatusTypeInactive}
}

// TimeframeType enumerates the values for timeframe type.
type TimeframeType string

const (
	// TimeframeTypeBillingMonthToDate ...
	TimeframeTypeBillingMonthToDate TimeframeType = "BillingMonthToDate"
	// TimeframeTypeCustom ...
	TimeframeTypeCustom TimeframeType = "Custom"
	// TimeframeTypeMonthToDate ...
	TimeframeTypeMonthToDate TimeframeType = "MonthToDate"
	// TimeframeTypeTheLastBillingMonth ...
	TimeframeTypeTheLastBillingMonth TimeframeType = "TheLastBillingMonth"
	// TimeframeTypeTheLastMonth ...
	TimeframeTypeTheLastMonth TimeframeType = "TheLastMonth"
	// TimeframeTypeWeekToDate ...
	TimeframeTypeWeekToDate TimeframeType = "WeekToDate"
)

// PossibleTimeframeTypeValues returns an array of possible values for the TimeframeType const type.
func PossibleTimeframeTypeValues() []TimeframeType {
	return []TimeframeType{TimeframeTypeBillingMonthToDate, TimeframeTypeCustom, TimeframeTypeMonthToDate, TimeframeTypeTheLastBillingMonth, TimeframeTypeTheLastMonth, TimeframeTypeWeekToDate}
}
