//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package apimanagement

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/apimanagement/mgmt/2021-08-01/apimanagement"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type APIType = original.APIType

const (
	APITypeGraphql   APIType = original.APITypeGraphql
	APITypeHTTP      APIType = original.APITypeHTTP
	APITypeSoap      APIType = original.APITypeSoap
	APITypeWebsocket APIType = original.APITypeWebsocket
)

type AccessIDName = original.AccessIDName

const (
	AccessIDNameAccess    AccessIDName = original.AccessIDNameAccess
	AccessIDNameGitAccess AccessIDName = original.AccessIDNameGitAccess
)

type AccessType = original.AccessType

const (
	AccessTypeAccessKey                     AccessType = original.AccessTypeAccessKey
	AccessTypeSystemAssignedManagedIdentity AccessType = original.AccessTypeSystemAssignedManagedIdentity
	AccessTypeUserAssignedManagedIdentity   AccessType = original.AccessTypeUserAssignedManagedIdentity
)

type AlwaysLog = original.AlwaysLog

const (
	AlwaysLogAllErrors AlwaysLog = original.AlwaysLogAllErrors
)

type ApimIdentityType = original.ApimIdentityType

const (
	ApimIdentityTypeNone                       ApimIdentityType = original.ApimIdentityTypeNone
	ApimIdentityTypeSystemAssigned             ApimIdentityType = original.ApimIdentityTypeSystemAssigned
	ApimIdentityTypeSystemAssignedUserAssigned ApimIdentityType = original.ApimIdentityTypeSystemAssignedUserAssigned
	ApimIdentityTypeUserAssigned               ApimIdentityType = original.ApimIdentityTypeUserAssigned
)

type AppType = original.AppType

const (
	AppTypeDeveloperPortal AppType = original.AppTypeDeveloperPortal
	AppTypePortal          AppType = original.AppTypePortal
)

type AsyncOperationStatus = original.AsyncOperationStatus

const (
	AsyncOperationStatusFailed     AsyncOperationStatus = original.AsyncOperationStatusFailed
	AsyncOperationStatusInProgress AsyncOperationStatus = original.AsyncOperationStatusInProgress
	AsyncOperationStatusStarted    AsyncOperationStatus = original.AsyncOperationStatusStarted
	AsyncOperationStatusSucceeded  AsyncOperationStatus = original.AsyncOperationStatusSucceeded
)

type AuthorizationMethod = original.AuthorizationMethod

const (
	AuthorizationMethodDELETE  AuthorizationMethod = original.AuthorizationMethodDELETE
	AuthorizationMethodGET     AuthorizationMethod = original.AuthorizationMethodGET
	AuthorizationMethodHEAD    AuthorizationMethod = original.AuthorizationMethodHEAD
	AuthorizationMethodOPTIONS AuthorizationMethod = original.AuthorizationMethodOPTIONS
	AuthorizationMethodPATCH   AuthorizationMethod = original.AuthorizationMethodPATCH
	AuthorizationMethodPOST    AuthorizationMethod = original.AuthorizationMethodPOST
	AuthorizationMethodPUT     AuthorizationMethod = original.AuthorizationMethodPUT
	AuthorizationMethodTRACE   AuthorizationMethod = original.AuthorizationMethodTRACE
)

type BackendProtocol = original.BackendProtocol

const (
	BackendProtocolHTTP BackendProtocol = original.BackendProtocolHTTP
	BackendProtocolSoap BackendProtocol = original.BackendProtocolSoap
)

type BearerTokenSendingMethod = original.BearerTokenSendingMethod

const (
	BearerTokenSendingMethodAuthorizationHeader BearerTokenSendingMethod = original.BearerTokenSendingMethodAuthorizationHeader
	BearerTokenSendingMethodQuery               BearerTokenSendingMethod = original.BearerTokenSendingMethodQuery
)

type BearerTokenSendingMethods = original.BearerTokenSendingMethods

const (
	BearerTokenSendingMethodsAuthorizationHeader BearerTokenSendingMethods = original.BearerTokenSendingMethodsAuthorizationHeader
	BearerTokenSendingMethodsQuery               BearerTokenSendingMethods = original.BearerTokenSendingMethodsQuery
)

type CertificateSource = original.CertificateSource

const (
	CertificateSourceBuiltIn  CertificateSource = original.CertificateSourceBuiltIn
	CertificateSourceCustom   CertificateSource = original.CertificateSourceCustom
	CertificateSourceKeyVault CertificateSource = original.CertificateSourceKeyVault
	CertificateSourceManaged  CertificateSource = original.CertificateSourceManaged
)

type CertificateStatus = original.CertificateStatus

const (
	CertificateStatusCompleted  CertificateStatus = original.CertificateStatusCompleted
	CertificateStatusFailed     CertificateStatus = original.CertificateStatusFailed
	CertificateStatusInProgress CertificateStatus = original.CertificateStatusInProgress
)

type ClientAuthenticationMethod = original.ClientAuthenticationMethod

const (
	ClientAuthenticationMethodBasic ClientAuthenticationMethod = original.ClientAuthenticationMethodBasic
	ClientAuthenticationMethodBody  ClientAuthenticationMethod = original.ClientAuthenticationMethodBody
)

type Confirmation = original.Confirmation

const (
	ConfirmationInvite Confirmation = original.ConfirmationInvite
	ConfirmationSignup Confirmation = original.ConfirmationSignup
)

type ConnectionStatus = original.ConnectionStatus

const (
	ConnectionStatusConnected    ConnectionStatus = original.ConnectionStatusConnected
	ConnectionStatusDegraded     ConnectionStatus = original.ConnectionStatusDegraded
	ConnectionStatusDisconnected ConnectionStatus = original.ConnectionStatusDisconnected
	ConnectionStatusUnknown      ConnectionStatus = original.ConnectionStatusUnknown
)

type ConnectivityCheckProtocol = original.ConnectivityCheckProtocol

const (
	ConnectivityCheckProtocolHTTP  ConnectivityCheckProtocol = original.ConnectivityCheckProtocolHTTP
	ConnectivityCheckProtocolHTTPS ConnectivityCheckProtocol = original.ConnectivityCheckProtocolHTTPS
	ConnectivityCheckProtocolTCP   ConnectivityCheckProtocol = original.ConnectivityCheckProtocolTCP
)

type ConnectivityStatusType = original.ConnectivityStatusType

const (
	ConnectivityStatusTypeFailure      ConnectivityStatusType = original.ConnectivityStatusTypeFailure
	ConnectivityStatusTypeInitializing ConnectivityStatusType = original.ConnectivityStatusTypeInitializing
	ConnectivityStatusTypeSuccess      ConnectivityStatusType = original.ConnectivityStatusTypeSuccess
)

type ContentFormat = original.ContentFormat

const (
	ContentFormatGraphqlLink     ContentFormat = original.ContentFormatGraphqlLink
	ContentFormatOpenapi         ContentFormat = original.ContentFormatOpenapi
	ContentFormatOpenapijson     ContentFormat = original.ContentFormatOpenapijson
	ContentFormatOpenapijsonLink ContentFormat = original.ContentFormatOpenapijsonLink
	ContentFormatOpenapiLink     ContentFormat = original.ContentFormatOpenapiLink
	ContentFormatSwaggerJSON     ContentFormat = original.ContentFormatSwaggerJSON
	ContentFormatSwaggerLinkJSON ContentFormat = original.ContentFormatSwaggerLinkJSON
	ContentFormatWadlLinkJSON    ContentFormat = original.ContentFormatWadlLinkJSON
	ContentFormatWadlXML         ContentFormat = original.ContentFormatWadlXML
	ContentFormatWsdl            ContentFormat = original.ContentFormatWsdl
	ContentFormatWsdlLink        ContentFormat = original.ContentFormatWsdlLink
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DataMaskingMode = original.DataMaskingMode

const (
	DataMaskingModeHide DataMaskingMode = original.DataMaskingModeHide
	DataMaskingModeMask DataMaskingMode = original.DataMaskingModeMask
)

type ExportFormat = original.ExportFormat

const (
	ExportFormatOpenapi     ExportFormat = original.ExportFormatOpenapi
	ExportFormatOpenapiJSON ExportFormat = original.ExportFormatOpenapiJSON
	ExportFormatSwagger     ExportFormat = original.ExportFormatSwagger
	ExportFormatWadl        ExportFormat = original.ExportFormatWadl
	ExportFormatWsdl        ExportFormat = original.ExportFormatWsdl
)

type ExportResultFormat = original.ExportResultFormat

const (
	ExportResultFormatOpenAPI ExportResultFormat = original.ExportResultFormatOpenAPI
	ExportResultFormatSwagger ExportResultFormat = original.ExportResultFormatSwagger
	ExportResultFormatWadl    ExportResultFormat = original.ExportResultFormatWadl
	ExportResultFormatWsdl    ExportResultFormat = original.ExportResultFormatWsdl
)

type GrantType = original.GrantType

const (
	GrantTypeAuthorizationCode     GrantType = original.GrantTypeAuthorizationCode
	GrantTypeClientCredentials     GrantType = original.GrantTypeClientCredentials
	GrantTypeImplicit              GrantType = original.GrantTypeImplicit
	GrantTypeResourceOwnerPassword GrantType = original.GrantTypeResourceOwnerPassword
)

type GroupType = original.GroupType

const (
	GroupTypeCustom   GroupType = original.GroupTypeCustom
	GroupTypeExternal GroupType = original.GroupTypeExternal
	GroupTypeSystem   GroupType = original.GroupTypeSystem
)

type HTTPCorrelationProtocol = original.HTTPCorrelationProtocol

const (
	HTTPCorrelationProtocolLegacy HTTPCorrelationProtocol = original.HTTPCorrelationProtocolLegacy
	HTTPCorrelationProtocolNone   HTTPCorrelationProtocol = original.HTTPCorrelationProtocolNone
	HTTPCorrelationProtocolW3C    HTTPCorrelationProtocol = original.HTTPCorrelationProtocolW3C
)

type HostnameType = original.HostnameType

const (
	HostnameTypeDeveloperPortal HostnameType = original.HostnameTypeDeveloperPortal
	HostnameTypeManagement      HostnameType = original.HostnameTypeManagement
	HostnameTypePortal          HostnameType = original.HostnameTypePortal
	HostnameTypeProxy           HostnameType = original.HostnameTypeProxy
	HostnameTypeScm             HostnameType = original.HostnameTypeScm
)

type IdentityProviderType = original.IdentityProviderType

const (
	IdentityProviderTypeAad       IdentityProviderType = original.IdentityProviderTypeAad
	IdentityProviderTypeAadB2C    IdentityProviderType = original.IdentityProviderTypeAadB2C
	IdentityProviderTypeFacebook  IdentityProviderType = original.IdentityProviderTypeFacebook
	IdentityProviderTypeGoogle    IdentityProviderType = original.IdentityProviderTypeGoogle
	IdentityProviderTypeMicrosoft IdentityProviderType = original.IdentityProviderTypeMicrosoft
	IdentityProviderTypeTwitter   IdentityProviderType = original.IdentityProviderTypeTwitter
)

type IssueType = original.IssueType

const (
	IssueTypeAgentStopped        IssueType = original.IssueTypeAgentStopped
	IssueTypeDNSResolution       IssueType = original.IssueTypeDNSResolution
	IssueTypeGuestFirewall       IssueType = original.IssueTypeGuestFirewall
	IssueTypeNetworkSecurityRule IssueType = original.IssueTypeNetworkSecurityRule
	IssueTypePlatform            IssueType = original.IssueTypePlatform
	IssueTypePortThrottled       IssueType = original.IssueTypePortThrottled
	IssueTypeSocketBind          IssueType = original.IssueTypeSocketBind
	IssueTypeUnknown             IssueType = original.IssueTypeUnknown
	IssueTypeUserDefinedRoute    IssueType = original.IssueTypeUserDefinedRoute
)

type KeyType = original.KeyType

const (
	KeyTypePrimary   KeyType = original.KeyTypePrimary
	KeyTypeSecondary KeyType = original.KeyTypeSecondary
)

type LoggerType = original.LoggerType

const (
	LoggerTypeApplicationInsights LoggerType = original.LoggerTypeApplicationInsights
	LoggerTypeAzureEventHub       LoggerType = original.LoggerTypeAzureEventHub
	LoggerTypeAzureMonitor        LoggerType = original.LoggerTypeAzureMonitor
)

type Method = original.Method

const (
	MethodGET  Method = original.MethodGET
	MethodPOST Method = original.MethodPOST
)

type NameAvailabilityReason = original.NameAvailabilityReason

const (
	NameAvailabilityReasonAlreadyExists NameAvailabilityReason = original.NameAvailabilityReasonAlreadyExists
	NameAvailabilityReasonInvalid       NameAvailabilityReason = original.NameAvailabilityReasonInvalid
	NameAvailabilityReasonValid         NameAvailabilityReason = original.NameAvailabilityReasonValid
)

type NotificationName = original.NotificationName

const (
	NotificationNameAccountClosedPublisher                            NotificationName = original.NotificationNameAccountClosedPublisher
	NotificationNameBCC                                               NotificationName = original.NotificationNameBCC
	NotificationNameNewApplicationNotificationMessage                 NotificationName = original.NotificationNameNewApplicationNotificationMessage
	NotificationNameNewIssuePublisherNotificationMessage              NotificationName = original.NotificationNameNewIssuePublisherNotificationMessage
	NotificationNamePurchasePublisherNotificationMessage              NotificationName = original.NotificationNamePurchasePublisherNotificationMessage
	NotificationNameQuotaLimitApproachingPublisherNotificationMessage NotificationName = original.NotificationNameQuotaLimitApproachingPublisherNotificationMessage
	NotificationNameRequestPublisherNotificationMessage               NotificationName = original.NotificationNameRequestPublisherNotificationMessage
)

type OperationNameFormat = original.OperationNameFormat

const (
	OperationNameFormatName OperationNameFormat = original.OperationNameFormatName
	OperationNameFormatURL  OperationNameFormat = original.OperationNameFormatURL
)

type Origin = original.Origin

const (
	OriginInbound  Origin = original.OriginInbound
	OriginLocal    Origin = original.OriginLocal
	OriginOutbound Origin = original.OriginOutbound
)

type PlatformVersion = original.PlatformVersion

const (
	PlatformVersionMtv1         PlatformVersion = original.PlatformVersionMtv1
	PlatformVersionStv1         PlatformVersion = original.PlatformVersionStv1
	PlatformVersionStv2         PlatformVersion = original.PlatformVersionStv2
	PlatformVersionUndetermined PlatformVersion = original.PlatformVersionUndetermined
)

type PolicyContentFormat = original.PolicyContentFormat

const (
	PolicyContentFormatRawxml     PolicyContentFormat = original.PolicyContentFormatRawxml
	PolicyContentFormatRawxmlLink PolicyContentFormat = original.PolicyContentFormatRawxmlLink
	PolicyContentFormatXML        PolicyContentFormat = original.PolicyContentFormatXML
	PolicyContentFormatXMLLink    PolicyContentFormat = original.PolicyContentFormatXMLLink
)

type PolicyExportFormat = original.PolicyExportFormat

const (
	PolicyExportFormatRawxml PolicyExportFormat = original.PolicyExportFormatRawxml
	PolicyExportFormatXML    PolicyExportFormat = original.PolicyExportFormatXML
)

type PolicyScopeContract = original.PolicyScopeContract

const (
	PolicyScopeContractAll       PolicyScopeContract = original.PolicyScopeContractAll
	PolicyScopeContractAPI       PolicyScopeContract = original.PolicyScopeContractAPI
	PolicyScopeContractOperation PolicyScopeContract = original.PolicyScopeContractOperation
	PolicyScopeContractProduct   PolicyScopeContract = original.PolicyScopeContractProduct
	PolicyScopeContractTenant    PolicyScopeContract = original.PolicyScopeContractTenant
)

type PortalRevisionStatus = original.PortalRevisionStatus

const (
	PortalRevisionStatusCompleted  PortalRevisionStatus = original.PortalRevisionStatusCompleted
	PortalRevisionStatusFailed     PortalRevisionStatus = original.PortalRevisionStatusFailed
	PortalRevisionStatusPending    PortalRevisionStatus = original.PortalRevisionStatusPending
	PortalRevisionStatusPublishing PortalRevisionStatus = original.PortalRevisionStatusPublishing
)

type PreferredIPVersion = original.PreferredIPVersion

const (
	PreferredIPVersionIPv4 PreferredIPVersion = original.PreferredIPVersionIPv4
)

type PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningState

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateCreating
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDeleting
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateFailed
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateSucceeded
)

type PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatus

const (
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatusApproved
	PrivateEndpointServiceConnectionStatusPending  PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatusPending
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatusRejected
)

type ProductState = original.ProductState

const (
	ProductStateNotPublished ProductState = original.ProductStateNotPublished
	ProductStatePublished    ProductState = original.ProductStatePublished
)

type Protocol = original.Protocol

const (
	ProtocolHTTP  Protocol = original.ProtocolHTTP
	ProtocolHTTPS Protocol = original.ProtocolHTTPS
	ProtocolWs    Protocol = original.ProtocolWs
	ProtocolWss   Protocol = original.ProtocolWss
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreated ProvisioningState = original.ProvisioningStateCreated
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = original.PublicNetworkAccessDisabled
	PublicNetworkAccessEnabled  PublicNetworkAccess = original.PublicNetworkAccessEnabled
)

type ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleType

const (
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeAutomatic
	ResourceSkuCapacityScaleTypeManual    ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeManual
	ResourceSkuCapacityScaleTypeNone      ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeNone
)

type SamplingType = original.SamplingType

const (
	SamplingTypeFixed SamplingType = original.SamplingTypeFixed
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityWarning Severity = original.SeverityWarning
)

type SkuCapacityScaleType = original.SkuCapacityScaleType

const (
	SkuCapacityScaleTypeAutomatic SkuCapacityScaleType = original.SkuCapacityScaleTypeAutomatic
	SkuCapacityScaleTypeManual    SkuCapacityScaleType = original.SkuCapacityScaleTypeManual
	SkuCapacityScaleTypeNone      SkuCapacityScaleType = original.SkuCapacityScaleTypeNone
)

type SkuRestrictionsReasonCode = original.SkuRestrictionsReasonCode

const (
	SkuRestrictionsReasonCodeNotAvailableForSubscription SkuRestrictionsReasonCode = original.SkuRestrictionsReasonCodeNotAvailableForSubscription
	SkuRestrictionsReasonCodeQuotaID                     SkuRestrictionsReasonCode = original.SkuRestrictionsReasonCodeQuotaID
)

type SkuRestrictionsType = original.SkuRestrictionsType

const (
	SkuRestrictionsTypeLocation SkuRestrictionsType = original.SkuRestrictionsTypeLocation
	SkuRestrictionsTypeZone     SkuRestrictionsType = original.SkuRestrictionsTypeZone
)

type SkuType = original.SkuType

const (
	SkuTypeBasic       SkuType = original.SkuTypeBasic
	SkuTypeConsumption SkuType = original.SkuTypeConsumption
	SkuTypeDeveloper   SkuType = original.SkuTypeDeveloper
	SkuTypeIsolated    SkuType = original.SkuTypeIsolated
	SkuTypePremium     SkuType = original.SkuTypePremium
	SkuTypeStandard    SkuType = original.SkuTypeStandard
)

type SoapAPIType = original.SoapAPIType

const (
	SoapAPITypeGraphQL         SoapAPIType = original.SoapAPITypeGraphQL
	SoapAPITypeSoapPassThrough SoapAPIType = original.SoapAPITypeSoapPassThrough
	SoapAPITypeSoapToRest      SoapAPIType = original.SoapAPITypeSoapToRest
	SoapAPITypeWebSocket       SoapAPIType = original.SoapAPITypeWebSocket
)

type State = original.State

const (
	StateClosed   State = original.StateClosed
	StateOpen     State = original.StateOpen
	StateProposed State = original.StateProposed
	StateRemoved  State = original.StateRemoved
	StateResolved State = original.StateResolved
)

type StoreName = original.StoreName

const (
	StoreNameCertificateAuthority StoreName = original.StoreNameCertificateAuthority
	StoreNameRoot                 StoreName = original.StoreNameRoot
)

type SubscriptionState = original.SubscriptionState

const (
	SubscriptionStateActive    SubscriptionState = original.SubscriptionStateActive
	SubscriptionStateCancelled SubscriptionState = original.SubscriptionStateCancelled
	SubscriptionStateExpired   SubscriptionState = original.SubscriptionStateExpired
	SubscriptionStateRejected  SubscriptionState = original.SubscriptionStateRejected
	SubscriptionStateSubmitted SubscriptionState = original.SubscriptionStateSubmitted
	SubscriptionStateSuspended SubscriptionState = original.SubscriptionStateSuspended
)

type TemplateName = original.TemplateName

const (
	TemplateNameAccountClosedDeveloper                            TemplateName = original.TemplateNameAccountClosedDeveloper
	TemplateNameApplicationApprovedNotificationMessage            TemplateName = original.TemplateNameApplicationApprovedNotificationMessage
	TemplateNameConfirmSignUpIdentityDefault                      TemplateName = original.TemplateNameConfirmSignUpIdentityDefault
	TemplateNameEmailChangeIdentityDefault                        TemplateName = original.TemplateNameEmailChangeIdentityDefault
	TemplateNameInviteUserNotificationMessage                     TemplateName = original.TemplateNameInviteUserNotificationMessage
	TemplateNameNewCommentNotificationMessage                     TemplateName = original.TemplateNameNewCommentNotificationMessage
	TemplateNameNewDeveloperNotificationMessage                   TemplateName = original.TemplateNameNewDeveloperNotificationMessage
	TemplateNameNewIssueNotificationMessage                       TemplateName = original.TemplateNameNewIssueNotificationMessage
	TemplateNamePasswordResetByAdminNotificationMessage           TemplateName = original.TemplateNamePasswordResetByAdminNotificationMessage
	TemplateNamePasswordResetIdentityDefault                      TemplateName = original.TemplateNamePasswordResetIdentityDefault
	TemplateNamePurchaseDeveloperNotificationMessage              TemplateName = original.TemplateNamePurchaseDeveloperNotificationMessage
	TemplateNameQuotaLimitApproachingDeveloperNotificationMessage TemplateName = original.TemplateNameQuotaLimitApproachingDeveloperNotificationMessage
	TemplateNameRejectDeveloperNotificationMessage                TemplateName = original.TemplateNameRejectDeveloperNotificationMessage
	TemplateNameRequestDeveloperNotificationMessage               TemplateName = original.TemplateNameRequestDeveloperNotificationMessage
)

type UserState = original.UserState

const (
	UserStateActive  UserState = original.UserStateActive
	UserStateBlocked UserState = original.UserStateBlocked
	UserStateDeleted UserState = original.UserStateDeleted
	UserStatePending UserState = original.UserStatePending
)

type Verbosity = original.Verbosity

const (
	VerbosityError       Verbosity = original.VerbosityError
	VerbosityInformation Verbosity = original.VerbosityInformation
	VerbosityVerbose     Verbosity = original.VerbosityVerbose
)

type VersioningScheme = original.VersioningScheme

const (
	VersioningSchemeHeader  VersioningScheme = original.VersioningSchemeHeader
	VersioningSchemeQuery   VersioningScheme = original.VersioningSchemeQuery
	VersioningSchemeSegment VersioningScheme = original.VersioningSchemeSegment
)

type VersioningScheme1 = original.VersioningScheme1

const (
	VersioningScheme1Header  VersioningScheme1 = original.VersioningScheme1Header
	VersioningScheme1Query   VersioningScheme1 = original.VersioningScheme1Query
	VersioningScheme1Segment VersioningScheme1 = original.VersioningScheme1Segment
)

type VirtualNetworkType = original.VirtualNetworkType

const (
	VirtualNetworkTypeExternal VirtualNetworkType = original.VirtualNetworkTypeExternal
	VirtualNetworkTypeInternal VirtualNetworkType = original.VirtualNetworkTypeInternal
	VirtualNetworkTypeNone     VirtualNetworkType = original.VirtualNetworkTypeNone
)

type APIClient = original.APIClient
type APICollection = original.APICollection
type APICollectionIterator = original.APICollectionIterator
type APICollectionPage = original.APICollectionPage
type APIContactInformation = original.APIContactInformation
type APIContract = original.APIContract
type APIContractProperties = original.APIContractProperties
type APIContractUpdateProperties = original.APIContractUpdateProperties
type APICreateOrUpdateFuture = original.APICreateOrUpdateFuture
type APICreateOrUpdateParameter = original.APICreateOrUpdateParameter
type APICreateOrUpdateProperties = original.APICreateOrUpdateProperties
type APICreateOrUpdatePropertiesWsdlSelector = original.APICreateOrUpdatePropertiesWsdlSelector
type APIDiagnosticClient = original.APIDiagnosticClient
type APIEntityBaseContract = original.APIEntityBaseContract
type APIExportClient = original.APIExportClient
type APIExportResult = original.APIExportResult
type APIExportResultValue = original.APIExportResultValue
type APIIssueAttachmentClient = original.APIIssueAttachmentClient
type APIIssueClient = original.APIIssueClient
type APIIssueCommentClient = original.APIIssueCommentClient
type APILicenseInformation = original.APILicenseInformation
type APIOperationClient = original.APIOperationClient
type APIOperationPolicyClient = original.APIOperationPolicyClient
type APIPolicyClient = original.APIPolicyClient
type APIProductClient = original.APIProductClient
type APIReleaseClient = original.APIReleaseClient
type APIReleaseCollection = original.APIReleaseCollection
type APIReleaseCollectionIterator = original.APIReleaseCollectionIterator
type APIReleaseCollectionPage = original.APIReleaseCollectionPage
type APIReleaseContract = original.APIReleaseContract
type APIReleaseContractProperties = original.APIReleaseContractProperties
type APIRevisionClient = original.APIRevisionClient
type APIRevisionCollection = original.APIRevisionCollection
type APIRevisionCollectionIterator = original.APIRevisionCollectionIterator
type APIRevisionCollectionPage = original.APIRevisionCollectionPage
type APIRevisionContract = original.APIRevisionContract
type APIRevisionInfoContract = original.APIRevisionInfoContract
type APISchemaClient = original.APISchemaClient
type APISchemaCreateOrUpdateFuture = original.APISchemaCreateOrUpdateFuture
type APITagDescriptionClient = original.APITagDescriptionClient
type APITagResourceContractProperties = original.APITagResourceContractProperties
type APIUpdateContract = original.APIUpdateContract
type APIVersionConstraint = original.APIVersionConstraint
type APIVersionSetClient = original.APIVersionSetClient
type APIVersionSetCollection = original.APIVersionSetCollection
type APIVersionSetCollectionIterator = original.APIVersionSetCollectionIterator
type APIVersionSetCollectionPage = original.APIVersionSetCollectionPage
type APIVersionSetContract = original.APIVersionSetContract
type APIVersionSetContractDetails = original.APIVersionSetContractDetails
type APIVersionSetContractProperties = original.APIVersionSetContractProperties
type APIVersionSetEntityBase = original.APIVersionSetEntityBase
type APIVersionSetUpdateParameters = original.APIVersionSetUpdateParameters
type APIVersionSetUpdateParametersProperties = original.APIVersionSetUpdateParametersProperties
type AccessInformationCollection = original.AccessInformationCollection
type AccessInformationCollectionIterator = original.AccessInformationCollectionIterator
type AccessInformationCollectionPage = original.AccessInformationCollectionPage
type AccessInformationContract = original.AccessInformationContract
type AccessInformationContractProperties = original.AccessInformationContractProperties
type AccessInformationCreateParameterProperties = original.AccessInformationCreateParameterProperties
type AccessInformationCreateParameters = original.AccessInformationCreateParameters
type AccessInformationSecretsContract = original.AccessInformationSecretsContract
type AccessInformationUpdateParameterProperties = original.AccessInformationUpdateParameterProperties
type AccessInformationUpdateParameters = original.AccessInformationUpdateParameters
type AdditionalLocation = original.AdditionalLocation
type ApimResource = original.ApimResource
type ArmIDWrapper = original.ArmIDWrapper
type AssociationContract = original.AssociationContract
type AssociationContractProperties = original.AssociationContractProperties
type AuthenticationSettingsContract = original.AuthenticationSettingsContract
type AuthorizationServerClient = original.AuthorizationServerClient
type AuthorizationServerCollection = original.AuthorizationServerCollection
type AuthorizationServerCollectionIterator = original.AuthorizationServerCollectionIterator
type AuthorizationServerCollectionPage = original.AuthorizationServerCollectionPage
type AuthorizationServerContract = original.AuthorizationServerContract
type AuthorizationServerContractBaseProperties = original.AuthorizationServerContractBaseProperties
type AuthorizationServerContractProperties = original.AuthorizationServerContractProperties
type AuthorizationServerSecretsContract = original.AuthorizationServerSecretsContract
type AuthorizationServerUpdateContract = original.AuthorizationServerUpdateContract
type AuthorizationServerUpdateContractProperties = original.AuthorizationServerUpdateContractProperties
type AzureEntityResource = original.AzureEntityResource
type BackendAuthorizationHeaderCredentials = original.BackendAuthorizationHeaderCredentials
type BackendBaseParameters = original.BackendBaseParameters
type BackendClient = original.BackendClient
type BackendCollection = original.BackendCollection
type BackendCollectionIterator = original.BackendCollectionIterator
type BackendCollectionPage = original.BackendCollectionPage
type BackendContract = original.BackendContract
type BackendContractProperties = original.BackendContractProperties
type BackendCredentialsContract = original.BackendCredentialsContract
type BackendProperties = original.BackendProperties
type BackendProxyContract = original.BackendProxyContract
type BackendReconnectContract = original.BackendReconnectContract
type BackendReconnectProperties = original.BackendReconnectProperties
type BackendServiceFabricClusterProperties = original.BackendServiceFabricClusterProperties
type BackendTLSProperties = original.BackendTLSProperties
type BackendUpdateParameterProperties = original.BackendUpdateParameterProperties
type BackendUpdateParameters = original.BackendUpdateParameters
type BaseClient = original.BaseClient
type BodyDiagnosticSettings = original.BodyDiagnosticSettings
type CacheClient = original.CacheClient
type CacheCollection = original.CacheCollection
type CacheCollectionIterator = original.CacheCollectionIterator
type CacheCollectionPage = original.CacheCollectionPage
type CacheContract = original.CacheContract
type CacheContractProperties = original.CacheContractProperties
type CacheUpdateParameters = original.CacheUpdateParameters
type CacheUpdateProperties = original.CacheUpdateProperties
type CertificateClient = original.CertificateClient
type CertificateCollection = original.CertificateCollection
type CertificateCollectionIterator = original.CertificateCollectionIterator
type CertificateCollectionPage = original.CertificateCollectionPage
type CertificateConfiguration = original.CertificateConfiguration
type CertificateContract = original.CertificateContract
type CertificateContractProperties = original.CertificateContractProperties
type CertificateCreateOrUpdateParameters = original.CertificateCreateOrUpdateParameters
type CertificateCreateOrUpdateProperties = original.CertificateCreateOrUpdateProperties
type CertificateInformation = original.CertificateInformation
type ClientSecretContract = original.ClientSecretContract
type ConnectivityCheckRequest = original.ConnectivityCheckRequest
type ConnectivityCheckRequestDestination = original.ConnectivityCheckRequestDestination
type ConnectivityCheckRequestProtocolConfiguration = original.ConnectivityCheckRequestProtocolConfiguration
type ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration = original.ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration
type ConnectivityCheckRequestSource = original.ConnectivityCheckRequestSource
type ConnectivityCheckResponse = original.ConnectivityCheckResponse
type ConnectivityHop = original.ConnectivityHop
type ConnectivityIssue = original.ConnectivityIssue
type ConnectivityStatusContract = original.ConnectivityStatusContract
type ContentItemClient = original.ContentItemClient
type ContentItemCollection = original.ContentItemCollection
type ContentItemCollectionIterator = original.ContentItemCollectionIterator
type ContentItemCollectionPage = original.ContentItemCollectionPage
type ContentItemContract = original.ContentItemContract
type ContentTypeClient = original.ContentTypeClient
type ContentTypeCollection = original.ContentTypeCollection
type ContentTypeCollectionIterator = original.ContentTypeCollectionIterator
type ContentTypeCollectionPage = original.ContentTypeCollectionPage
type ContentTypeContract = original.ContentTypeContract
type ContentTypeContractProperties = original.ContentTypeContractProperties
type DataMasking = original.DataMasking
type DataMaskingEntity = original.DataMaskingEntity
type DelegationSettingsClient = original.DelegationSettingsClient
type DeletedServiceContract = original.DeletedServiceContract
type DeletedServiceContractProperties = original.DeletedServiceContractProperties
type DeletedServicesClient = original.DeletedServicesClient
type DeletedServicesCollection = original.DeletedServicesCollection
type DeletedServicesCollectionIterator = original.DeletedServicesCollectionIterator
type DeletedServicesCollectionPage = original.DeletedServicesCollectionPage
type DeletedServicesPurgeFuture = original.DeletedServicesPurgeFuture
type DeployConfigurationParameterProperties = original.DeployConfigurationParameterProperties
type DeployConfigurationParameters = original.DeployConfigurationParameters
type DiagnosticClient = original.DiagnosticClient
type DiagnosticCollection = original.DiagnosticCollection
type DiagnosticCollectionIterator = original.DiagnosticCollectionIterator
type DiagnosticCollectionPage = original.DiagnosticCollectionPage
type DiagnosticContract = original.DiagnosticContract
type DiagnosticContractProperties = original.DiagnosticContractProperties
type EmailTemplateClient = original.EmailTemplateClient
type EmailTemplateCollection = original.EmailTemplateCollection
type EmailTemplateCollectionIterator = original.EmailTemplateCollectionIterator
type EmailTemplateCollectionPage = original.EmailTemplateCollectionPage
type EmailTemplateContract = original.EmailTemplateContract
type EmailTemplateContractProperties = original.EmailTemplateContractProperties
type EmailTemplateParametersContractProperties = original.EmailTemplateParametersContractProperties
type EmailTemplateUpdateParameterProperties = original.EmailTemplateUpdateParameterProperties
type EmailTemplateUpdateParameters = original.EmailTemplateUpdateParameters
type EndpointDependency = original.EndpointDependency
type EndpointDetail = original.EndpointDetail
type ErrorFieldContract = original.ErrorFieldContract
type ErrorResponse = original.ErrorResponse
type ErrorResponseBody = original.ErrorResponseBody
type GatewayAPIClient = original.GatewayAPIClient
type GatewayCertificateAuthorityClient = original.GatewayCertificateAuthorityClient
type GatewayCertificateAuthorityCollection = original.GatewayCertificateAuthorityCollection
type GatewayCertificateAuthorityCollectionIterator = original.GatewayCertificateAuthorityCollectionIterator
type GatewayCertificateAuthorityCollectionPage = original.GatewayCertificateAuthorityCollectionPage
type GatewayCertificateAuthorityContract = original.GatewayCertificateAuthorityContract
type GatewayCertificateAuthorityContractProperties = original.GatewayCertificateAuthorityContractProperties
type GatewayClient = original.GatewayClient
type GatewayCollection = original.GatewayCollection
type GatewayCollectionIterator = original.GatewayCollectionIterator
type GatewayCollectionPage = original.GatewayCollectionPage
type GatewayContract = original.GatewayContract
type GatewayContractProperties = original.GatewayContractProperties
type GatewayHostnameConfigurationClient = original.GatewayHostnameConfigurationClient
type GatewayHostnameConfigurationCollection = original.GatewayHostnameConfigurationCollection
type GatewayHostnameConfigurationCollectionIterator = original.GatewayHostnameConfigurationCollectionIterator
type GatewayHostnameConfigurationCollectionPage = original.GatewayHostnameConfigurationCollectionPage
type GatewayHostnameConfigurationContract = original.GatewayHostnameConfigurationContract
type GatewayHostnameConfigurationContractProperties = original.GatewayHostnameConfigurationContractProperties
type GatewayKeyRegenerationRequestContract = original.GatewayKeyRegenerationRequestContract
type GatewayKeysContract = original.GatewayKeysContract
type GatewayTokenContract = original.GatewayTokenContract
type GatewayTokenRequestContract = original.GatewayTokenRequestContract
type GenerateSsoURLResult = original.GenerateSsoURLResult
type GroupClient = original.GroupClient
type GroupCollection = original.GroupCollection
type GroupCollectionIterator = original.GroupCollectionIterator
type GroupCollectionPage = original.GroupCollectionPage
type GroupContract = original.GroupContract
type GroupContractProperties = original.GroupContractProperties
type GroupCreateParameters = original.GroupCreateParameters
type GroupCreateParametersProperties = original.GroupCreateParametersProperties
type GroupUpdateParameters = original.GroupUpdateParameters
type GroupUpdateParametersProperties = original.GroupUpdateParametersProperties
type GroupUserClient = original.GroupUserClient
type HTTPHeader = original.HTTPHeader
type HTTPMessageDiagnostic = original.HTTPMessageDiagnostic
type HostnameConfiguration = original.HostnameConfiguration
type IdentityProviderBaseParameters = original.IdentityProviderBaseParameters
type IdentityProviderClient = original.IdentityProviderClient
type IdentityProviderContract = original.IdentityProviderContract
type IdentityProviderContractProperties = original.IdentityProviderContractProperties
type IdentityProviderCreateContract = original.IdentityProviderCreateContract
type IdentityProviderCreateContractProperties = original.IdentityProviderCreateContractProperties
type IdentityProviderList = original.IdentityProviderList
type IdentityProviderListIterator = original.IdentityProviderListIterator
type IdentityProviderListPage = original.IdentityProviderListPage
type IdentityProviderUpdateParameters = original.IdentityProviderUpdateParameters
type IdentityProviderUpdateProperties = original.IdentityProviderUpdateProperties
type IssueAttachmentCollection = original.IssueAttachmentCollection
type IssueAttachmentCollectionIterator = original.IssueAttachmentCollectionIterator
type IssueAttachmentCollectionPage = original.IssueAttachmentCollectionPage
type IssueAttachmentContract = original.IssueAttachmentContract
type IssueAttachmentContractProperties = original.IssueAttachmentContractProperties
type IssueClient = original.IssueClient
type IssueCollection = original.IssueCollection
type IssueCollectionIterator = original.IssueCollectionIterator
type IssueCollectionPage = original.IssueCollectionPage
type IssueCommentCollection = original.IssueCommentCollection
type IssueCommentCollectionIterator = original.IssueCommentCollectionIterator
type IssueCommentCollectionPage = original.IssueCommentCollectionPage
type IssueCommentContract = original.IssueCommentContract
type IssueCommentContractProperties = original.IssueCommentContractProperties
type IssueContract = original.IssueContract
type IssueContractBaseProperties = original.IssueContractBaseProperties
type IssueContractProperties = original.IssueContractProperties
type IssueUpdateContract = original.IssueUpdateContract
type IssueUpdateContractProperties = original.IssueUpdateContractProperties
type KeyVaultContractCreateProperties = original.KeyVaultContractCreateProperties
type KeyVaultContractProperties = original.KeyVaultContractProperties
type KeyVaultLastAccessStatusContractProperties = original.KeyVaultLastAccessStatusContractProperties
type ListNetworkStatusContractByLocation = original.ListNetworkStatusContractByLocation
type LoggerClient = original.LoggerClient
type LoggerCollection = original.LoggerCollection
type LoggerCollectionIterator = original.LoggerCollectionIterator
type LoggerCollectionPage = original.LoggerCollectionPage
type LoggerContract = original.LoggerContract
type LoggerContractProperties = original.LoggerContractProperties
type LoggerUpdateContract = original.LoggerUpdateContract
type LoggerUpdateParameters = original.LoggerUpdateParameters
type NamedValueClient = original.NamedValueClient
type NamedValueCollection = original.NamedValueCollection
type NamedValueCollectionIterator = original.NamedValueCollectionIterator
type NamedValueCollectionPage = original.NamedValueCollectionPage
type NamedValueContract = original.NamedValueContract
type NamedValueContractProperties = original.NamedValueContractProperties
type NamedValueCreateContract = original.NamedValueCreateContract
type NamedValueCreateContractProperties = original.NamedValueCreateContractProperties
type NamedValueCreateOrUpdateFuture = original.NamedValueCreateOrUpdateFuture
type NamedValueEntityBaseParameters = original.NamedValueEntityBaseParameters
type NamedValueRefreshSecretFuture = original.NamedValueRefreshSecretFuture
type NamedValueSecretContract = original.NamedValueSecretContract
type NamedValueUpdateFuture = original.NamedValueUpdateFuture
type NamedValueUpdateParameterProperties = original.NamedValueUpdateParameterProperties
type NamedValueUpdateParameters = original.NamedValueUpdateParameters
type NetworkStatusClient = original.NetworkStatusClient
type NetworkStatusContract = original.NetworkStatusContract
type NetworkStatusContractByLocation = original.NetworkStatusContractByLocation
type NotificationClient = original.NotificationClient
type NotificationCollection = original.NotificationCollection
type NotificationCollectionIterator = original.NotificationCollectionIterator
type NotificationCollectionPage = original.NotificationCollectionPage
type NotificationContract = original.NotificationContract
type NotificationContractProperties = original.NotificationContractProperties
type NotificationRecipientEmailClient = original.NotificationRecipientEmailClient
type NotificationRecipientUserClient = original.NotificationRecipientUserClient
type OAuth2AuthenticationSettingsContract = original.OAuth2AuthenticationSettingsContract
type OpenIDAuthenticationSettingsContract = original.OpenIDAuthenticationSettingsContract
type OpenIDConnectProviderClient = original.OpenIDConnectProviderClient
type OpenIDConnectProviderCollection = original.OpenIDConnectProviderCollection
type OpenIDConnectProviderCollectionIterator = original.OpenIDConnectProviderCollectionIterator
type OpenIDConnectProviderCollectionPage = original.OpenIDConnectProviderCollectionPage
type OpenidConnectProviderContract = original.OpenidConnectProviderContract
type OpenidConnectProviderContractProperties = original.OpenidConnectProviderContractProperties
type OpenidConnectProviderUpdateContract = original.OpenidConnectProviderUpdateContract
type OpenidConnectProviderUpdateContractProperties = original.OpenidConnectProviderUpdateContractProperties
type Operation = original.Operation
type OperationClient = original.OperationClient
type OperationCollection = original.OperationCollection
type OperationCollectionIterator = original.OperationCollectionIterator
type OperationCollectionPage = original.OperationCollectionPage
type OperationContract = original.OperationContract
type OperationContractProperties = original.OperationContractProperties
type OperationDisplay = original.OperationDisplay
type OperationEntityBaseContract = original.OperationEntityBaseContract
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResultContract = original.OperationResultContract
type OperationResultContractProperties = original.OperationResultContractProperties
type OperationResultLogItemContract = original.OperationResultLogItemContract
type OperationTagResourceContractProperties = original.OperationTagResourceContractProperties
type OperationUpdateContract = original.OperationUpdateContract
type OperationUpdateContractProperties = original.OperationUpdateContractProperties
type OperationsClient = original.OperationsClient
type OutboundEnvironmentEndpoint = original.OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointList = original.OutboundEnvironmentEndpointList
type OutboundNetworkDependenciesEndpointsClient = original.OutboundNetworkDependenciesEndpointsClient
type ParameterContract = original.ParameterContract
type ParameterExampleContract = original.ParameterExampleContract
type PerformConnectivityCheckAsyncFuture = original.PerformConnectivityCheckAsyncFuture
type PipelineDiagnosticSettings = original.PipelineDiagnosticSettings
type PolicyClient = original.PolicyClient
type PolicyCollection = original.PolicyCollection
type PolicyContract = original.PolicyContract
type PolicyContractProperties = original.PolicyContractProperties
type PolicyDescriptionClient = original.PolicyDescriptionClient
type PolicyDescriptionCollection = original.PolicyDescriptionCollection
type PolicyDescriptionContract = original.PolicyDescriptionContract
type PolicyDescriptionContractProperties = original.PolicyDescriptionContractProperties
type PortalDelegationSettings = original.PortalDelegationSettings
type PortalDelegationSettingsProperties = original.PortalDelegationSettingsProperties
type PortalRevisionClient = original.PortalRevisionClient
type PortalRevisionCollection = original.PortalRevisionCollection
type PortalRevisionCollectionIterator = original.PortalRevisionCollectionIterator
type PortalRevisionCollectionPage = original.PortalRevisionCollectionPage
type PortalRevisionContract = original.PortalRevisionContract
type PortalRevisionContractProperties = original.PortalRevisionContractProperties
type PortalRevisionCreateOrUpdateFuture = original.PortalRevisionCreateOrUpdateFuture
type PortalRevisionUpdateFuture = original.PortalRevisionUpdateFuture
type PortalSettingValidationKeyContract = original.PortalSettingValidationKeyContract
type PortalSettingsClient = original.PortalSettingsClient
type PortalSettingsCollection = original.PortalSettingsCollection
type PortalSettingsContract = original.PortalSettingsContract
type PortalSettingsContractProperties = original.PortalSettingsContractProperties
type PortalSigninSettingProperties = original.PortalSigninSettingProperties
type PortalSigninSettings = original.PortalSigninSettings
type PortalSignupSettings = original.PortalSignupSettings
type PortalSignupSettingsProperties = original.PortalSignupSettingsProperties
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionClient = original.PrivateEndpointConnectionClient
type PrivateEndpointConnectionCreateOrUpdateFuture = original.PrivateEndpointConnectionCreateOrUpdateFuture
type PrivateEndpointConnectionDeleteFuture = original.PrivateEndpointConnectionDeleteFuture
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionRequest = original.PrivateEndpointConnectionRequest
type PrivateEndpointConnectionRequestProperties = original.PrivateEndpointConnectionRequestProperties
type PrivateEndpointConnectionWrapperProperties = original.PrivateEndpointConnectionWrapperProperties
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type ProductAPIClient = original.ProductAPIClient
type ProductClient = original.ProductClient
type ProductCollection = original.ProductCollection
type ProductCollectionIterator = original.ProductCollectionIterator
type ProductCollectionPage = original.ProductCollectionPage
type ProductContract = original.ProductContract
type ProductContractProperties = original.ProductContractProperties
type ProductEntityBaseParameters = original.ProductEntityBaseParameters
type ProductGroupClient = original.ProductGroupClient
type ProductPolicyClient = original.ProductPolicyClient
type ProductSubscriptionsClient = original.ProductSubscriptionsClient
type ProductTagResourceContractProperties = original.ProductTagResourceContractProperties
type ProductUpdateParameters = original.ProductUpdateParameters
type ProductUpdateProperties = original.ProductUpdateProperties
type ProxyResource = original.ProxyResource
type QuotaByCounterKeysClient = original.QuotaByCounterKeysClient
type QuotaByPeriodKeysClient = original.QuotaByPeriodKeysClient
type QuotaCounterCollection = original.QuotaCounterCollection
type QuotaCounterContract = original.QuotaCounterContract
type QuotaCounterValueContract = original.QuotaCounterValueContract
type QuotaCounterValueContractProperties = original.QuotaCounterValueContractProperties
type QuotaCounterValueUpdateContract = original.QuotaCounterValueUpdateContract
type RecipientEmailCollection = original.RecipientEmailCollection
type RecipientEmailContract = original.RecipientEmailContract
type RecipientEmailContractProperties = original.RecipientEmailContractProperties
type RecipientUserCollection = original.RecipientUserCollection
type RecipientUserContract = original.RecipientUserContract
type RecipientUsersContractProperties = original.RecipientUsersContractProperties
type RecipientsContractProperties = original.RecipientsContractProperties
type RegionClient = original.RegionClient
type RegionContract = original.RegionContract
type RegionListResult = original.RegionListResult
type RegionListResultIterator = original.RegionListResultIterator
type RegionListResultPage = original.RegionListResultPage
type RegistrationDelegationSettingsProperties = original.RegistrationDelegationSettingsProperties
type RemotePrivateEndpointConnectionWrapper = original.RemotePrivateEndpointConnectionWrapper
type ReportCollection = original.ReportCollection
type ReportCollectionIterator = original.ReportCollectionIterator
type ReportCollectionPage = original.ReportCollectionPage
type ReportRecordContract = original.ReportRecordContract
type ReportsClient = original.ReportsClient
type RepresentationContract = original.RepresentationContract
type RequestContract = original.RequestContract
type RequestReportCollection = original.RequestReportCollection
type RequestReportRecordContract = original.RequestReportRecordContract
type Resource = original.Resource
type ResourceLocationDataContract = original.ResourceLocationDataContract
type ResourceSku = original.ResourceSku
type ResourceSkuCapacity = original.ResourceSkuCapacity
type ResourceSkuResult = original.ResourceSkuResult
type ResourceSkuResults = original.ResourceSkuResults
type ResourceSkuResultsIterator = original.ResourceSkuResultsIterator
type ResourceSkuResultsPage = original.ResourceSkuResultsPage
type ResponseContract = original.ResponseContract
type SamplingSettings = original.SamplingSettings
type SaveConfigurationParameter = original.SaveConfigurationParameter
type SaveConfigurationParameterProperties = original.SaveConfigurationParameterProperties
type SchemaCollection = original.SchemaCollection
type SchemaCollectionIterator = original.SchemaCollectionIterator
type SchemaCollectionPage = original.SchemaCollectionPage
type SchemaContract = original.SchemaContract
type SchemaContractProperties = original.SchemaContractProperties
type SchemaDocumentProperties = original.SchemaDocumentProperties
type ServiceApplyNetworkConfigurationParameters = original.ServiceApplyNetworkConfigurationParameters
type ServiceApplyNetworkConfigurationUpdatesFuture = original.ServiceApplyNetworkConfigurationUpdatesFuture
type ServiceBackupFuture = original.ServiceBackupFuture
type ServiceBackupRestoreParameters = original.ServiceBackupRestoreParameters
type ServiceBaseProperties = original.ServiceBaseProperties
type ServiceCheckNameAvailabilityParameters = original.ServiceCheckNameAvailabilityParameters
type ServiceClient = original.ServiceClient
type ServiceCreateOrUpdateFuture = original.ServiceCreateOrUpdateFuture
type ServiceDeleteFuture = original.ServiceDeleteFuture
type ServiceGetDomainOwnershipIdentifierResult = original.ServiceGetDomainOwnershipIdentifierResult
type ServiceGetSsoTokenResult = original.ServiceGetSsoTokenResult
type ServiceIdentity = original.ServiceIdentity
type ServiceListResult = original.ServiceListResult
type ServiceListResultIterator = original.ServiceListResultIterator
type ServiceListResultPage = original.ServiceListResultPage
type ServiceNameAvailabilityResult = original.ServiceNameAvailabilityResult
type ServiceProperties = original.ServiceProperties
type ServiceResource = original.ServiceResource
type ServiceRestoreFuture = original.ServiceRestoreFuture
type ServiceSkuProperties = original.ServiceSkuProperties
type ServiceSkusClient = original.ServiceSkusClient
type ServiceUpdateFuture = original.ServiceUpdateFuture
type ServiceUpdateParameters = original.ServiceUpdateParameters
type ServiceUpdateProperties = original.ServiceUpdateProperties
type SignInSettingsClient = original.SignInSettingsClient
type SignUpSettingsClient = original.SignUpSettingsClient
type Sku = original.Sku
type SkuCapabilities = original.SkuCapabilities
type SkuCapacity = original.SkuCapacity
type SkuCosts = original.SkuCosts
type SkuLocationInfo = original.SkuLocationInfo
type SkuRestrictionInfo = original.SkuRestrictionInfo
type SkuRestrictions = original.SkuRestrictions
type SkuZoneDetails = original.SkuZoneDetails
type SkusClient = original.SkusClient
type SkusResult = original.SkusResult
type SkusResultIterator = original.SkusResultIterator
type SkusResultPage = original.SkusResultPage
type SubscriptionClient = original.SubscriptionClient
type SubscriptionCollection = original.SubscriptionCollection
type SubscriptionCollectionIterator = original.SubscriptionCollectionIterator
type SubscriptionCollectionPage = original.SubscriptionCollectionPage
type SubscriptionContract = original.SubscriptionContract
type SubscriptionContractProperties = original.SubscriptionContractProperties
type SubscriptionCreateParameterProperties = original.SubscriptionCreateParameterProperties
type SubscriptionCreateParameters = original.SubscriptionCreateParameters
type SubscriptionKeyParameterNamesContract = original.SubscriptionKeyParameterNamesContract
type SubscriptionKeysContract = original.SubscriptionKeysContract
type SubscriptionUpdateParameterProperties = original.SubscriptionUpdateParameterProperties
type SubscriptionUpdateParameters = original.SubscriptionUpdateParameters
type SubscriptionsDelegationSettingsProperties = original.SubscriptionsDelegationSettingsProperties
type SystemData = original.SystemData
type TagClient = original.TagClient
type TagCollection = original.TagCollection
type TagCollectionIterator = original.TagCollectionIterator
type TagCollectionPage = original.TagCollectionPage
type TagContract = original.TagContract
type TagContractProperties = original.TagContractProperties
type TagCreateUpdateParameters = original.TagCreateUpdateParameters
type TagDescriptionBaseProperties = original.TagDescriptionBaseProperties
type TagDescriptionCollection = original.TagDescriptionCollection
type TagDescriptionCollectionIterator = original.TagDescriptionCollectionIterator
type TagDescriptionCollectionPage = original.TagDescriptionCollectionPage
type TagDescriptionContract = original.TagDescriptionContract
type TagDescriptionContractProperties = original.TagDescriptionContractProperties
type TagDescriptionCreateParameters = original.TagDescriptionCreateParameters
type TagResourceClient = original.TagResourceClient
type TagResourceCollection = original.TagResourceCollection
type TagResourceCollectionIterator = original.TagResourceCollectionIterator
type TagResourceCollectionPage = original.TagResourceCollectionPage
type TagResourceContract = original.TagResourceContract
type TagTagResourceContractProperties = original.TagTagResourceContractProperties
type TenantAccessClient = original.TenantAccessClient
type TenantAccessGitClient = original.TenantAccessGitClient
type TenantConfigurationClient = original.TenantConfigurationClient
type TenantConfigurationDeployFuture = original.TenantConfigurationDeployFuture
type TenantConfigurationSaveFuture = original.TenantConfigurationSaveFuture
type TenantConfigurationSyncStateContract = original.TenantConfigurationSyncStateContract
type TenantConfigurationSyncStateContractProperties = original.TenantConfigurationSyncStateContractProperties
type TenantConfigurationValidateFuture = original.TenantConfigurationValidateFuture
type TenantSettingsClient = original.TenantSettingsClient
type TenantSettingsCollection = original.TenantSettingsCollection
type TenantSettingsCollectionIterator = original.TenantSettingsCollectionIterator
type TenantSettingsCollectionPage = original.TenantSettingsCollectionPage
type TenantSettingsContract = original.TenantSettingsContract
type TenantSettingsContractProperties = original.TenantSettingsContractProperties
type TermsOfServiceProperties = original.TermsOfServiceProperties
type TokenBodyParameterContract = original.TokenBodyParameterContract
type TrackedResource = original.TrackedResource
type UserClient = original.UserClient
type UserCollection = original.UserCollection
type UserCollectionIterator = original.UserCollectionIterator
type UserCollectionPage = original.UserCollectionPage
type UserConfirmationPasswordClient = original.UserConfirmationPasswordClient
type UserContract = original.UserContract
type UserContractProperties = original.UserContractProperties
type UserCreateParameterProperties = original.UserCreateParameterProperties
type UserCreateParameters = original.UserCreateParameters
type UserEntityBaseParameters = original.UserEntityBaseParameters
type UserGroupClient = original.UserGroupClient
type UserIdentitiesClient = original.UserIdentitiesClient
type UserIdentityCollection = original.UserIdentityCollection
type UserIdentityCollectionIterator = original.UserIdentityCollectionIterator
type UserIdentityCollectionPage = original.UserIdentityCollectionPage
type UserIdentityContract = original.UserIdentityContract
type UserIdentityProperties = original.UserIdentityProperties
type UserSubscriptionClient = original.UserSubscriptionClient
type UserTokenParameterProperties = original.UserTokenParameterProperties
type UserTokenParameters = original.UserTokenParameters
type UserTokenResult = original.UserTokenResult
type UserUpdateParameters = original.UserUpdateParameters
type UserUpdateParametersProperties = original.UserUpdateParametersProperties
type VirtualNetworkConfiguration = original.VirtualNetworkConfiguration
type X509CertificateName = original.X509CertificateName

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAPIClient(subscriptionID string) APIClient {
	return original.NewAPIClient(subscriptionID)
}
func NewAPIClientWithBaseURI(baseURI string, subscriptionID string) APIClient {
	return original.NewAPIClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPICollectionIterator(page APICollectionPage) APICollectionIterator {
	return original.NewAPICollectionIterator(page)
}
func NewAPICollectionPage(cur APICollection, getNextPage func(context.Context, APICollection) (APICollection, error)) APICollectionPage {
	return original.NewAPICollectionPage(cur, getNextPage)
}
func NewAPIDiagnosticClient(subscriptionID string) APIDiagnosticClient {
	return original.NewAPIDiagnosticClient(subscriptionID)
}
func NewAPIDiagnosticClientWithBaseURI(baseURI string, subscriptionID string) APIDiagnosticClient {
	return original.NewAPIDiagnosticClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIExportClient(subscriptionID string) APIExportClient {
	return original.NewAPIExportClient(subscriptionID)
}
func NewAPIExportClientWithBaseURI(baseURI string, subscriptionID string) APIExportClient {
	return original.NewAPIExportClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIIssueAttachmentClient(subscriptionID string) APIIssueAttachmentClient {
	return original.NewAPIIssueAttachmentClient(subscriptionID)
}
func NewAPIIssueAttachmentClientWithBaseURI(baseURI string, subscriptionID string) APIIssueAttachmentClient {
	return original.NewAPIIssueAttachmentClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIIssueClient(subscriptionID string) APIIssueClient {
	return original.NewAPIIssueClient(subscriptionID)
}
func NewAPIIssueClientWithBaseURI(baseURI string, subscriptionID string) APIIssueClient {
	return original.NewAPIIssueClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIIssueCommentClient(subscriptionID string) APIIssueCommentClient {
	return original.NewAPIIssueCommentClient(subscriptionID)
}
func NewAPIIssueCommentClientWithBaseURI(baseURI string, subscriptionID string) APIIssueCommentClient {
	return original.NewAPIIssueCommentClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIOperationClient(subscriptionID string) APIOperationClient {
	return original.NewAPIOperationClient(subscriptionID)
}
func NewAPIOperationClientWithBaseURI(baseURI string, subscriptionID string) APIOperationClient {
	return original.NewAPIOperationClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIOperationPolicyClient(subscriptionID string) APIOperationPolicyClient {
	return original.NewAPIOperationPolicyClient(subscriptionID)
}
func NewAPIOperationPolicyClientWithBaseURI(baseURI string, subscriptionID string) APIOperationPolicyClient {
	return original.NewAPIOperationPolicyClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIPolicyClient(subscriptionID string) APIPolicyClient {
	return original.NewAPIPolicyClient(subscriptionID)
}
func NewAPIPolicyClientWithBaseURI(baseURI string, subscriptionID string) APIPolicyClient {
	return original.NewAPIPolicyClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIProductClient(subscriptionID string) APIProductClient {
	return original.NewAPIProductClient(subscriptionID)
}
func NewAPIProductClientWithBaseURI(baseURI string, subscriptionID string) APIProductClient {
	return original.NewAPIProductClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIReleaseClient(subscriptionID string) APIReleaseClient {
	return original.NewAPIReleaseClient(subscriptionID)
}
func NewAPIReleaseClientWithBaseURI(baseURI string, subscriptionID string) APIReleaseClient {
	return original.NewAPIReleaseClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIReleaseCollectionIterator(page APIReleaseCollectionPage) APIReleaseCollectionIterator {
	return original.NewAPIReleaseCollectionIterator(page)
}
func NewAPIReleaseCollectionPage(cur APIReleaseCollection, getNextPage func(context.Context, APIReleaseCollection) (APIReleaseCollection, error)) APIReleaseCollectionPage {
	return original.NewAPIReleaseCollectionPage(cur, getNextPage)
}
func NewAPIRevisionClient(subscriptionID string) APIRevisionClient {
	return original.NewAPIRevisionClient(subscriptionID)
}
func NewAPIRevisionClientWithBaseURI(baseURI string, subscriptionID string) APIRevisionClient {
	return original.NewAPIRevisionClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIRevisionCollectionIterator(page APIRevisionCollectionPage) APIRevisionCollectionIterator {
	return original.NewAPIRevisionCollectionIterator(page)
}
func NewAPIRevisionCollectionPage(cur APIRevisionCollection, getNextPage func(context.Context, APIRevisionCollection) (APIRevisionCollection, error)) APIRevisionCollectionPage {
	return original.NewAPIRevisionCollectionPage(cur, getNextPage)
}
func NewAPISchemaClient(subscriptionID string) APISchemaClient {
	return original.NewAPISchemaClient(subscriptionID)
}
func NewAPISchemaClientWithBaseURI(baseURI string, subscriptionID string) APISchemaClient {
	return original.NewAPISchemaClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPITagDescriptionClient(subscriptionID string) APITagDescriptionClient {
	return original.NewAPITagDescriptionClient(subscriptionID)
}
func NewAPITagDescriptionClientWithBaseURI(baseURI string, subscriptionID string) APITagDescriptionClient {
	return original.NewAPITagDescriptionClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIVersionSetClient(subscriptionID string) APIVersionSetClient {
	return original.NewAPIVersionSetClient(subscriptionID)
}
func NewAPIVersionSetClientWithBaseURI(baseURI string, subscriptionID string) APIVersionSetClient {
	return original.NewAPIVersionSetClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIVersionSetCollectionIterator(page APIVersionSetCollectionPage) APIVersionSetCollectionIterator {
	return original.NewAPIVersionSetCollectionIterator(page)
}
func NewAPIVersionSetCollectionPage(cur APIVersionSetCollection, getNextPage func(context.Context, APIVersionSetCollection) (APIVersionSetCollection, error)) APIVersionSetCollectionPage {
	return original.NewAPIVersionSetCollectionPage(cur, getNextPage)
}
func NewAccessInformationCollectionIterator(page AccessInformationCollectionPage) AccessInformationCollectionIterator {
	return original.NewAccessInformationCollectionIterator(page)
}
func NewAccessInformationCollectionPage(cur AccessInformationCollection, getNextPage func(context.Context, AccessInformationCollection) (AccessInformationCollection, error)) AccessInformationCollectionPage {
	return original.NewAccessInformationCollectionPage(cur, getNextPage)
}
func NewAuthorizationServerClient(subscriptionID string) AuthorizationServerClient {
	return original.NewAuthorizationServerClient(subscriptionID)
}
func NewAuthorizationServerClientWithBaseURI(baseURI string, subscriptionID string) AuthorizationServerClient {
	return original.NewAuthorizationServerClientWithBaseURI(baseURI, subscriptionID)
}
func NewAuthorizationServerCollectionIterator(page AuthorizationServerCollectionPage) AuthorizationServerCollectionIterator {
	return original.NewAuthorizationServerCollectionIterator(page)
}
func NewAuthorizationServerCollectionPage(cur AuthorizationServerCollection, getNextPage func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)) AuthorizationServerCollectionPage {
	return original.NewAuthorizationServerCollectionPage(cur, getNextPage)
}
func NewBackendClient(subscriptionID string) BackendClient {
	return original.NewBackendClient(subscriptionID)
}
func NewBackendClientWithBaseURI(baseURI string, subscriptionID string) BackendClient {
	return original.NewBackendClientWithBaseURI(baseURI, subscriptionID)
}
func NewBackendCollectionIterator(page BackendCollectionPage) BackendCollectionIterator {
	return original.NewBackendCollectionIterator(page)
}
func NewBackendCollectionPage(cur BackendCollection, getNextPage func(context.Context, BackendCollection) (BackendCollection, error)) BackendCollectionPage {
	return original.NewBackendCollectionPage(cur, getNextPage)
}
func NewCacheClient(subscriptionID string) CacheClient {
	return original.NewCacheClient(subscriptionID)
}
func NewCacheClientWithBaseURI(baseURI string, subscriptionID string) CacheClient {
	return original.NewCacheClientWithBaseURI(baseURI, subscriptionID)
}
func NewCacheCollectionIterator(page CacheCollectionPage) CacheCollectionIterator {
	return original.NewCacheCollectionIterator(page)
}
func NewCacheCollectionPage(cur CacheCollection, getNextPage func(context.Context, CacheCollection) (CacheCollection, error)) CacheCollectionPage {
	return original.NewCacheCollectionPage(cur, getNextPage)
}
func NewCertificateClient(subscriptionID string) CertificateClient {
	return original.NewCertificateClient(subscriptionID)
}
func NewCertificateClientWithBaseURI(baseURI string, subscriptionID string) CertificateClient {
	return original.NewCertificateClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return original.NewCertificateCollectionIterator(page)
}
func NewCertificateCollectionPage(cur CertificateCollection, getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return original.NewCertificateCollectionPage(cur, getNextPage)
}
func NewContentItemClient(subscriptionID string) ContentItemClient {
	return original.NewContentItemClient(subscriptionID)
}
func NewContentItemClientWithBaseURI(baseURI string, subscriptionID string) ContentItemClient {
	return original.NewContentItemClientWithBaseURI(baseURI, subscriptionID)
}
func NewContentItemCollectionIterator(page ContentItemCollectionPage) ContentItemCollectionIterator {
	return original.NewContentItemCollectionIterator(page)
}
func NewContentItemCollectionPage(cur ContentItemCollection, getNextPage func(context.Context, ContentItemCollection) (ContentItemCollection, error)) ContentItemCollectionPage {
	return original.NewContentItemCollectionPage(cur, getNextPage)
}
func NewContentTypeClient(subscriptionID string) ContentTypeClient {
	return original.NewContentTypeClient(subscriptionID)
}
func NewContentTypeClientWithBaseURI(baseURI string, subscriptionID string) ContentTypeClient {
	return original.NewContentTypeClientWithBaseURI(baseURI, subscriptionID)
}
func NewContentTypeCollectionIterator(page ContentTypeCollectionPage) ContentTypeCollectionIterator {
	return original.NewContentTypeCollectionIterator(page)
}
func NewContentTypeCollectionPage(cur ContentTypeCollection, getNextPage func(context.Context, ContentTypeCollection) (ContentTypeCollection, error)) ContentTypeCollectionPage {
	return original.NewContentTypeCollectionPage(cur, getNextPage)
}
func NewDelegationSettingsClient(subscriptionID string) DelegationSettingsClient {
	return original.NewDelegationSettingsClient(subscriptionID)
}
func NewDelegationSettingsClientWithBaseURI(baseURI string, subscriptionID string) DelegationSettingsClient {
	return original.NewDelegationSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDeletedServicesClient(subscriptionID string) DeletedServicesClient {
	return original.NewDeletedServicesClient(subscriptionID)
}
func NewDeletedServicesClientWithBaseURI(baseURI string, subscriptionID string) DeletedServicesClient {
	return original.NewDeletedServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDeletedServicesCollectionIterator(page DeletedServicesCollectionPage) DeletedServicesCollectionIterator {
	return original.NewDeletedServicesCollectionIterator(page)
}
func NewDeletedServicesCollectionPage(cur DeletedServicesCollection, getNextPage func(context.Context, DeletedServicesCollection) (DeletedServicesCollection, error)) DeletedServicesCollectionPage {
	return original.NewDeletedServicesCollectionPage(cur, getNextPage)
}
func NewDiagnosticClient(subscriptionID string) DiagnosticClient {
	return original.NewDiagnosticClient(subscriptionID)
}
func NewDiagnosticClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticClient {
	return original.NewDiagnosticClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiagnosticCollectionIterator(page DiagnosticCollectionPage) DiagnosticCollectionIterator {
	return original.NewDiagnosticCollectionIterator(page)
}
func NewDiagnosticCollectionPage(cur DiagnosticCollection, getNextPage func(context.Context, DiagnosticCollection) (DiagnosticCollection, error)) DiagnosticCollectionPage {
	return original.NewDiagnosticCollectionPage(cur, getNextPage)
}
func NewEmailTemplateClient(subscriptionID string) EmailTemplateClient {
	return original.NewEmailTemplateClient(subscriptionID)
}
func NewEmailTemplateClientWithBaseURI(baseURI string, subscriptionID string) EmailTemplateClient {
	return original.NewEmailTemplateClientWithBaseURI(baseURI, subscriptionID)
}
func NewEmailTemplateCollectionIterator(page EmailTemplateCollectionPage) EmailTemplateCollectionIterator {
	return original.NewEmailTemplateCollectionIterator(page)
}
func NewEmailTemplateCollectionPage(cur EmailTemplateCollection, getNextPage func(context.Context, EmailTemplateCollection) (EmailTemplateCollection, error)) EmailTemplateCollectionPage {
	return original.NewEmailTemplateCollectionPage(cur, getNextPage)
}
func NewGatewayAPIClient(subscriptionID string) GatewayAPIClient {
	return original.NewGatewayAPIClient(subscriptionID)
}
func NewGatewayAPIClientWithBaseURI(baseURI string, subscriptionID string) GatewayAPIClient {
	return original.NewGatewayAPIClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewayCertificateAuthorityClient(subscriptionID string) GatewayCertificateAuthorityClient {
	return original.NewGatewayCertificateAuthorityClient(subscriptionID)
}
func NewGatewayCertificateAuthorityClientWithBaseURI(baseURI string, subscriptionID string) GatewayCertificateAuthorityClient {
	return original.NewGatewayCertificateAuthorityClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewayCertificateAuthorityCollectionIterator(page GatewayCertificateAuthorityCollectionPage) GatewayCertificateAuthorityCollectionIterator {
	return original.NewGatewayCertificateAuthorityCollectionIterator(page)
}
func NewGatewayCertificateAuthorityCollectionPage(cur GatewayCertificateAuthorityCollection, getNextPage func(context.Context, GatewayCertificateAuthorityCollection) (GatewayCertificateAuthorityCollection, error)) GatewayCertificateAuthorityCollectionPage {
	return original.NewGatewayCertificateAuthorityCollectionPage(cur, getNextPage)
}
func NewGatewayClient(subscriptionID string) GatewayClient {
	return original.NewGatewayClient(subscriptionID)
}
func NewGatewayClientWithBaseURI(baseURI string, subscriptionID string) GatewayClient {
	return original.NewGatewayClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewayCollectionIterator(page GatewayCollectionPage) GatewayCollectionIterator {
	return original.NewGatewayCollectionIterator(page)
}
func NewGatewayCollectionPage(cur GatewayCollection, getNextPage func(context.Context, GatewayCollection) (GatewayCollection, error)) GatewayCollectionPage {
	return original.NewGatewayCollectionPage(cur, getNextPage)
}
func NewGatewayHostnameConfigurationClient(subscriptionID string) GatewayHostnameConfigurationClient {
	return original.NewGatewayHostnameConfigurationClient(subscriptionID)
}
func NewGatewayHostnameConfigurationClientWithBaseURI(baseURI string, subscriptionID string) GatewayHostnameConfigurationClient {
	return original.NewGatewayHostnameConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewayHostnameConfigurationCollectionIterator(page GatewayHostnameConfigurationCollectionPage) GatewayHostnameConfigurationCollectionIterator {
	return original.NewGatewayHostnameConfigurationCollectionIterator(page)
}
func NewGatewayHostnameConfigurationCollectionPage(cur GatewayHostnameConfigurationCollection, getNextPage func(context.Context, GatewayHostnameConfigurationCollection) (GatewayHostnameConfigurationCollection, error)) GatewayHostnameConfigurationCollectionPage {
	return original.NewGatewayHostnameConfigurationCollectionPage(cur, getNextPage)
}
func NewGroupClient(subscriptionID string) GroupClient {
	return original.NewGroupClient(subscriptionID)
}
func NewGroupClientWithBaseURI(baseURI string, subscriptionID string) GroupClient {
	return original.NewGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewGroupCollectionIterator(page GroupCollectionPage) GroupCollectionIterator {
	return original.NewGroupCollectionIterator(page)
}
func NewGroupCollectionPage(cur GroupCollection, getNextPage func(context.Context, GroupCollection) (GroupCollection, error)) GroupCollectionPage {
	return original.NewGroupCollectionPage(cur, getNextPage)
}
func NewGroupUserClient(subscriptionID string) GroupUserClient {
	return original.NewGroupUserClient(subscriptionID)
}
func NewGroupUserClientWithBaseURI(baseURI string, subscriptionID string) GroupUserClient {
	return original.NewGroupUserClientWithBaseURI(baseURI, subscriptionID)
}
func NewIdentityProviderClient(subscriptionID string) IdentityProviderClient {
	return original.NewIdentityProviderClient(subscriptionID)
}
func NewIdentityProviderClientWithBaseURI(baseURI string, subscriptionID string) IdentityProviderClient {
	return original.NewIdentityProviderClientWithBaseURI(baseURI, subscriptionID)
}
func NewIdentityProviderListIterator(page IdentityProviderListPage) IdentityProviderListIterator {
	return original.NewIdentityProviderListIterator(page)
}
func NewIdentityProviderListPage(cur IdentityProviderList, getNextPage func(context.Context, IdentityProviderList) (IdentityProviderList, error)) IdentityProviderListPage {
	return original.NewIdentityProviderListPage(cur, getNextPage)
}
func NewIssueAttachmentCollectionIterator(page IssueAttachmentCollectionPage) IssueAttachmentCollectionIterator {
	return original.NewIssueAttachmentCollectionIterator(page)
}
func NewIssueAttachmentCollectionPage(cur IssueAttachmentCollection, getNextPage func(context.Context, IssueAttachmentCollection) (IssueAttachmentCollection, error)) IssueAttachmentCollectionPage {
	return original.NewIssueAttachmentCollectionPage(cur, getNextPage)
}
func NewIssueClient(subscriptionID string) IssueClient {
	return original.NewIssueClient(subscriptionID)
}
func NewIssueClientWithBaseURI(baseURI string, subscriptionID string) IssueClient {
	return original.NewIssueClientWithBaseURI(baseURI, subscriptionID)
}
func NewIssueCollectionIterator(page IssueCollectionPage) IssueCollectionIterator {
	return original.NewIssueCollectionIterator(page)
}
func NewIssueCollectionPage(cur IssueCollection, getNextPage func(context.Context, IssueCollection) (IssueCollection, error)) IssueCollectionPage {
	return original.NewIssueCollectionPage(cur, getNextPage)
}
func NewIssueCommentCollectionIterator(page IssueCommentCollectionPage) IssueCommentCollectionIterator {
	return original.NewIssueCommentCollectionIterator(page)
}
func NewIssueCommentCollectionPage(cur IssueCommentCollection, getNextPage func(context.Context, IssueCommentCollection) (IssueCommentCollection, error)) IssueCommentCollectionPage {
	return original.NewIssueCommentCollectionPage(cur, getNextPage)
}
func NewLoggerClient(subscriptionID string) LoggerClient {
	return original.NewLoggerClient(subscriptionID)
}
func NewLoggerClientWithBaseURI(baseURI string, subscriptionID string) LoggerClient {
	return original.NewLoggerClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoggerCollectionIterator(page LoggerCollectionPage) LoggerCollectionIterator {
	return original.NewLoggerCollectionIterator(page)
}
func NewLoggerCollectionPage(cur LoggerCollection, getNextPage func(context.Context, LoggerCollection) (LoggerCollection, error)) LoggerCollectionPage {
	return original.NewLoggerCollectionPage(cur, getNextPage)
}
func NewNamedValueClient(subscriptionID string) NamedValueClient {
	return original.NewNamedValueClient(subscriptionID)
}
func NewNamedValueClientWithBaseURI(baseURI string, subscriptionID string) NamedValueClient {
	return original.NewNamedValueClientWithBaseURI(baseURI, subscriptionID)
}
func NewNamedValueCollectionIterator(page NamedValueCollectionPage) NamedValueCollectionIterator {
	return original.NewNamedValueCollectionIterator(page)
}
func NewNamedValueCollectionPage(cur NamedValueCollection, getNextPage func(context.Context, NamedValueCollection) (NamedValueCollection, error)) NamedValueCollectionPage {
	return original.NewNamedValueCollectionPage(cur, getNextPage)
}
func NewNetworkStatusClient(subscriptionID string) NetworkStatusClient {
	return original.NewNetworkStatusClient(subscriptionID)
}
func NewNetworkStatusClientWithBaseURI(baseURI string, subscriptionID string) NetworkStatusClient {
	return original.NewNetworkStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewNotificationClient(subscriptionID string) NotificationClient {
	return original.NewNotificationClient(subscriptionID)
}
func NewNotificationClientWithBaseURI(baseURI string, subscriptionID string) NotificationClient {
	return original.NewNotificationClientWithBaseURI(baseURI, subscriptionID)
}
func NewNotificationCollectionIterator(page NotificationCollectionPage) NotificationCollectionIterator {
	return original.NewNotificationCollectionIterator(page)
}
func NewNotificationCollectionPage(cur NotificationCollection, getNextPage func(context.Context, NotificationCollection) (NotificationCollection, error)) NotificationCollectionPage {
	return original.NewNotificationCollectionPage(cur, getNextPage)
}
func NewNotificationRecipientEmailClient(subscriptionID string) NotificationRecipientEmailClient {
	return original.NewNotificationRecipientEmailClient(subscriptionID)
}
func NewNotificationRecipientEmailClientWithBaseURI(baseURI string, subscriptionID string) NotificationRecipientEmailClient {
	return original.NewNotificationRecipientEmailClientWithBaseURI(baseURI, subscriptionID)
}
func NewNotificationRecipientUserClient(subscriptionID string) NotificationRecipientUserClient {
	return original.NewNotificationRecipientUserClient(subscriptionID)
}
func NewNotificationRecipientUserClientWithBaseURI(baseURI string, subscriptionID string) NotificationRecipientUserClient {
	return original.NewNotificationRecipientUserClientWithBaseURI(baseURI, subscriptionID)
}
func NewOpenIDConnectProviderClient(subscriptionID string) OpenIDConnectProviderClient {
	return original.NewOpenIDConnectProviderClient(subscriptionID)
}
func NewOpenIDConnectProviderClientWithBaseURI(baseURI string, subscriptionID string) OpenIDConnectProviderClient {
	return original.NewOpenIDConnectProviderClientWithBaseURI(baseURI, subscriptionID)
}
func NewOpenIDConnectProviderCollectionIterator(page OpenIDConnectProviderCollectionPage) OpenIDConnectProviderCollectionIterator {
	return original.NewOpenIDConnectProviderCollectionIterator(page)
}
func NewOpenIDConnectProviderCollectionPage(cur OpenIDConnectProviderCollection, getNextPage func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)) OpenIDConnectProviderCollectionPage {
	return original.NewOpenIDConnectProviderCollectionPage(cur, getNextPage)
}
func NewOperationClient(subscriptionID string) OperationClient {
	return original.NewOperationClient(subscriptionID)
}
func NewOperationClientWithBaseURI(baseURI string, subscriptionID string) OperationClient {
	return original.NewOperationClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationCollectionIterator(page OperationCollectionPage) OperationCollectionIterator {
	return original.NewOperationCollectionIterator(page)
}
func NewOperationCollectionPage(cur OperationCollection, getNextPage func(context.Context, OperationCollection) (OperationCollection, error)) OperationCollectionPage {
	return original.NewOperationCollectionPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOutboundNetworkDependenciesEndpointsClient(subscriptionID string) OutboundNetworkDependenciesEndpointsClient {
	return original.NewOutboundNetworkDependenciesEndpointsClient(subscriptionID)
}
func NewOutboundNetworkDependenciesEndpointsClientWithBaseURI(baseURI string, subscriptionID string) OutboundNetworkDependenciesEndpointsClient {
	return original.NewOutboundNetworkDependenciesEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPolicyClient(subscriptionID string) PolicyClient {
	return original.NewPolicyClient(subscriptionID)
}
func NewPolicyClientWithBaseURI(baseURI string, subscriptionID string) PolicyClient {
	return original.NewPolicyClientWithBaseURI(baseURI, subscriptionID)
}
func NewPolicyDescriptionClient(subscriptionID string) PolicyDescriptionClient {
	return original.NewPolicyDescriptionClient(subscriptionID)
}
func NewPolicyDescriptionClientWithBaseURI(baseURI string, subscriptionID string) PolicyDescriptionClient {
	return original.NewPolicyDescriptionClientWithBaseURI(baseURI, subscriptionID)
}
func NewPortalRevisionClient(subscriptionID string) PortalRevisionClient {
	return original.NewPortalRevisionClient(subscriptionID)
}
func NewPortalRevisionClientWithBaseURI(baseURI string, subscriptionID string) PortalRevisionClient {
	return original.NewPortalRevisionClientWithBaseURI(baseURI, subscriptionID)
}
func NewPortalRevisionCollectionIterator(page PortalRevisionCollectionPage) PortalRevisionCollectionIterator {
	return original.NewPortalRevisionCollectionIterator(page)
}
func NewPortalRevisionCollectionPage(cur PortalRevisionCollection, getNextPage func(context.Context, PortalRevisionCollection) (PortalRevisionCollection, error)) PortalRevisionCollectionPage {
	return original.NewPortalRevisionCollectionPage(cur, getNextPage)
}
func NewPortalSettingsClient(subscriptionID string) PortalSettingsClient {
	return original.NewPortalSettingsClient(subscriptionID)
}
func NewPortalSettingsClientWithBaseURI(baseURI string, subscriptionID string) PortalSettingsClient {
	return original.NewPortalSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionClient(subscriptionID string) PrivateEndpointConnectionClient {
	return original.NewPrivateEndpointConnectionClient(subscriptionID)
}
func NewPrivateEndpointConnectionClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionClient {
	return original.NewPrivateEndpointConnectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewProductAPIClient(subscriptionID string) ProductAPIClient {
	return original.NewProductAPIClient(subscriptionID)
}
func NewProductAPIClientWithBaseURI(baseURI string, subscriptionID string) ProductAPIClient {
	return original.NewProductAPIClientWithBaseURI(baseURI, subscriptionID)
}
func NewProductClient(subscriptionID string) ProductClient {
	return original.NewProductClient(subscriptionID)
}
func NewProductClientWithBaseURI(baseURI string, subscriptionID string) ProductClient {
	return original.NewProductClientWithBaseURI(baseURI, subscriptionID)
}
func NewProductCollectionIterator(page ProductCollectionPage) ProductCollectionIterator {
	return original.NewProductCollectionIterator(page)
}
func NewProductCollectionPage(cur ProductCollection, getNextPage func(context.Context, ProductCollection) (ProductCollection, error)) ProductCollectionPage {
	return original.NewProductCollectionPage(cur, getNextPage)
}
func NewProductGroupClient(subscriptionID string) ProductGroupClient {
	return original.NewProductGroupClient(subscriptionID)
}
func NewProductGroupClientWithBaseURI(baseURI string, subscriptionID string) ProductGroupClient {
	return original.NewProductGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewProductPolicyClient(subscriptionID string) ProductPolicyClient {
	return original.NewProductPolicyClient(subscriptionID)
}
func NewProductPolicyClientWithBaseURI(baseURI string, subscriptionID string) ProductPolicyClient {
	return original.NewProductPolicyClientWithBaseURI(baseURI, subscriptionID)
}
func NewProductSubscriptionsClient(subscriptionID string) ProductSubscriptionsClient {
	return original.NewProductSubscriptionsClient(subscriptionID)
}
func NewProductSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) ProductSubscriptionsClient {
	return original.NewProductSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewQuotaByCounterKeysClient(subscriptionID string) QuotaByCounterKeysClient {
	return original.NewQuotaByCounterKeysClient(subscriptionID)
}
func NewQuotaByCounterKeysClientWithBaseURI(baseURI string, subscriptionID string) QuotaByCounterKeysClient {
	return original.NewQuotaByCounterKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewQuotaByPeriodKeysClient(subscriptionID string) QuotaByPeriodKeysClient {
	return original.NewQuotaByPeriodKeysClient(subscriptionID)
}
func NewQuotaByPeriodKeysClientWithBaseURI(baseURI string, subscriptionID string) QuotaByPeriodKeysClient {
	return original.NewQuotaByPeriodKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegionClient(subscriptionID string) RegionClient {
	return original.NewRegionClient(subscriptionID)
}
func NewRegionClientWithBaseURI(baseURI string, subscriptionID string) RegionClient {
	return original.NewRegionClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegionListResultIterator(page RegionListResultPage) RegionListResultIterator {
	return original.NewRegionListResultIterator(page)
}
func NewRegionListResultPage(cur RegionListResult, getNextPage func(context.Context, RegionListResult) (RegionListResult, error)) RegionListResultPage {
	return original.NewRegionListResultPage(cur, getNextPage)
}
func NewReportCollectionIterator(page ReportCollectionPage) ReportCollectionIterator {
	return original.NewReportCollectionIterator(page)
}
func NewReportCollectionPage(cur ReportCollection, getNextPage func(context.Context, ReportCollection) (ReportCollection, error)) ReportCollectionPage {
	return original.NewReportCollectionPage(cur, getNextPage)
}
func NewReportsClient(subscriptionID string) ReportsClient {
	return original.NewReportsClient(subscriptionID)
}
func NewReportsClientWithBaseURI(baseURI string, subscriptionID string) ReportsClient {
	return original.NewReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkuResultsIterator(page ResourceSkuResultsPage) ResourceSkuResultsIterator {
	return original.NewResourceSkuResultsIterator(page)
}
func NewResourceSkuResultsPage(cur ResourceSkuResults, getNextPage func(context.Context, ResourceSkuResults) (ResourceSkuResults, error)) ResourceSkuResultsPage {
	return original.NewResourceSkuResultsPage(cur, getNextPage)
}
func NewSchemaCollectionIterator(page SchemaCollectionPage) SchemaCollectionIterator {
	return original.NewSchemaCollectionIterator(page)
}
func NewSchemaCollectionPage(cur SchemaCollection, getNextPage func(context.Context, SchemaCollection) (SchemaCollection, error)) SchemaCollectionPage {
	return original.NewSchemaCollectionPage(cur, getNextPage)
}
func NewServiceClient(subscriptionID string) ServiceClient {
	return original.NewServiceClient(subscriptionID)
}
func NewServiceClientWithBaseURI(baseURI string, subscriptionID string) ServiceClient {
	return original.NewServiceClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceListResultIterator(page ServiceListResultPage) ServiceListResultIterator {
	return original.NewServiceListResultIterator(page)
}
func NewServiceListResultPage(cur ServiceListResult, getNextPage func(context.Context, ServiceListResult) (ServiceListResult, error)) ServiceListResultPage {
	return original.NewServiceListResultPage(cur, getNextPage)
}
func NewServiceSkusClient(subscriptionID string) ServiceSkusClient {
	return original.NewServiceSkusClient(subscriptionID)
}
func NewServiceSkusClientWithBaseURI(baseURI string, subscriptionID string) ServiceSkusClient {
	return original.NewServiceSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewSignInSettingsClient(subscriptionID string) SignInSettingsClient {
	return original.NewSignInSettingsClient(subscriptionID)
}
func NewSignInSettingsClientWithBaseURI(baseURI string, subscriptionID string) SignInSettingsClient {
	return original.NewSignInSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSignUpSettingsClient(subscriptionID string) SignUpSettingsClient {
	return original.NewSignUpSettingsClient(subscriptionID)
}
func NewSignUpSettingsClientWithBaseURI(baseURI string, subscriptionID string) SignUpSettingsClient {
	return original.NewSignUpSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSkusClient(subscriptionID string) SkusClient {
	return original.NewSkusClient(subscriptionID)
}
func NewSkusClientWithBaseURI(baseURI string, subscriptionID string) SkusClient {
	return original.NewSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewSkusResultIterator(page SkusResultPage) SkusResultIterator {
	return original.NewSkusResultIterator(page)
}
func NewSkusResultPage(cur SkusResult, getNextPage func(context.Context, SkusResult) (SkusResult, error)) SkusResultPage {
	return original.NewSkusResultPage(cur, getNextPage)
}
func NewSubscriptionClient(subscriptionID string) SubscriptionClient {
	return original.NewSubscriptionClient(subscriptionID)
}
func NewSubscriptionClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionClient {
	return original.NewSubscriptionClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubscriptionCollectionIterator(page SubscriptionCollectionPage) SubscriptionCollectionIterator {
	return original.NewSubscriptionCollectionIterator(page)
}
func NewSubscriptionCollectionPage(cur SubscriptionCollection, getNextPage func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)) SubscriptionCollectionPage {
	return original.NewSubscriptionCollectionPage(cur, getNextPage)
}
func NewTagClient(subscriptionID string) TagClient {
	return original.NewTagClient(subscriptionID)
}
func NewTagClientWithBaseURI(baseURI string, subscriptionID string) TagClient {
	return original.NewTagClientWithBaseURI(baseURI, subscriptionID)
}
func NewTagCollectionIterator(page TagCollectionPage) TagCollectionIterator {
	return original.NewTagCollectionIterator(page)
}
func NewTagCollectionPage(cur TagCollection, getNextPage func(context.Context, TagCollection) (TagCollection, error)) TagCollectionPage {
	return original.NewTagCollectionPage(cur, getNextPage)
}
func NewTagDescriptionCollectionIterator(page TagDescriptionCollectionPage) TagDescriptionCollectionIterator {
	return original.NewTagDescriptionCollectionIterator(page)
}
func NewTagDescriptionCollectionPage(cur TagDescriptionCollection, getNextPage func(context.Context, TagDescriptionCollection) (TagDescriptionCollection, error)) TagDescriptionCollectionPage {
	return original.NewTagDescriptionCollectionPage(cur, getNextPage)
}
func NewTagResourceClient(subscriptionID string) TagResourceClient {
	return original.NewTagResourceClient(subscriptionID)
}
func NewTagResourceClientWithBaseURI(baseURI string, subscriptionID string) TagResourceClient {
	return original.NewTagResourceClientWithBaseURI(baseURI, subscriptionID)
}
func NewTagResourceCollectionIterator(page TagResourceCollectionPage) TagResourceCollectionIterator {
	return original.NewTagResourceCollectionIterator(page)
}
func NewTagResourceCollectionPage(cur TagResourceCollection, getNextPage func(context.Context, TagResourceCollection) (TagResourceCollection, error)) TagResourceCollectionPage {
	return original.NewTagResourceCollectionPage(cur, getNextPage)
}
func NewTenantAccessClient(subscriptionID string) TenantAccessClient {
	return original.NewTenantAccessClient(subscriptionID)
}
func NewTenantAccessClientWithBaseURI(baseURI string, subscriptionID string) TenantAccessClient {
	return original.NewTenantAccessClientWithBaseURI(baseURI, subscriptionID)
}
func NewTenantAccessGitClient(subscriptionID string) TenantAccessGitClient {
	return original.NewTenantAccessGitClient(subscriptionID)
}
func NewTenantAccessGitClientWithBaseURI(baseURI string, subscriptionID string) TenantAccessGitClient {
	return original.NewTenantAccessGitClientWithBaseURI(baseURI, subscriptionID)
}
func NewTenantConfigurationClient(subscriptionID string) TenantConfigurationClient {
	return original.NewTenantConfigurationClient(subscriptionID)
}
func NewTenantConfigurationClientWithBaseURI(baseURI string, subscriptionID string) TenantConfigurationClient {
	return original.NewTenantConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewTenantSettingsClient(subscriptionID string) TenantSettingsClient {
	return original.NewTenantSettingsClient(subscriptionID)
}
func NewTenantSettingsClientWithBaseURI(baseURI string, subscriptionID string) TenantSettingsClient {
	return original.NewTenantSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTenantSettingsCollectionIterator(page TenantSettingsCollectionPage) TenantSettingsCollectionIterator {
	return original.NewTenantSettingsCollectionIterator(page)
}
func NewTenantSettingsCollectionPage(cur TenantSettingsCollection, getNextPage func(context.Context, TenantSettingsCollection) (TenantSettingsCollection, error)) TenantSettingsCollectionPage {
	return original.NewTenantSettingsCollectionPage(cur, getNextPage)
}
func NewUserClient(subscriptionID string) UserClient {
	return original.NewUserClient(subscriptionID)
}
func NewUserClientWithBaseURI(baseURI string, subscriptionID string) UserClient {
	return original.NewUserClientWithBaseURI(baseURI, subscriptionID)
}
func NewUserCollectionIterator(page UserCollectionPage) UserCollectionIterator {
	return original.NewUserCollectionIterator(page)
}
func NewUserCollectionPage(cur UserCollection, getNextPage func(context.Context, UserCollection) (UserCollection, error)) UserCollectionPage {
	return original.NewUserCollectionPage(cur, getNextPage)
}
func NewUserConfirmationPasswordClient(subscriptionID string) UserConfirmationPasswordClient {
	return original.NewUserConfirmationPasswordClient(subscriptionID)
}
func NewUserConfirmationPasswordClientWithBaseURI(baseURI string, subscriptionID string) UserConfirmationPasswordClient {
	return original.NewUserConfirmationPasswordClientWithBaseURI(baseURI, subscriptionID)
}
func NewUserGroupClient(subscriptionID string) UserGroupClient {
	return original.NewUserGroupClient(subscriptionID)
}
func NewUserGroupClientWithBaseURI(baseURI string, subscriptionID string) UserGroupClient {
	return original.NewUserGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewUserIdentitiesClient(subscriptionID string) UserIdentitiesClient {
	return original.NewUserIdentitiesClient(subscriptionID)
}
func NewUserIdentitiesClientWithBaseURI(baseURI string, subscriptionID string) UserIdentitiesClient {
	return original.NewUserIdentitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewUserIdentityCollectionIterator(page UserIdentityCollectionPage) UserIdentityCollectionIterator {
	return original.NewUserIdentityCollectionIterator(page)
}
func NewUserIdentityCollectionPage(cur UserIdentityCollection, getNextPage func(context.Context, UserIdentityCollection) (UserIdentityCollection, error)) UserIdentityCollectionPage {
	return original.NewUserIdentityCollectionPage(cur, getNextPage)
}
func NewUserSubscriptionClient(subscriptionID string) UserSubscriptionClient {
	return original.NewUserSubscriptionClient(subscriptionID)
}
func NewUserSubscriptionClientWithBaseURI(baseURI string, subscriptionID string) UserSubscriptionClient {
	return original.NewUserSubscriptionClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAPITypeValues() []APIType {
	return original.PossibleAPITypeValues()
}
func PossibleAccessIDNameValues() []AccessIDName {
	return original.PossibleAccessIDNameValues()
}
func PossibleAccessTypeValues() []AccessType {
	return original.PossibleAccessTypeValues()
}
func PossibleAlwaysLogValues() []AlwaysLog {
	return original.PossibleAlwaysLogValues()
}
func PossibleApimIdentityTypeValues() []ApimIdentityType {
	return original.PossibleApimIdentityTypeValues()
}
func PossibleAppTypeValues() []AppType {
	return original.PossibleAppTypeValues()
}
func PossibleAsyncOperationStatusValues() []AsyncOperationStatus {
	return original.PossibleAsyncOperationStatusValues()
}
func PossibleAuthorizationMethodValues() []AuthorizationMethod {
	return original.PossibleAuthorizationMethodValues()
}
func PossibleBackendProtocolValues() []BackendProtocol {
	return original.PossibleBackendProtocolValues()
}
func PossibleBearerTokenSendingMethodValues() []BearerTokenSendingMethod {
	return original.PossibleBearerTokenSendingMethodValues()
}
func PossibleBearerTokenSendingMethodsValues() []BearerTokenSendingMethods {
	return original.PossibleBearerTokenSendingMethodsValues()
}
func PossibleCertificateSourceValues() []CertificateSource {
	return original.PossibleCertificateSourceValues()
}
func PossibleCertificateStatusValues() []CertificateStatus {
	return original.PossibleCertificateStatusValues()
}
func PossibleClientAuthenticationMethodValues() []ClientAuthenticationMethod {
	return original.PossibleClientAuthenticationMethodValues()
}
func PossibleConfirmationValues() []Confirmation {
	return original.PossibleConfirmationValues()
}
func PossibleConnectionStatusValues() []ConnectionStatus {
	return original.PossibleConnectionStatusValues()
}
func PossibleConnectivityCheckProtocolValues() []ConnectivityCheckProtocol {
	return original.PossibleConnectivityCheckProtocolValues()
}
func PossibleConnectivityStatusTypeValues() []ConnectivityStatusType {
	return original.PossibleConnectivityStatusTypeValues()
}
func PossibleContentFormatValues() []ContentFormat {
	return original.PossibleContentFormatValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDataMaskingModeValues() []DataMaskingMode {
	return original.PossibleDataMaskingModeValues()
}
func PossibleExportFormatValues() []ExportFormat {
	return original.PossibleExportFormatValues()
}
func PossibleExportResultFormatValues() []ExportResultFormat {
	return original.PossibleExportResultFormatValues()
}
func PossibleGrantTypeValues() []GrantType {
	return original.PossibleGrantTypeValues()
}
func PossibleGroupTypeValues() []GroupType {
	return original.PossibleGroupTypeValues()
}
func PossibleHTTPCorrelationProtocolValues() []HTTPCorrelationProtocol {
	return original.PossibleHTTPCorrelationProtocolValues()
}
func PossibleHostnameTypeValues() []HostnameType {
	return original.PossibleHostnameTypeValues()
}
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return original.PossibleIdentityProviderTypeValues()
}
func PossibleIssueTypeValues() []IssueType {
	return original.PossibleIssueTypeValues()
}
func PossibleKeyTypeValues() []KeyType {
	return original.PossibleKeyTypeValues()
}
func PossibleLoggerTypeValues() []LoggerType {
	return original.PossibleLoggerTypeValues()
}
func PossibleMethodValues() []Method {
	return original.PossibleMethodValues()
}
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return original.PossibleNameAvailabilityReasonValues()
}
func PossibleNotificationNameValues() []NotificationName {
	return original.PossibleNotificationNameValues()
}
func PossibleOperationNameFormatValues() []OperationNameFormat {
	return original.PossibleOperationNameFormatValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossiblePlatformVersionValues() []PlatformVersion {
	return original.PossiblePlatformVersionValues()
}
func PossiblePolicyContentFormatValues() []PolicyContentFormat {
	return original.PossiblePolicyContentFormatValues()
}
func PossiblePolicyExportFormatValues() []PolicyExportFormat {
	return original.PossiblePolicyExportFormatValues()
}
func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return original.PossiblePolicyScopeContractValues()
}
func PossiblePortalRevisionStatusValues() []PortalRevisionStatus {
	return original.PossiblePortalRevisionStatusValues()
}
func PossiblePreferredIPVersionValues() []PreferredIPVersion {
	return original.PossiblePreferredIPVersionValues()
}
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return original.PossiblePrivateEndpointConnectionProvisioningStateValues()
}
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return original.PossiblePrivateEndpointServiceConnectionStatusValues()
}
func PossibleProductStateValues() []ProductState {
	return original.PossibleProductStateValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return original.PossibleResourceSkuCapacityScaleTypeValues()
}
func PossibleSamplingTypeValues() []SamplingType {
	return original.PossibleSamplingTypeValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSkuCapacityScaleTypeValues() []SkuCapacityScaleType {
	return original.PossibleSkuCapacityScaleTypeValues()
}
func PossibleSkuRestrictionsReasonCodeValues() []SkuRestrictionsReasonCode {
	return original.PossibleSkuRestrictionsReasonCodeValues()
}
func PossibleSkuRestrictionsTypeValues() []SkuRestrictionsType {
	return original.PossibleSkuRestrictionsTypeValues()
}
func PossibleSkuTypeValues() []SkuType {
	return original.PossibleSkuTypeValues()
}
func PossibleSoapAPITypeValues() []SoapAPIType {
	return original.PossibleSoapAPITypeValues()
}
func PossibleStateValues() []State {
	return original.PossibleStateValues()
}
func PossibleStoreNameValues() []StoreName {
	return original.PossibleStoreNameValues()
}
func PossibleSubscriptionStateValues() []SubscriptionState {
	return original.PossibleSubscriptionStateValues()
}
func PossibleTemplateNameValues() []TemplateName {
	return original.PossibleTemplateNameValues()
}
func PossibleUserStateValues() []UserState {
	return original.PossibleUserStateValues()
}
func PossibleVerbosityValues() []Verbosity {
	return original.PossibleVerbosityValues()
}
func PossibleVersioningScheme1Values() []VersioningScheme1 {
	return original.PossibleVersioningScheme1Values()
}
func PossibleVersioningSchemeValues() []VersioningScheme {
	return original.PossibleVersioningSchemeValues()
}
func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return original.PossibleVirtualNetworkTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
