package apimdeployment

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// APIManagementServicesClient is the use these REST APIs to manage Azure API
// Management deployment.
type APIManagementServicesClient struct {
	ManagementClient
}

// NewAPIManagementServicesClient creates an instance of the
// APIManagementServicesClient client.
func NewAPIManagementServicesClient(subscriptionID string) APIManagementServicesClient {
	return NewAPIManagementServicesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAPIManagementServicesClientWithBaseURI creates an instance of the
// APIManagementServicesClient client.
func NewAPIManagementServicesClientWithBaseURI(baseURI string, subscriptionID string) APIManagementServicesClient {
	return APIManagementServicesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Backup creates a backup of the API Management service to the given Azure
// Storage Account. This is long running operation and could take several
// minutes to complete. This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used to
// cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// ApiManagementServices_Backup operation.
func (client APIManagementServicesClient) Backup(resourceGroupName string, serviceName string, parameters APIManagementServiceBackupRestoreParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.StorageAccount", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.AccessKey", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.ContainerName", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.BackupName", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "Backup")
	}

	req, err := client.BackupPreparer(resourceGroupName, serviceName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Backup", nil, "Failure preparing request")
	}

	resp, err := client.BackupSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Backup", resp, "Failure sending request")
	}

	result, err = client.BackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Backup", resp, "Failure responding to request")
	}

	return
}

// BackupPreparer prepares the Backup request.
func (client APIManagementServicesClient) BackupPreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceBackupRestoreParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backup", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// BackupSender sends the Backup request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) BackupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// BackupResponder handles the response to the Backup request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) BackupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CheckNameAvailability checks availability and correctness of a name for an
// API Management service.
//
// parameters is parameters supplied to the CheckNameAvailability operation.
func (client APIManagementServicesClient) CheckNameAvailability(parameters APIManagementServiceCheckNameAvailabilityParameters) (result APIManagementServiceNameAvailabilityResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "CheckNameAvailability")
	}

	req, err := client.CheckNameAvailabilityPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "CheckNameAvailability", nil, "Failure preparing request")
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "CheckNameAvailability", resp, "Failure sending request")
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "CheckNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client APIManagementServicesClient) CheckNameAvailabilityPreparer(parameters APIManagementServiceCheckNameAvailabilityParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.ApiManagement/checkNameAvailability", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) CheckNameAvailabilityResponder(resp *http.Response) (result APIManagementServiceNameAvailabilityResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates or updates an API Management service. This is long
// running operation and could take several minutes to complete.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// CreateOrUpdate API Management service operation.
func (client APIManagementServicesClient) CreateOrUpdate(resourceGroupName string, serviceName string, parameters APIManagementServiceResource) (result APIManagementServiceResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Location", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "CreateOrUpdate")
	}

	req, err := client.CreateOrUpdatePreparer(resourceGroupName, serviceName, parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "CreateOrUpdate", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "CreateOrUpdate", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client APIManagementServicesClient) CreateOrUpdatePreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) CreateOrUpdateResponder(resp *http.Response) (result APIManagementServiceResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an existing API Management service.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service.
func (client APIManagementServicesClient) Delete(resourceGroupName string, serviceName string) (result ErrorResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "Delete")
	}

	req, err := client.DeletePreparer(resourceGroupName, serviceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Delete", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Delete", resp, "Failure sending request")
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client APIManagementServicesClient) DeletePreparer(resourceGroupName string, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) DeleteResponder(resp *http.Response) (result ErrorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets an API Management service resource description.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service.
func (client APIManagementServicesClient) Get(resourceGroupName string, serviceName string) (result SetObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, serviceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client APIManagementServicesClient) GetPreparer(resourceGroupName string, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) GetResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSsoToken gets the Single-Sign-On token for the API Management Service
// which is valid for 5 Minutes.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service.
func (client APIManagementServicesClient) GetSsoToken(resourceGroupName string, serviceName string) (result APIManagementServiceGetSsoTokenResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "GetSsoToken")
	}

	req, err := client.GetSsoTokenPreparer(resourceGroupName, serviceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "GetSsoToken", nil, "Failure preparing request")
	}

	resp, err := client.GetSsoTokenSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "GetSsoToken", resp, "Failure sending request")
	}

	result, err = client.GetSsoTokenResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "GetSsoToken", resp, "Failure responding to request")
	}

	return
}

// GetSsoTokenPreparer prepares the GetSsoToken request.
func (client APIManagementServicesClient) GetSsoTokenPreparer(resourceGroupName string, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/getssotoken", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSsoTokenSender sends the GetSsoToken request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) GetSsoTokenSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSsoTokenResponder handles the response to the GetSsoToken request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) GetSsoTokenResponder(resp *http.Response) (result APIManagementServiceGetSsoTokenResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all API Management services within an Azure subscription.
func (client APIManagementServicesClient) List() (result APIManagementServiceListResult, err error) {
	req, err := client.ListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "List", nil, "Failure preparing request")
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "List", resp, "Failure sending request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client APIManagementServicesClient) ListPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.ApiManagement/service/", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) ListResponder(resp *http.Response) (result APIManagementServiceListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client APIManagementServicesClient) ListNextResults(lastResults APIManagementServiceListResult) (result APIManagementServiceListResult, err error) {
	req, err := lastResults.APIManagementServiceListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// ListByResourceGroup list all API Management services within a resource
// group.
//
// resourceGroupName is the name of the resource group.
func (client APIManagementServicesClient) ListByResourceGroup(resourceGroupName string) (result APIManagementServiceListResult, err error) {
	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ListByResourceGroup", nil, "Failure preparing request")
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ListByResourceGroup", resp, "Failure sending request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client APIManagementServicesClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) ListByResourceGroupResponder(resp *http.Response) (result APIManagementServiceListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client APIManagementServicesClient) ListByResourceGroupNextResults(lastResults APIManagementServiceListResult) (result APIManagementServiceListResult, err error) {
	req, err := lastResults.APIManagementServiceListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ManageDeployments manages deployments of an API Management service. This
// operation can be used to do the following: Change SKU, Change SKU Units,
// Change Service Tier (Developer/Standard/Premium) and Manage VPN
// Configuration. This is a long running operation and can take several minutes
// to complete. This method may poll for completion. Polling can be canceled by
// passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// ManageDeployments operation.
func (client APIManagementServicesClient) ManageDeployments(resourceGroupName string, serviceName string, parameters APIManagementServiceManageDeploymentsParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Location", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "ManageDeployments")
	}

	req, err := client.ManageDeploymentsPreparer(resourceGroupName, serviceName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ManageDeployments", nil, "Failure preparing request")
	}

	resp, err := client.ManageDeploymentsSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ManageDeployments", resp, "Failure sending request")
	}

	result, err = client.ManageDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "ManageDeployments", resp, "Failure responding to request")
	}

	return
}

// ManageDeploymentsPreparer prepares the ManageDeployments request.
func (client APIManagementServicesClient) ManageDeploymentsPreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceManageDeploymentsParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/managedeployments", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ManageDeploymentsSender sends the ManageDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) ManageDeploymentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ManageDeploymentsResponder handles the response to the ManageDeployments request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) ManageDeploymentsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Restore restores a backup of an API Management service created using the
// ApiManagementServices_Backup operation on the current service. This is a
// long running operation and could take several minutes to complete. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// Restore API Management service from backup operation.
func (client APIManagementServicesClient) Restore(resourceGroupName string, serviceName string, parameters APIManagementServiceBackupRestoreParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.StorageAccount", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.AccessKey", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.ContainerName", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.BackupName", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "Restore")
	}

	req, err := client.RestorePreparer(resourceGroupName, serviceName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Restore", nil, "Failure preparing request")
	}

	resp, err := client.RestoreSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Restore", resp, "Failure sending request")
	}

	result, err = client.RestoreResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Restore", resp, "Failure responding to request")
	}

	return
}

// RestorePreparer prepares the Restore request.
func (client APIManagementServicesClient) RestorePreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceBackupRestoreParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/restore", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RestoreSender sends the Restore request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) RestoreSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RestoreResponder handles the response to the Restore request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) RestoreResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update updates an existing API Management service. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// CreateOrUpdate API Management service operation.
func (client APIManagementServicesClient) Update(resourceGroupName string, serviceName string, parameters APIManagementServiceBaseParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "Update")
	}

	req, err := client.UpdatePreparer(resourceGroupName, serviceName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Update", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Update", resp, "Failure sending request")
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client APIManagementServicesClient) UpdatePreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceBaseParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateHostname creates, updates, or deletes the custom hostnames for an API
// Management service. The custom hostname can be applied to the Proxy and
// Portal endpoint. This is a long running operation and could take several
// minutes to complete. This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used to
// cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// UpdateHostname operation.
func (client APIManagementServicesClient) UpdateHostname(resourceGroupName string, serviceName string, parameters APIManagementServiceUpdateHostnameParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "UpdateHostname")
	}

	req, err := client.UpdateHostnamePreparer(resourceGroupName, serviceName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "UpdateHostname", nil, "Failure preparing request")
	}

	resp, err := client.UpdateHostnameSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "UpdateHostname", resp, "Failure sending request")
	}

	result, err = client.UpdateHostnameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "UpdateHostname", resp, "Failure responding to request")
	}

	return
}

// UpdateHostnamePreparer prepares the UpdateHostname request.
func (client APIManagementServicesClient) UpdateHostnamePreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceUpdateHostnameParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/updatehostname", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// UpdateHostnameSender sends the UpdateHostname request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) UpdateHostnameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// UpdateHostnameResponder handles the response to the UpdateHostname request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) UpdateHostnameResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UploadCertificate upload Custom Domain SSL certificate for an API Management
// service.
//
// resourceGroupName is the name of the resource group. serviceName is the name
// of the API Management service. parameters is parameters supplied to the
// Upload SSL certificate for an API Management service operation.
func (client APIManagementServicesClient) UploadCertificate(resourceGroupName string, serviceName string, parameters APIManagementServiceUploadCertificateParameters) (result CertificateInformation, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: serviceName,
			Constraints: []validation.Constraint{{Target: "serviceName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "serviceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "serviceName", Name: validation.Pattern, Rule: `^[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Certificate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.CertificatePassword", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "apimdeployment.APIManagementServicesClient", "UploadCertificate")
	}

	req, err := client.UploadCertificatePreparer(resourceGroupName, serviceName, parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "UploadCertificate", nil, "Failure preparing request")
	}

	resp, err := client.UploadCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "UploadCertificate", resp, "Failure sending request")
	}

	result, err = client.UploadCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimdeployment.APIManagementServicesClient", "UploadCertificate", resp, "Failure responding to request")
	}

	return
}

// UploadCertificatePreparer prepares the UploadCertificate request.
func (client APIManagementServicesClient) UploadCertificatePreparer(resourceGroupName string, serviceName string, parameters APIManagementServiceUploadCertificateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/updatecertificate", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UploadCertificateSender sends the UploadCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client APIManagementServicesClient) UploadCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UploadCertificateResponder handles the response to the UploadCertificate request. The method always
// closes the http.Response Body.
func (client APIManagementServicesClient) UploadCertificateResponder(resp *http.Response) (result CertificateInformation, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
