#include <stdio.h>
#include <netinet/in.h>
#include <string.h>

#include "packets.h"
#include "network.h"

static int
packet_string_copy(char *dst,char *src) {
  char *p = src,*q = dst;
  while (*p != '\0' && q < (dst+MAXSTRINGSIZE)) {
    *q++ = *p++;
  }
  *q = '\0';
  return q - dst;
}

static Network_packet * 
new_packet(size_t size,uint32_t type) {
  Network_packet *result = new_network_packet(size);
  ((Packet_base *)result->data)->type = htonl(type);

  return result;
}

int packet_get_type(Network_packet *packet) {
  return ntohl(((Packet_base *)packet->data)->type);
}

Network_packet *
new_packet_client_info(char *version) {
  Network_packet *result = 
     new_packet(sizeof(Packet_client_info),PACKET_CLIENT_INFO);

  packet_string_copy(((Packet_client_info *)result->data)->version,version);
  return result;
}


char *packet_client_info_get_version(Network_packet *p) {
  return ((Packet_client_info *)p->data)->version;
}

/* reply packets */
Network_packet *
new_packet_reply(int32_t reply) {
  Network_packet *result = new_packet(sizeof(Packet_reply),PACKET_REPLY);
  ((Packet_reply *) result->data)->reply = htonl(reply);
  return result;
}

int32_t packet_reply_get_reply(Network_packet *packet) {
  return ntohl(((Packet_reply *)packet->data)->reply);
}

/* sync packet */
Network_packet *
new_packet_sync(void) {
  Network_packet *result = new_packet(sizeof(Packet_reply),PACKET_SYNC);
  return result;
}

/* action packets */
Network_packet *new_packet_action(uint32_t player, uint32_t event) {
  Network_packet *result = new_packet(sizeof(Packet_action),PACKET_ACTION);
  ((Packet_action *) result->data)->player = htonl(player);
  ((Packet_action *) result->data)->action = htonl(event);
  return result;
}

uint32_t packet_action_get_player(Network_packet *packet) {
  return ntohl(((Packet_action *)packet->data)->player);
}

uint32_t packet_action_get_event(Network_packet *packet) {
  return ntohl(((Packet_action *)packet->data)->action);
}

/* player request */
Network_packet *new_packet_player_req(char *name) {
  Network_packet *result = new_packet(sizeof(Packet_player_req),
                                      PACKET_PLAYER_REQ);

  packet_string_copy(((Packet_player_req *)result->data)->name,name);
  return result;
}

char *packet_player_req_get_name(Network_packet *packet) {
  return ((Packet_player_req *) packet->data)->name;
}

/* player info */
Network_packet *new_packet_player_info(uint32_t player, char *name) {
  Network_packet *result = 
     new_packet(sizeof(Packet_player_info),PACKET_PLAYER_INFO);

  packet_string_copy(((Packet_player_info *) result->data)->name,name);
  ((Packet_player_info *) result->data)->player = htonl(player);
  return result;
}
char *packet_player_info_get_name(Network_packet *packet) {
  return ((Packet_player_info *) packet->data)->name;
}

uint32_t packet_player_info_get_number(Network_packet *packet) {
  return ntohl(((Packet_player_info *)packet->data)->player);
}

Network_packet *
new_packet_conn_req(char *host,uint32_t port) {
  Network_packet *result = 
     new_packet(sizeof(Packet_conn_req),PACKET_CONN_REQ);

  packet_string_copy(((Packet_conn_req *)result->data)->host,host);
  ((Packet_conn_req *) result->data)->port = htonl(port);
  return result;
}

char *packet_conn_req_gethost(Network_packet *p) {
  return ((Packet_conn_req *) p->data)->host;
}

uint32_t packet_conn_req_getport(Network_packet *p) {
  return ntohl(((Packet_conn_req *)p->data)->port);
}

Network_packet *new_packet_level_info(char *data,int *len) {
  Network_packet *result = 
     new_packet(sizeof(Packet_level_info),PACKET_LEVEL_INFO);

  *len = packet_string_copy(((Packet_level_info *)result->data)->data,data);
  return result;
}

char *
packet_level_info_get_data(Network_packet *p) {
  return ((Packet_level_info *) p->data)->data;
}
