dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2009 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ(2.13)

AC_DEFUN([IREG_DOC],[whether floats are returned in integer registers])
AC_DEFUN([FFCALL_IREG_FLOAT_RETURN],[dnl
AC_CACHE_CHECK(IREG_DOC, ffcall_cv_c_float_return_ireg, [AC_TRY_RUN(GL_NOCRASH[
float x = (float)1.2;
float y = (float)1.3;
float fun () { return x*y; }
int main()
{ nocrash_init();
 {int val = (* (int (*) ()) fun) ();
  return !(val == 0x3FC7AE15 || val == 0x15AEC73F);
}}], ffcall_cv_c_float_return_ireg=yes, ffcall_cv_c_float_return_ireg=no,
dnl When cross-compiling, assume no, because that's how it comes out on
dnl most platforms with floating-point unit, including m68k-linux.
ffcall_cv_c_float_return_ireg="guessing no")
])
case "$ffcall_cv_c_float_return_ireg" in
  *yes) AC_DEFINE([__IREG_FLOAT_RETURN__], [], IREG_DOC) ;;
  *no) ;;
esac
])
