/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.ColorSpec;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class ColorTable {
    public int ctSeed = 0;
    public int ctFlags = 0;
    public int ctSize = -1;
    public List<ColorSpec> ctTable = new Vector<ColorSpec>();

    public static ColorTable read(DataInputStream in) throws IOException {
        ColorTable t = new ColorTable();
        t.ctSeed = in.readInt();
        t.ctFlags = in.readUnsignedShort();
        t.ctSize = in.readShort();
        t.ctTable = new Vector<ColorSpec>();
        int i = 0;
        while (i <= t.ctSize) {
            t.ctTable.add(ColorSpec.read(in));
            ++i;
        }
        return t;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.ctSeed);
        out.writeShort(this.ctFlags);
        this.ctSize = this.ctTable.size() - 1;
        out.writeShort(this.ctSize);
        for (ColorSpec c : this.ctTable) {
            c.write(out);
        }
    }

    public int[] toIntArray() {
        int[] a = new int[this.ctTable.size()];
        int i = 0;
        for (ColorSpec c : this.ctTable) {
            a[i++] = c.toRGB();
        }
        return a;
    }

    public Color[] toColorArray() {
        Color[] a = new Color[this.ctTable.size()];
        int i = 0;
        for (ColorSpec c : this.ctTable) {
            a[i++] = c.toColor();
        }
        return a;
    }

    public int[] toIntArrayByPixelIndex(int size) {
        for (ColorSpec c : this.ctTable) {
            if (c.value + 1 <= size) continue;
            size = c.value + 1;
        }
        int[] a = new int[size];
        for (ColorSpec c : this.ctTable) {
            a[c.value] = c.toRGB();
        }
        return a;
    }

    public Color[] toColorArrayByPixelIndex(int size) {
        for (ColorSpec c : this.ctTable) {
            if (c.value + 1 <= size) continue;
            size = c.value + 1;
        }
        Color[] a = new Color[size];
        for (ColorSpec c : this.ctTable) {
            a[c.value] = c.toColor();
        }
        return a;
    }

    public IndexColorModel toIndexColorModel(int bits) {
        byte[] r = new byte[this.ctTable.size()];
        byte[] g = new byte[this.ctTable.size()];
        byte[] b = new byte[this.ctTable.size()];
        int i = 0;
        for (ColorSpec c : this.ctTable) {
            r[i] = (byte)(c.rgb.red / 257);
            g[i] = (byte)(c.rgb.green / 257);
            b[i] = (byte)(c.rgb.blue / 257);
            ++i;
        }
        return new IndexColorModel(bits, this.ctTable.size(), r, g, b);
    }

    public IndexColorModel toIndexColorModelByPixelIndex(int bits, int size) {
        for (ColorSpec c : this.ctTable) {
            if (c.value + 1 <= size) continue;
            size = c.value + 1;
        }
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        for (ColorSpec c : this.ctTable) {
            r[c.value] = (byte)(c.rgb.red / 257);
            g[c.value] = (byte)(c.rgb.green / 257);
            b[c.value] = (byte)(c.rgb.blue / 257);
        }
        return new IndexColorModel(bits, this.ctTable.size(), r, g, b);
    }

    public String toString() {
        return "ColorTable[" + this.ctSeed + "," + this.ctFlags + "," + this.ctTable.size() + "]";
    }
}

