#define TARGET_ANDROID
#define COMPILER_GCC
#define NO_MAKE_EXE
#define NO_MAKE_EXE_JAVA

#define OUTPUT_EXE     %(NAME)
#define OUTPUT_JAVA   %(NAME).apk
#define OUTPUT_CON     %(NAME)
#define OUTPUT_DLL     lib%(NAME).so
#define OUTPUT_DLL_LIB lib%(NAME).so
#define OUTPUT_LIB     lib%(NAME).a

CONFIG

ANDROID_LIBC_DIR = %(CONFIG_ANDROID_NDK)/build/platforms/android-%(CONFIG_ANDROID_VERSION)/%(ANDROID_ARCH)/usr
ANDROID_GCC_DIR = %(CONFIG_ANDROID_NDK)/build/prebuilt/%(CONFIG_ANDROID_PLATFORM)/%(ANDROID_GCC)/bin

IFNDEF CONFIG_ANDROID_NDK
  ECHO Android NDK path not defined ! (CONFIG_ANDROID_NDK)
ENDIF

IFNDEF CONFIG_ANDROID_VERSION
  ECHO Android target version not defined ! (CONFIG_ANDROID_VERSION)
ENDIF

IFNDEF CONFIG_ANDROID_PLATFORM
  ECHO Android NDK build platform not defined ! (CONFIG_ANDROID_PLATFORM)
ENDIF

FOR EACH WORKSPACE
  FOR EACH USE
    IF %(TYPE)==EXE_JAVA
      IFDEF ANDROID_NDK_PROJ
        FILE %(CONFIG_ANDROID_NDK)/apps/%(:``|BUILDDIR)/Application.mk
        PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
        PRINTNL APP_PROJECT_PATH := $(call my-dir)/%(!OUTPUTPATH)
        PRINTNL APP_OPTIM := %(TARGOPTIM)
        MODULES = 
        // LIBs first
        FOR EACH USE
          IF %(TYPE)==LIB
            ../MODULES += %(NAME)
            FOR EACH SOURCE
              FOR EACH MIME_TYPE
                ../../../MIME_TYPES += %(NAME)
              ENDFOR
            ENDFOR
          ENDIF
          FOR EACH USE
            IF %(TYPE)==LIB
              ../../MODULES += %(NAME)
            ENDIF
          ENDFOR
        ENDFOR
        // DLLs next
        FOR EACH USE
          IF %(TYPE)==DLL
            ../MODULES += %(NAME)
            FOR EACH SOURCE
              FOR EACH MIME_TYPE
                ../../../MIME_TYPES += %(NAME)
              ENDFOR
            ENDFOR
          ENDIF
          FOR EACH USE
            IF %(TYPE)==DLL
              ../../MODULES += %(NAME)
            ENDIF
          ENDFOR
        ENDFOR
        PRINTNL APP_MODULES      := %(MODULES)
        PRINTNL APP_BUILD_SCRIPT := $(call my-dir)/Android.mk
        
        FILE %(CONFIG_ANDROID_NDK)/apps/%(:``|BUILDDIR)/Android.mk
        PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
        PRINTNL LOCAL_PATH := $(call my-dir)
        FOR EACH USE
          // LIBs first
          IF %(TYPE)==LIB
            #include "android_mk.inc"
          ENDIF
          FOR EACH USE
            IF %(TYPE)==LIB
              #include "android_mk.inc"
            ENDIF
          ENDFOR
          // DLLs next
          IF %(TYPE)==DLL
            #include "android_mk.inc"
          ENDIF
          FOR EACH USE
            IF %(TYPE)==DLL
              #include "android_mk.inc"
            ENDIF
          ENDFOR
        ENDFOR
        
        FILEBIN %(BUILDDIR)build_ndk.sh
        SCRIPT
        PRINTNL #!/bin/sh
        PRINTNL 
        PRINTNL # you can use V=1 for more traces and -B to force a rebuild
        PRINTNL 
        PRINTNL (cd %(CONFIG_ANDROID_NDK); make APP=%(:``|BUILDDIR) $1 $2 $3 $4 $5 $6)
      ENDIF

      IF %(PROJECT_VENDOR)==""
        PROJECT_VENDOR = CoreCodec
      ENDIF
      IF %(PROJECT_NAME)==""
        PROJECT_NAME = %(NAME)
      ENDIF
      
      MKDIR %(BUILDDIR)gen/

      MKDIR %(BUILDDIR)res/
      MKDIR %(BUILDDIR)res/raw/
      FOR EACH INSTALL
        COPY %(!NAME) %(BUILDDIR)res/raw/%(<NAME).%(>NAME)
      ENDFOR
      FOR EACH USE
        FOR EACH INSTALL
          COPY %(!NAME) %(BUILDDIR)res/raw/%(<NAME).%(>NAME)
        ENDFOR
      ENDFOR
      IF %(ANDROID_VALUE)!=""
        MKDIR %(BUILDDIR)res/values/
        FOR EACH ANDROID_VALUE
          COPY %(!NAME) %(BUILDDIR)res/values/%(<NAME).%(>NAME)
        ENDFOR
      ENDIF
      IF %(ICON)!=""
        MKDIR %(BUILDDIR)res/drawable/
        COPY %(!ICON)_64x64.png %(BUILDDIR)res/drawable/%(<ICON)_64x64.png
      ENDIF
      
      FILE %(BUILDDIR)%(PATH)com/%(PROJECT_VENDOR)/%(`PROJECT_NAME)/App.java
      PRINTNL /* DO NOT EDIT, FILE GENERATED BY COREMAKE */
      PRINTNL 
      PRINTNL package com.%(PROJECT_VENDOR).%(`PROJECT_NAME);
      PRINTNL 
      FOR EACH SOURCE
        IF %(MAIN)!=""
          DIRPUSH %(!PATH)
          PRINTNL import %(```/NAME).%(<NAME);
          DIRPOP
          PRINTNL 
          PRINTNL public class App extends %(<NAME) {
          PRINTNL }
        ENDIF
      ENDFOR

      FILE %(BUILDDIR).classpath
      PRINTNL <?xml version="1.0" encoding="UTF-8"?>
      PRINTNL <classpath>
      PRINTNL 	<classpathentry kind="src" path="src"/>
      PRINTNL 	<classpathentry kind="src" path="srcgen">
      PRINTNL 		<attributes>
      PRINTNL 			<attribute name="org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY" value="%(NAME)/libs/%(ANDROID_ABI)"/>
      PRINTNL 		</attributes>
      PRINTNL 	</classpathentry>
      PRINTNL 	<classpathentry kind="src" path="gen"/>
      PRINTNL 	<classpathentry kind="con" path="com.android.ide.eclipse.adt.ANDROID_FRAMEWORK"/>
      PRINTNL 	<classpathentry kind="output" path="%(OUTPUTPATH)"/>
      PRINTNL </classpath>
      MKDIR %(OUTPUTPATH)
      
      FILE %(BUILDDIR).project
      PRINTNL <?xml version="1.0" encoding="UTF-8"?>
      PRINTNL <projectDescription>
      PRINTNL 	<name>%(NAME)</name>
      PRINTNL 	<comment></comment>
      PRINTNL 	<projects>
      PRINTNL 	</projects>
      PRINTNL 	<buildSpec>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.ResourceManagerBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.PreCompilerBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>org.eclipse.jdt.core.javabuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.ApkBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 	</buildSpec>
      PRINTNL 	<natures>
      PRINTNL 		<nature>com.android.ide.eclipse.adt.AndroidNature</nature>
      PRINTNL 		<nature>org.eclipse.jdt.core.javanature</nature>
      PRINTNL 	</natures>
      PRINTNL 	<linkedResources>
      PRINTNL 		<link>
      PRINTNL 			<name>src</name>
      PRINTNL 			<type>2</type>
      PRINTNL 			<location>%(|PATH)</location>
      PRINTNL 		</link>
      PRINTNL 		<link>
      PRINTNL 			<name>srcgen</name>
      PRINTNL 			<type>2</type>
      PRINTNL 			<location>%(|BUILDDIR)%(PATH)</location>
      PRINTNL 		</link>
      PRINTNL 	</linkedResources>
      PRINTNL </projectDescription>
      
      FILE %(BUILDDIR)default.properties
      PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
      PRINTNL 
      PRINTNL # Indicates whether an apk should be generated for each density.
      PRINTNL split.density=false
      PRINTNL # Project target.
      PRINTNL target=android-4
      
      FILE %(BUILDDIR).settings/org.eclipse.jdt.core.prefs
      PRINTNL #Mon Jan 25 12:20:43 CET 2010
      PRINTNL eclipse.preferences.version=1
      PRINTNL org.eclipse.jdt.core.compiler.codegen.targetPlatform=1.5
      PRINTNL org.eclipse.jdt.core.compiler.compliance=1.5
      PRINTNL org.eclipse.jdt.core.compiler.source=1.5

      // TODO: there should be one per EXE
      FILE %(BUILDDIR)AndroidManifest.xml
      PRINTNL <?xml version="1.0" encoding="utf-8"?>
      PRINTNL <manifest xmlns:android="http://schemas.android.com/apk/res/android"
      PRINTNL       package="com.%(PROJECT_VENDOR).%(`PROJECT_NAME)"
      IF %(ANDROID_UID)!=""
        PRINTNL       android:sharedUserId="%(ANDROID_UID)"
        IF %(ANDROID_UID_NAME)!=""
          PRINTNL       android:sharedUserLabel="%(ANDROID_UID_NAME)"
        ENDIF
      ENDIF
      IF %(PROJECT_BUILD)!=""
        PRINTNL       android:versionCode="%(PROJECT_BUILD)"
        IF %(PROJECT_VERSION)!=""
          PRINTNL       android:versionName="%(PROJECT_VERSION).%(PROJECT_BUILD)"
        ENDIF
      ELIF %(PROJECT_VERSION)!=""
        PRINTNL       android:versionName="%(PROJECT_VERSION)"
      ENDIF
      PRINTNL       >
      PRINTNL     <uses-sdk android:minSdkVersion="4"/>
      PRINTNL     <application
      IF %(ICON)!=""
        PRINTNL         android:icon="@drawable/%(<ICON)_64x64"
      ENDIF
      FOR EACH SOURCE
        IF %(MAIN)!=""
          IF %(ANDROID_THEME)!=""
            PRINTNL         android:theme="@style/%(ANDROID_THEME)"
          ENDIF
        ENDIF
      ENDFOR
      PRINTNL         android:label="%(PROJECT_NAME)">
      PRINTNL       <activity android:name=".App"
      PRINTNL             android:configChanges="mcc|mnc|keyboardHidden|orientation|fontScale"
      IF %(ANDROID_SINGLE)!=""
        PRINTNL             android:launchMode="singleTask"
      ENDIF
      PRINTNL             android:windowSoftInputMode="stateHidden"
      IF %(MIME_TYPES)!=""
        PRINTNL             android:exported="true"
      ENDIF
      PRINTNL       >
      PRINTNL         <intent-filter>
      PRINTNL           <action android:name="android.intent.action.MAIN"/>
      PRINTNL           <category android:name="android.intent.category.LAUNCHER"/>
      PRINTNL         </intent-filter>
      IF %(MIME_TYPES)!=""
        FOR EACH MIME_TYPES
          PRINTNL         <intent-filter>
          PRINTNL           <data android:mimeType="%(NAME)"/>
          PRINTNL           <action android:name="android.intent.action.OPENMIME"/>
          PRINTNL         </intent-filter>
        ENDFOR
      ENDIF
      PRINTNL       </activity>
      FOR EACH SOURCE
        IF %(ACTIVITY)!=""
          DIRPUSH %(!PATH)
          PRINTNL       <activity android:name="%(```/NAME).%(<NAME)"
          PRINTNL             android:configChanges="mcc|mnc|keyboardHidden|orientation|fontScale"
          PRINTNL       />
          DIRPOP
        ENDIF
        IF %(SERVICE)!=""
          DIRPUSH %(!PATH)
          PRINTNL       <service android:name="%(```/NAME).%(<NAME)">
          PRINTNL         <intent-filter>
          PRINTNL           <action android:name="%(SERVICE)"/>
          PRINTNL         </intent-filter>
          PRINTNL       </service>
          DIRPOP
        ENDIF
      ENDFOR
      PRINTNL     </application>
      FOR EACH ANDROID_PERMISSION
        PRINTNL     <uses-permission android:name="%(NAME)"/>
      ENDFOR
      PRINTNL </manifest> 
      
    ENDIF
  ENDFOR
ENDFOR

CC = %(ANDROID_GCC_DIR)/%(ANDROID_GCC_PREFIX)gcc
STRIP = %(ANDROID_GCC_DIR)/%(ANDROID_GCC_PREFIX)strip 
STRIPFLAGS = --strip-debug
OS_INCLUDE += %(ANDROID_LIBC_DIR)/include
CCFLAGS += -DANDROID
SHFLAGS += %(ANDROID_LIBC_DIR)/lib/libc.so %(ANDROID_LIBC_DIR)/lib/libstdc++.so %(ANDROID_LIBC_DIR)/lib/libm.so -Wl,--no-undefined  -Wl,-rpath-link=%(ANDROID_LIBC_DIR)/lib -L%(ANDROID_LIBC_DIR)/lib
IF %(ANDROID_GCC_LIB)!=""
  SHFLAGS1 += %(ANDROID_GCC_DIR)/../lib/%(ANDROID_GCC_LIB)
ENDIF

#include "gcc_conf.inc"
