; Java Library
;
; Copyright (C) 2021 Kestrel Institute (http://www.kestrel.edu)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (coglio@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "JAVA")

(include-book "aij-notions")

(include-book "../language/primitive-values")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defxdoc+ atj-java-input-types
  :parents (atj-implementation)
  :short "Java input types generated by ATJ."
  :long
  (xdoc::topstring
   (xdoc::p
    "ATJ generates certain Java types from corresponding ACL2 types;
     these Java types are used for methods' inputs (i.e. parameters).")
   (xdoc::p
    "ATJ also generates Java types for @(tsee mv) values,
     but those are only used for methods' outputs (i.e. results).
     We only consider input types here.")
   (xdoc::p
    "The Java code generated by ATJ also uses Java types
     other than the ones mentioned above,
     but those additional Java types are ``auxiliary'',
     in the sense that they are not the result of translating ACL2 types.
     We do not consider these auxiliary types here."))
  :order-subtopics t
  :default-parent t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define atj-jitypep (x)
  :returns (yes/no booleanp)
  :short "Recognize the Java input types generated by ATJ."
  :long
  (xdoc::topstring
   (xdoc::p
    "This includes the types for
     all the AIJ public class types for ACL2 values
     (integers, rationals, numbers,
     characters, strings, symbols,
     @(tsee cons) pairs, and all values),
     the @('java.lang.String') class type,
     all the Java primitive types,
     and all the Java primitive array types."))
  (and (member-equal x (list *aij-type-int*
                             *aij-type-rational*
                             *aij-type-number*
                             *aij-type-char*
                             *aij-type-string*
                             *aij-type-symbol*
                             *aij-type-cons*
                             *aij-type-value*
                             (jtype-class "String")
                             (jtype-boolean)
                             (jtype-char)
                             (jtype-byte)
                             (jtype-short)
                             (jtype-int)
                             (jtype-long)
                             (jtype-float)
                             (jtype-double)
                             (jtype-array (jtype-boolean))
                             (jtype-array (jtype-char))
                             (jtype-array (jtype-byte))
                             (jtype-array (jtype-short))
                             (jtype-array (jtype-int))
                             (jtype-array (jtype-long))
                             (jtype-array (jtype-float))
                             (jtype-array (jtype-double))))
       t)
  ///

  (defrule jtypep-when-atj-jitypep
    (implies (atj-jitypep x)
             (jtypep x))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(std::deflist atj-jitype-listp (x)
  :short "Recognize lists of ATJ Java input types."
  (atj-jitypep x)
  :true-listp t
  :elementp-of-nil nil
  ///

  (defrule jtype-listp-when-atj-jitype-listp
    (implies (atj-jitype-listp x)
             (jtype-listp x))))
