; C Library
;
; Copyright (C) 2025 Kestrel Institute (http://www.kestrel.edu)
; Copyright (C) 2025 Kestrel Technology LLC (http://kestreltechnology.com)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (www.alessandrocoglio.info)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "C")

(include-book "std/util/defrule" :dir :system)
(include-book "xdoc/constructors" :dir :system)

(local (xdoc::set-default-parents atc-symbolic-execution-rules))

(local (include-book "kestrel/built-ins/disable" :dir :system))
(local (acl2::disable-most-builtin-logic-defuns))
(local (acl2::disable-builtin-rewrite-rules-for-defaults))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defsection atc-hide-rules
  :short "Rules about @(tsee hide)."
  :long
  (xdoc::topstring
   (xdoc::p
    "In the new modular proofs generated by ATC,
     we use @(tsee hide) to prevent ACL2's rewriter
     from changing certain terms in ways
     that defeat the modular proof strategy.")
   (xdoc::p
    "In at least one case, we have observed that ACL2
     produces terms of the form @('(hide ((lambda (x) x) t))'),
     which should be just @('t'),
     but because of the @(tsee hide),
     the term does not get rewritten to @('t').
     Thus, we add and use a fairly ad hoc rule to resolve the situation.
     A rule that just rewrites the above term to @('t') is insufficient,
     as we found by experimenting in that case where the term arises.
     Instead, the rule below works:
     it has a generic argument to @(tsee hide),
     and a hypothesis that equates it to the pattern we want to resolve."))

  (defruled hide-of-lambda
    (implies (equal term ((lambda (x) x) t))
             (hide term))
    :expand (:free (x) (hide x))))
