#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hive Time
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251018.6

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='hive-time'
GAME_NAME='Hive Time'

ARCHIVE_BASE_1_NAME='hive-time-linux-v1.2.zip'
ARCHIVE_BASE_1_MD5='e6766ce08338257a4207ef0ee306f63b'
ARCHIVE_BASE_1_SIZE='202987'
ARCHIVE_BASE_1_VERSION='1.2-itch'
ARCHIVE_BASE_1_URL='https://cheeseness.itch.io/hive-time'

ARCHIVE_BASE_0_NAME='hive-time-linux-v1.1.zip'
ARCHIVE_BASE_0_MD5='5d63b490982d96620b0bbb7b6522be56'
ARCHIVE_BASE_0_SIZE='180000'
ARCHIVE_BASE_0_VERSION='1.1-itch'

CONTENT_PATH_DEFAULT='hive-time_linux_v1.2'
CONTENT_PATH_DEFAULT_0='.'
CONTENT_FONTS_MAIN_RELATIVE_PATH='fonts/dimbo'
CONTENT_FONTS_MAIN_FILES='
Dimbo Italic.ttf
Dimbo Regular.ttf'
CONTENT_FONTS0_MAIN_RELATIVE_PATH='fonts/noto'
CONTENT_FONTS0_MAIN_FILES='
NotoEmoji-Regular.ttf
NotoSans-Regular.ttf'
CONTENT_FONTS1_MAIN_RELATIVE_PATH='fonts/twemoji'
CONTENT_FONTS1_MAIN_FILES='
Twemoji.ttf'
CONTENT_GAME_MAIN_FILES='
fonts/cantarell/Cantarell-Bold.otf
fonts/cantarell/Cantarell-ExtraBold.otf
fonts/cantarell/Cantarell-Light.otf
fonts/cantarell/Cantarell-Regular.otf
fonts/cantarell/Cantarell-Thin.otf
fonts/noto/NotoSansCJKkr-Regular.otf
hive-time_linux_v*.pck'

APP_MAIN_TYPE='custom'

PKG_MAIN_DEPENDENCIES_COMMANDS='
godot3-runner'
## Easier upgrades from pre-20251018.2 packages
PKG_MAIN_PROVIDES='
hive-time-data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_default

# Work around the game engine reliance on hardcoded fonts paths.

mkdir --parents \
	"$(package_path 'PKG_MAIN')$(path_game_data)/fonts/dimbo" \
	"$(package_path 'PKG_MAIN')$(path_game_data)/fonts/noto" \
	"$(package_path 'PKG_MAIN')$(path_game_data)/fonts/twemoji"
ln --symbolic --target-directory="$(package_path 'PKG_MAIN')$(path_game_data)/fonts/dimbo" \
	"$(path_fonts_ttf)/Dimbo Italic.ttf" \
	"$(path_fonts_ttf)/Dimbo Regular.ttf"
ln --symbolic --target-directory="$(package_path 'PKG_MAIN')$(path_game_data)/fonts/noto" \
	"$(path_fonts_ttf)/NotoEmoji-Regular.ttf" \
	"$(path_fonts_ttf)/NotoSans-Regular.ttf"
ln --symbolic --target-directory="$(package_path 'PKG_MAIN')$(path_game_data)/fonts/twemoji" \
	"$(path_fonts_ttf)/Twemoji.ttf"

# Write launchers.

custom_launcher() {
	launcher_headers
	cat <<- EOF
	GAME_PATH="$(path_game_data)"
	EOF
	cat <<- 'EOF'
	cd "$GAME_PATH"
	godot3-runner --main-pack ./hive-time_linux_v*.pck
	EOF
	launcher_exit
}
launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
