#ifndef INCLUDE_MODULE_MIXER_H
#define INCLUDE_MODULE_MIXER_H
/* ----------------------------------------------------------------------------
 * module_mixer.h
 * general definitions for all mixer modules
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

#define SOUNDSYSTEM_NONE_NAME "none"
#define SOUNDSYSTEM_AUTO_NAME "auto"
#define SOUNDSYSTEM_OSS_NAME  "OSS"
#define SOUNDSYSTEM_ALSA_NAME "ALSA"
enum {SOUNDSYSTEM_NONE, SOUNDSYSTEM_AUTO, SOUNDSYSTEM_OSS, SOUNDSYSTEM_ALSA, SOUNDSYSTEM_LAST=SOUNDSYSTEM_ALSA};

/* public prototypes */
int mixer_init ();
int mixer_open (struct tagitem *taglist);
int mixer_close ();
int mixer_exit ();

/* private prototypes */
void mixer_query (struct tagitem *taglist);
void mixer_configure (struct tagitem *taglist);
void mixer_handle_tags (int cfgure, struct tagitem *taglist);

#endif    /* INCLUDE_MODULE_MIXER_H */

