// RUN: llvm-mc -triple i386-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: blendpd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
blendpd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: blendpd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
blendpd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: blendpd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
blendpd $0, 485498096(%edx), %xmm1

// CHECK: blendpd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
blendpd $0, 485498096, %xmm1

// CHECK: blendpd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x4c,0x02,0x40,0x00]
blendpd $0, 64(%edx,%eax), %xmm1

// CHECK: blendpd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x0a,0x00]
blendpd $0, (%edx), %xmm1

// CHECK: blendpd $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0xc9,0x00]
blendpd $0, %xmm1, %xmm1

// CHECK: blendps $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
blendps $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: blendps $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
blendps $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: blendps $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
blendps $0, 485498096(%edx), %xmm1

// CHECK: blendps $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
blendps $0, 485498096, %xmm1

// CHECK: blendps $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x4c,0x02,0x40,0x00]
blendps $0, 64(%edx,%eax), %xmm1

// CHECK: blendps $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x0a,0x00]
blendps $0, (%edx), %xmm1

// CHECK: blendps $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0xc9,0x00]
blendps $0, %xmm1, %xmm1

// CHECK: blendvpd %xmm0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
blendvpd %xmm0, -485498096(%edx,%eax,4), %xmm1

// CHECK: blendvpd %xmm0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
blendvpd %xmm0, 485498096(%edx,%eax,4), %xmm1

// CHECK: blendvpd %xmm0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x8a,0xf0,0x1c,0xf0,0x1c]
blendvpd %xmm0, 485498096(%edx), %xmm1

// CHECK: blendvpd %xmm0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x0d,0xf0,0x1c,0xf0,0x1c]
blendvpd %xmm0, 485498096, %xmm1

// CHECK: blendvpd %xmm0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x4c,0x02,0x40]
blendvpd %xmm0, 64(%edx,%eax), %xmm1

// CHECK: blendvpd %xmm0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x0a]
blendvpd %xmm0, (%edx), %xmm1

// CHECK: blendvpd %xmm0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0xc9]
blendvpd %xmm0, %xmm1, %xmm1

// CHECK: blendvps %xmm0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
blendvps %xmm0, -485498096(%edx,%eax,4), %xmm1

// CHECK: blendvps %xmm0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
blendvps %xmm0, 485498096(%edx,%eax,4), %xmm1

// CHECK: blendvps %xmm0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x8a,0xf0,0x1c,0xf0,0x1c]
blendvps %xmm0, 485498096(%edx), %xmm1

// CHECK: blendvps %xmm0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x0d,0xf0,0x1c,0xf0,0x1c]
blendvps %xmm0, 485498096, %xmm1

// CHECK: blendvps %xmm0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x4c,0x02,0x40]
blendvps %xmm0, 64(%edx,%eax), %xmm1

// CHECK: blendvps %xmm0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x0a]
blendvps %xmm0, (%edx), %xmm1

// CHECK: blendvps %xmm0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0xc9]
blendvps %xmm0, %xmm1, %xmm1

// CHECK: dppd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
dppd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: dppd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
dppd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: dppd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
dppd $0, 485498096(%edx), %xmm1

// CHECK: dppd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
dppd $0, 485498096, %xmm1

// CHECK: dppd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x4c,0x02,0x40,0x00]
dppd $0, 64(%edx,%eax), %xmm1

// CHECK: dppd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x0a,0x00]
dppd $0, (%edx), %xmm1

// CHECK: dppd $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0xc9,0x00]
dppd $0, %xmm1, %xmm1

// CHECK: dpps $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
dpps $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: dpps $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
dpps $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: dpps $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
dpps $0, 485498096(%edx), %xmm1

// CHECK: dpps $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
dpps $0, 485498096, %xmm1

// CHECK: dpps $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x4c,0x02,0x40,0x00]
dpps $0, 64(%edx,%eax), %xmm1

// CHECK: dpps $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x0a,0x00]
dpps $0, (%edx), %xmm1

// CHECK: dpps $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0xc9,0x00]
dpps $0, %xmm1, %xmm1

// CHECK: extractps $0, %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
extractps $0, %xmm1, -485498096(%edx,%eax,4)

// CHECK: extractps $0, %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
extractps $0, %xmm1, 485498096(%edx,%eax,4)

// CHECK: extractps $0, %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
extractps $0, %xmm1, 485498096(%edx)

// CHECK: extractps $0, %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
extractps $0, %xmm1, 485498096

// CHECK: extractps $0, %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x4c,0x02,0x40,0x00]
extractps $0, %xmm1, 64(%edx,%eax)

// CHECK: extractps $0, %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x0a,0x00]
extractps $0, %xmm1, (%edx)

// CHECK: insertps $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
insertps $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: insertps $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
insertps $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: insertps $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
insertps $0, 485498096(%edx), %xmm1

// CHECK: insertps $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
insertps $0, 485498096, %xmm1

// CHECK: insertps $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x4c,0x02,0x40,0x00]
insertps $0, 64(%edx,%eax), %xmm1

// CHECK: insertps $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x0a,0x00]
insertps $0, (%edx), %xmm1

// CHECK: insertps $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0xc9,0x00]
insertps $0, %xmm1, %xmm1

// CHECK: movntdqa -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movntdqa -485498096(%edx,%eax,4), %xmm1

// CHECK: movntdqa 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movntdqa 485498096(%edx,%eax,4), %xmm1

// CHECK: movntdqa 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x8a,0xf0,0x1c,0xf0,0x1c]
movntdqa 485498096(%edx), %xmm1

// CHECK: movntdqa 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x0d,0xf0,0x1c,0xf0,0x1c]
movntdqa 485498096, %xmm1

// CHECK: movntdqa 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x4c,0x02,0x40]
movntdqa 64(%edx,%eax), %xmm1

// CHECK: movntdqa (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x0a]
movntdqa (%edx), %xmm1

// CHECK: mpsadbw $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
mpsadbw $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: mpsadbw $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
mpsadbw $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: mpsadbw $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
mpsadbw $0, 485498096(%edx), %xmm1

// CHECK: mpsadbw $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
mpsadbw $0, 485498096, %xmm1

// CHECK: mpsadbw $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x4c,0x02,0x40,0x00]
mpsadbw $0, 64(%edx,%eax), %xmm1

// CHECK: mpsadbw $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x0a,0x00]
mpsadbw $0, (%edx), %xmm1

// CHECK: mpsadbw $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0xc9,0x00]
mpsadbw $0, %xmm1, %xmm1

// CHECK: packusdw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
packusdw -485498096(%edx,%eax,4), %xmm1

// CHECK: packusdw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
packusdw 485498096(%edx,%eax,4), %xmm1

// CHECK: packusdw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x8a,0xf0,0x1c,0xf0,0x1c]
packusdw 485498096(%edx), %xmm1

// CHECK: packusdw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x0d,0xf0,0x1c,0xf0,0x1c]
packusdw 485498096, %xmm1

// CHECK: packusdw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x4c,0x02,0x40]
packusdw 64(%edx,%eax), %xmm1

// CHECK: packusdw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x0a]
packusdw (%edx), %xmm1

// CHECK: packusdw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0xc9]
packusdw %xmm1, %xmm1

// CHECK: pblendvb %xmm0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pblendvb %xmm0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pblendvb %xmm0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pblendvb %xmm0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pblendvb %xmm0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x8a,0xf0,0x1c,0xf0,0x1c]
pblendvb %xmm0, 485498096(%edx), %xmm1

// CHECK: pblendvb %xmm0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x0d,0xf0,0x1c,0xf0,0x1c]
pblendvb %xmm0, 485498096, %xmm1

// CHECK: pblendvb %xmm0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x4c,0x02,0x40]
pblendvb %xmm0, 64(%edx,%eax), %xmm1

// CHECK: pblendvb %xmm0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x0a]
pblendvb %xmm0, (%edx), %xmm1

// CHECK: pblendvb %xmm0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0xc9]
pblendvb %xmm0, %xmm1, %xmm1

// CHECK: pblendw $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pblendw $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pblendw $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pblendw $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pblendw $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pblendw $0, 485498096(%edx), %xmm1

// CHECK: pblendw $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pblendw $0, 485498096, %xmm1

// CHECK: pblendw $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x4c,0x02,0x40,0x00]
pblendw $0, 64(%edx,%eax), %xmm1

// CHECK: pblendw $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x0a,0x00]
pblendw $0, (%edx), %xmm1

// CHECK: pblendw $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0xc9,0x00]
pblendw $0, %xmm1, %xmm1

// CHECK: pcmpeqq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpeqq -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpeqq 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpeqq 485498096(%edx), %xmm1

// CHECK: pcmpeqq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpeqq 485498096, %xmm1

// CHECK: pcmpeqq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x4c,0x02,0x40]
pcmpeqq 64(%edx,%eax), %xmm1

// CHECK: pcmpeqq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x0a]
pcmpeqq (%edx), %xmm1

// CHECK: pcmpeqq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0xc9]
pcmpeqq %xmm1, %xmm1

// CHECK: pextrb $0, %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pextrb $0, %xmm1, -485498096(%edx,%eax,4)

// CHECK: pextrb $0, %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pextrb $0, %xmm1, 485498096(%edx,%eax,4)

// CHECK: pextrb $0, %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pextrb $0, %xmm1, 485498096(%edx)

// CHECK: pextrb $0, %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pextrb $0, %xmm1, 485498096

// CHECK: pextrb $0, %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x4c,0x02,0x40,0x00]
pextrb $0, %xmm1, 64(%edx,%eax)

// CHECK: pextrb $0, %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x0a,0x00]
pextrb $0, %xmm1, (%edx)

// CHECK: pextrd $0, %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pextrd $0, %xmm1, -485498096(%edx,%eax,4)

// CHECK: pextrd $0, %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pextrd $0, %xmm1, 485498096(%edx,%eax,4)

// CHECK: pextrd $0, %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pextrd $0, %xmm1, 485498096(%edx)

// CHECK: pextrd $0, %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pextrd $0, %xmm1, 485498096

// CHECK: pextrd $0, %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x4c,0x02,0x40,0x00]
pextrd $0, %xmm1, 64(%edx,%eax)

// CHECK: pextrd $0, %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x0a,0x00]
pextrd $0, %xmm1, (%edx)

// CHECK: pextrw $0, %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pextrw $0, %xmm1, -485498096(%edx,%eax,4)

// CHECK: pextrw $0, %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pextrw $0, %xmm1, 485498096(%edx,%eax,4)

// CHECK: pextrw $0, %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pextrw $0, %xmm1, 485498096(%edx)

// CHECK: pextrw $0, %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pextrw $0, %xmm1, 485498096

// CHECK: pextrw $0, %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x4c,0x02,0x40,0x00]
pextrw $0, %xmm1, 64(%edx,%eax)

// CHECK: pextrw $0, %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x0a,0x00]
pextrw $0, %xmm1, (%edx)

// CHECK: phminposuw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
phminposuw -485498096(%edx,%eax,4), %xmm1

// CHECK: phminposuw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
phminposuw 485498096(%edx,%eax,4), %xmm1

// CHECK: phminposuw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x8a,0xf0,0x1c,0xf0,0x1c]
phminposuw 485498096(%edx), %xmm1

// CHECK: phminposuw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x0d,0xf0,0x1c,0xf0,0x1c]
phminposuw 485498096, %xmm1

// CHECK: phminposuw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x4c,0x02,0x40]
phminposuw 64(%edx,%eax), %xmm1

// CHECK: phminposuw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x0a]
phminposuw (%edx), %xmm1

// CHECK: phminposuw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0xc9]
phminposuw %xmm1, %xmm1

// CHECK: pinsrb $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pinsrb $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pinsrb $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrb $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pinsrb $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrb $0, 485498096(%edx), %xmm1

// CHECK: pinsrb $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrb $0, 485498096, %xmm1

// CHECK: pinsrb $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x4c,0x02,0x40,0x00]
pinsrb $0, 64(%edx,%eax), %xmm1

// CHECK: pinsrb $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x0a,0x00]
pinsrb $0, (%edx), %xmm1

// CHECK: pinsrd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pinsrd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pinsrd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pinsrd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrd $0, 485498096(%edx), %xmm1

// CHECK: pinsrd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrd $0, 485498096, %xmm1

// CHECK: pinsrd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x4c,0x02,0x40,0x00]
pinsrd $0, 64(%edx,%eax), %xmm1

// CHECK: pinsrd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x0a,0x00]
pinsrd $0, (%edx), %xmm1

// CHECK: pmaxsb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaxsb -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxsb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaxsb 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxsb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaxsb 485498096(%edx), %xmm1

// CHECK: pmaxsb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaxsb 485498096, %xmm1

// CHECK: pmaxsb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x4c,0x02,0x40]
pmaxsb 64(%edx,%eax), %xmm1

// CHECK: pmaxsb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x0a]
pmaxsb (%edx), %xmm1

// CHECK: pmaxsb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0xc9]
pmaxsb %xmm1, %xmm1

// CHECK: pmaxsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaxsd -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaxsd 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxsd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaxsd 485498096(%edx), %xmm1

// CHECK: pmaxsd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaxsd 485498096, %xmm1

// CHECK: pmaxsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x4c,0x02,0x40]
pmaxsd 64(%edx,%eax), %xmm1

// CHECK: pmaxsd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x0a]
pmaxsd (%edx), %xmm1

// CHECK: pmaxsd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0xc9]
pmaxsd %xmm1, %xmm1

// CHECK: pmaxud -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaxud -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxud 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaxud 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxud 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaxud 485498096(%edx), %xmm1

// CHECK: pmaxud 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaxud 485498096, %xmm1

// CHECK: pmaxud 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x4c,0x02,0x40]
pmaxud 64(%edx,%eax), %xmm1

// CHECK: pmaxud (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x0a]
pmaxud (%edx), %xmm1

// CHECK: pmaxud %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0xc9]
pmaxud %xmm1, %xmm1

// CHECK: pmaxuw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaxuw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxuw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaxuw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxuw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaxuw 485498096(%edx), %xmm1

// CHECK: pmaxuw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaxuw 485498096, %xmm1

// CHECK: pmaxuw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x4c,0x02,0x40]
pmaxuw 64(%edx,%eax), %xmm1

// CHECK: pmaxuw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x0a]
pmaxuw (%edx), %xmm1

// CHECK: pmaxuw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0xc9]
pmaxuw %xmm1, %xmm1

// CHECK: pminsb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pminsb -485498096(%edx,%eax,4), %xmm1

// CHECK: pminsb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pminsb 485498096(%edx,%eax,4), %xmm1

// CHECK: pminsb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x8a,0xf0,0x1c,0xf0,0x1c]
pminsb 485498096(%edx), %xmm1

// CHECK: pminsb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x0d,0xf0,0x1c,0xf0,0x1c]
pminsb 485498096, %xmm1

// CHECK: pminsb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x4c,0x02,0x40]
pminsb 64(%edx,%eax), %xmm1

// CHECK: pminsb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x0a]
pminsb (%edx), %xmm1

// CHECK: pminsb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0xc9]
pminsb %xmm1, %xmm1

// CHECK: pminsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pminsd -485498096(%edx,%eax,4), %xmm1

// CHECK: pminsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pminsd 485498096(%edx,%eax,4), %xmm1

// CHECK: pminsd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x8a,0xf0,0x1c,0xf0,0x1c]
pminsd 485498096(%edx), %xmm1

// CHECK: pminsd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x0d,0xf0,0x1c,0xf0,0x1c]
pminsd 485498096, %xmm1

// CHECK: pminsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x4c,0x02,0x40]
pminsd 64(%edx,%eax), %xmm1

// CHECK: pminsd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x0a]
pminsd (%edx), %xmm1

// CHECK: pminsd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0xc9]
pminsd %xmm1, %xmm1

// CHECK: pminud -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pminud -485498096(%edx,%eax,4), %xmm1

// CHECK: pminud 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pminud 485498096(%edx,%eax,4), %xmm1

// CHECK: pminud 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x8a,0xf0,0x1c,0xf0,0x1c]
pminud 485498096(%edx), %xmm1

// CHECK: pminud 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x0d,0xf0,0x1c,0xf0,0x1c]
pminud 485498096, %xmm1

// CHECK: pminud 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x4c,0x02,0x40]
pminud 64(%edx,%eax), %xmm1

// CHECK: pminud (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x0a]
pminud (%edx), %xmm1

// CHECK: pminud %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0xc9]
pminud %xmm1, %xmm1

// CHECK: pminuw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pminuw -485498096(%edx,%eax,4), %xmm1

// CHECK: pminuw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pminuw 485498096(%edx,%eax,4), %xmm1

// CHECK: pminuw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x8a,0xf0,0x1c,0xf0,0x1c]
pminuw 485498096(%edx), %xmm1

// CHECK: pminuw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x0d,0xf0,0x1c,0xf0,0x1c]
pminuw 485498096, %xmm1

// CHECK: pminuw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x4c,0x02,0x40]
pminuw 64(%edx,%eax), %xmm1

// CHECK: pminuw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x0a]
pminuw (%edx), %xmm1

// CHECK: pminuw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0xc9]
pminuw %xmm1, %xmm1

// CHECK: pmovsxbd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovsxbd -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxbd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovsxbd 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxbd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovsxbd 485498096(%edx), %xmm1

// CHECK: pmovsxbd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovsxbd 485498096, %xmm1

// CHECK: pmovsxbd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x4c,0x02,0x40]
pmovsxbd 64(%edx,%eax), %xmm1

// CHECK: pmovsxbd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x0a]
pmovsxbd (%edx), %xmm1

// CHECK: pmovsxbd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0xc9]
pmovsxbd %xmm1, %xmm1

// CHECK: pmovsxbq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovsxbq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxbq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovsxbq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxbq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovsxbq 485498096(%edx), %xmm1

// CHECK: pmovsxbq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovsxbq 485498096, %xmm1

// CHECK: pmovsxbq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x4c,0x02,0x40]
pmovsxbq 64(%edx,%eax), %xmm1

// CHECK: pmovsxbq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x0a]
pmovsxbq (%edx), %xmm1

// CHECK: pmovsxbq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0xc9]
pmovsxbq %xmm1, %xmm1

// CHECK: pmovsxbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovsxbw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovsxbw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovsxbw 485498096(%edx), %xmm1

// CHECK: pmovsxbw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovsxbw 485498096, %xmm1

// CHECK: pmovsxbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x4c,0x02,0x40]
pmovsxbw 64(%edx,%eax), %xmm1

// CHECK: pmovsxbw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x0a]
pmovsxbw (%edx), %xmm1

// CHECK: pmovsxbw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0xc9]
pmovsxbw %xmm1, %xmm1

// CHECK: pmovsxdq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovsxdq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxdq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovsxdq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxdq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovsxdq 485498096(%edx), %xmm1

// CHECK: pmovsxdq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovsxdq 485498096, %xmm1

// CHECK: pmovsxdq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x4c,0x02,0x40]
pmovsxdq 64(%edx,%eax), %xmm1

// CHECK: pmovsxdq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x0a]
pmovsxdq (%edx), %xmm1

// CHECK: pmovsxdq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0xc9]
pmovsxdq %xmm1, %xmm1

// CHECK: pmovsxwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovsxwd -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovsxwd 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovsxwd 485498096(%edx), %xmm1

// CHECK: pmovsxwd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovsxwd 485498096, %xmm1

// CHECK: pmovsxwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x4c,0x02,0x40]
pmovsxwd 64(%edx,%eax), %xmm1

// CHECK: pmovsxwd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x0a]
pmovsxwd (%edx), %xmm1

// CHECK: pmovsxwd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0xc9]
pmovsxwd %xmm1, %xmm1

// CHECK: pmovsxwq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovsxwq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxwq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovsxwq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovsxwq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovsxwq 485498096(%edx), %xmm1

// CHECK: pmovsxwq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovsxwq 485498096, %xmm1

// CHECK: pmovsxwq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x4c,0x02,0x40]
pmovsxwq 64(%edx,%eax), %xmm1

// CHECK: pmovsxwq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x0a]
pmovsxwq (%edx), %xmm1

// CHECK: pmovsxwq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0xc9]
pmovsxwq %xmm1, %xmm1

// CHECK: pmovzxbd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovzxbd -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxbd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovzxbd 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxbd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovzxbd 485498096(%edx), %xmm1

// CHECK: pmovzxbd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovzxbd 485498096, %xmm1

// CHECK: pmovzxbd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x4c,0x02,0x40]
pmovzxbd 64(%edx,%eax), %xmm1

// CHECK: pmovzxbd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x0a]
pmovzxbd (%edx), %xmm1

// CHECK: pmovzxbd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0xc9]
pmovzxbd %xmm1, %xmm1

// CHECK: pmovzxbq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovzxbq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxbq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovzxbq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxbq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovzxbq 485498096(%edx), %xmm1

// CHECK: pmovzxbq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovzxbq 485498096, %xmm1

// CHECK: pmovzxbq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x4c,0x02,0x40]
pmovzxbq 64(%edx,%eax), %xmm1

// CHECK: pmovzxbq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x0a]
pmovzxbq (%edx), %xmm1

// CHECK: pmovzxbq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0xc9]
pmovzxbq %xmm1, %xmm1

// CHECK: pmovzxbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovzxbw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovzxbw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovzxbw 485498096(%edx), %xmm1

// CHECK: pmovzxbw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovzxbw 485498096, %xmm1

// CHECK: pmovzxbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x4c,0x02,0x40]
pmovzxbw 64(%edx,%eax), %xmm1

// CHECK: pmovzxbw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x0a]
pmovzxbw (%edx), %xmm1

// CHECK: pmovzxbw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0xc9]
pmovzxbw %xmm1, %xmm1

// CHECK: pmovzxdq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovzxdq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxdq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovzxdq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxdq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovzxdq 485498096(%edx), %xmm1

// CHECK: pmovzxdq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovzxdq 485498096, %xmm1

// CHECK: pmovzxdq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x4c,0x02,0x40]
pmovzxdq 64(%edx,%eax), %xmm1

// CHECK: pmovzxdq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x0a]
pmovzxdq (%edx), %xmm1

// CHECK: pmovzxdq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0xc9]
pmovzxdq %xmm1, %xmm1

// CHECK: pmovzxwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovzxwd -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovzxwd 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovzxwd 485498096(%edx), %xmm1

// CHECK: pmovzxwd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovzxwd 485498096, %xmm1

// CHECK: pmovzxwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x4c,0x02,0x40]
pmovzxwd 64(%edx,%eax), %xmm1

// CHECK: pmovzxwd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x0a]
pmovzxwd (%edx), %xmm1

// CHECK: pmovzxwd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0xc9]
pmovzxwd %xmm1, %xmm1

// CHECK: pmovzxwq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmovzxwq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxwq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmovzxwq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmovzxwq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x8a,0xf0,0x1c,0xf0,0x1c]
pmovzxwq 485498096(%edx), %xmm1

// CHECK: pmovzxwq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x0d,0xf0,0x1c,0xf0,0x1c]
pmovzxwq 485498096, %xmm1

// CHECK: pmovzxwq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x4c,0x02,0x40]
pmovzxwq 64(%edx,%eax), %xmm1

// CHECK: pmovzxwq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x0a]
pmovzxwq (%edx), %xmm1

// CHECK: pmovzxwq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0xc9]
pmovzxwq %xmm1, %xmm1

// CHECK: pmuldq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmuldq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmuldq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmuldq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmuldq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x8a,0xf0,0x1c,0xf0,0x1c]
pmuldq 485498096(%edx), %xmm1

// CHECK: pmuldq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x0d,0xf0,0x1c,0xf0,0x1c]
pmuldq 485498096, %xmm1

// CHECK: pmuldq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x4c,0x02,0x40]
pmuldq 64(%edx,%eax), %xmm1

// CHECK: pmuldq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x0a]
pmuldq (%edx), %xmm1

// CHECK: pmuldq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0xc9]
pmuldq %xmm1, %xmm1

// CHECK: pmulld -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmulld -485498096(%edx,%eax,4), %xmm1

// CHECK: pmulld 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmulld 485498096(%edx,%eax,4), %xmm1

// CHECK: pmulld 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x8a,0xf0,0x1c,0xf0,0x1c]
pmulld 485498096(%edx), %xmm1

// CHECK: pmulld 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x0d,0xf0,0x1c,0xf0,0x1c]
pmulld 485498096, %xmm1

// CHECK: pmulld 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x4c,0x02,0x40]
pmulld 64(%edx,%eax), %xmm1

// CHECK: pmulld (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x0a]
pmulld (%edx), %xmm1

// CHECK: pmulld %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0xc9]
pmulld %xmm1, %xmm1

// CHECK: ptest -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
ptest -485498096(%edx,%eax,4), %xmm1

// CHECK: ptest 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
ptest 485498096(%edx,%eax,4), %xmm1

// CHECK: ptest 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x8a,0xf0,0x1c,0xf0,0x1c]
ptest 485498096(%edx), %xmm1

// CHECK: ptest 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x0d,0xf0,0x1c,0xf0,0x1c]
ptest 485498096, %xmm1

// CHECK: ptest 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x4c,0x02,0x40]
ptest 64(%edx,%eax), %xmm1

// CHECK: ptest (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x0a]
ptest (%edx), %xmm1

// CHECK: ptest %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0xc9]
ptest %xmm1, %xmm1

// CHECK: roundpd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
roundpd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: roundpd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
roundpd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: roundpd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
roundpd $0, 485498096(%edx), %xmm1

// CHECK: roundpd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
roundpd $0, 485498096, %xmm1

// CHECK: roundpd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x4c,0x02,0x40,0x00]
roundpd $0, 64(%edx,%eax), %xmm1

// CHECK: roundpd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x0a,0x00]
roundpd $0, (%edx), %xmm1

// CHECK: roundpd $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0xc9,0x00]
roundpd $0, %xmm1, %xmm1

// CHECK: roundps $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
roundps $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: roundps $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
roundps $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: roundps $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
roundps $0, 485498096(%edx), %xmm1

// CHECK: roundps $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
roundps $0, 485498096, %xmm1

// CHECK: roundps $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x4c,0x02,0x40,0x00]
roundps $0, 64(%edx,%eax), %xmm1

// CHECK: roundps $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x0a,0x00]
roundps $0, (%edx), %xmm1

// CHECK: roundps $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0xc9,0x00]
roundps $0, %xmm1, %xmm1

// CHECK: roundsd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
roundsd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: roundsd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
roundsd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: roundsd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
roundsd $0, 485498096(%edx), %xmm1

// CHECK: roundsd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
roundsd $0, 485498096, %xmm1

// CHECK: roundsd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x4c,0x02,0x40,0x00]
roundsd $0, 64(%edx,%eax), %xmm1

// CHECK: roundsd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x0a,0x00]
roundsd $0, (%edx), %xmm1

// CHECK: roundsd $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0xc9,0x00]
roundsd $0, %xmm1, %xmm1

// CHECK: roundss $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
roundss $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: roundss $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
roundss $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: roundss $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
roundss $0, 485498096(%edx), %xmm1

// CHECK: roundss $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
roundss $0, 485498096, %xmm1

// CHECK: roundss $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x4c,0x02,0x40,0x00]
roundss $0, 64(%edx,%eax), %xmm1

// CHECK: roundss $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x0a,0x00]
roundss $0, (%edx), %xmm1

// CHECK: roundss $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0xc9,0x00]
roundss $0, %xmm1, %xmm1

