; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown             | FileCheck %s --check-prefixes=X86,X86-NOSSE
; RUN: llc < %s -mtriple=i686-unknown -mattr=sse2 | FileCheck %s --check-prefixes=X86,X86-SSE2
; RUN: llc < %s -mtriple=i686-unknown -mattr=avx | FileCheck %s --check-prefixes=X86,X86-AVX
; RUN: llc < %s -mtriple=i686-unknown -mattr=avx512f | FileCheck %s --check-prefixes=X86,X86-AVX
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=X64,X64-SSE
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx | FileCheck %s --check-prefixes=X64,X64-AVX
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx512f | FileCheck %s --check-prefixes=X64,X64-AVX

define i64 @testmsxs(float %x) {
; X86-NOSSE-LABEL: testmsxs:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    pushl %ebp
; X86-NOSSE-NEXT:    .cfi_def_cfa_offset 8
; X86-NOSSE-NEXT:    .cfi_offset %ebp, -8
; X86-NOSSE-NEXT:    movl %esp, %ebp
; X86-NOSSE-NEXT:    .cfi_def_cfa_register %ebp
; X86-NOSSE-NEXT:    andl $-8, %esp
; X86-NOSSE-NEXT:    subl $8, %esp
; X86-NOSSE-NEXT:    flds 8(%ebp)
; X86-NOSSE-NEXT:    fistpll (%esp)
; X86-NOSSE-NEXT:    movl (%esp), %eax
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOSSE-NEXT:    movl %ebp, %esp
; X86-NOSSE-NEXT:    popl %ebp
; X86-NOSSE-NEXT:    .cfi_def_cfa %esp, 4
; X86-NOSSE-NEXT:    retl
;
; X86-SSE2-LABEL: testmsxs:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    .cfi_def_cfa_offset 8
; X86-SSE2-NEXT:    .cfi_offset %ebp, -8
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    .cfi_def_cfa_register %ebp
; X86-SSE2-NEXT:    andl $-8, %esp
; X86-SSE2-NEXT:    subl $8, %esp
; X86-SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    movss %xmm0, (%esp)
; X86-SSE2-NEXT:    flds (%esp)
; X86-SSE2-NEXT:    fistpll (%esp)
; X86-SSE2-NEXT:    movl (%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    .cfi_def_cfa %esp, 4
; X86-SSE2-NEXT:    retl
;
; X86-AVX-LABEL: testmsxs:
; X86-AVX:       # %bb.0: # %entry
; X86-AVX-NEXT:    pushl %ebp
; X86-AVX-NEXT:    .cfi_def_cfa_offset 8
; X86-AVX-NEXT:    .cfi_offset %ebp, -8
; X86-AVX-NEXT:    movl %esp, %ebp
; X86-AVX-NEXT:    .cfi_def_cfa_register %ebp
; X86-AVX-NEXT:    andl $-8, %esp
; X86-AVX-NEXT:    subl $8, %esp
; X86-AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX-NEXT:    vmovss %xmm0, (%esp)
; X86-AVX-NEXT:    flds (%esp)
; X86-AVX-NEXT:    fistpll (%esp)
; X86-AVX-NEXT:    movl (%esp), %eax
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX-NEXT:    movl %ebp, %esp
; X86-AVX-NEXT:    popl %ebp
; X86-AVX-NEXT:    .cfi_def_cfa %esp, 4
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: testmsxs:
; X64-SSE:       # %bb.0: # %entry
; X64-SSE-NEXT:    cvtss2si %xmm0, %rax
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: testmsxs:
; X64-AVX:       # %bb.0: # %entry
; X64-AVX-NEXT:    vcvtss2si %xmm0, %rax
; X64-AVX-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.llrint.f32(float %x)
  ret i64 %0
}

define i64 @testmsxd(double %x) {
; X86-NOSSE-LABEL: testmsxd:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    pushl %ebp
; X86-NOSSE-NEXT:    .cfi_def_cfa_offset 8
; X86-NOSSE-NEXT:    .cfi_offset %ebp, -8
; X86-NOSSE-NEXT:    movl %esp, %ebp
; X86-NOSSE-NEXT:    .cfi_def_cfa_register %ebp
; X86-NOSSE-NEXT:    andl $-8, %esp
; X86-NOSSE-NEXT:    subl $8, %esp
; X86-NOSSE-NEXT:    fldl 8(%ebp)
; X86-NOSSE-NEXT:    fistpll (%esp)
; X86-NOSSE-NEXT:    movl (%esp), %eax
; X86-NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOSSE-NEXT:    movl %ebp, %esp
; X86-NOSSE-NEXT:    popl %ebp
; X86-NOSSE-NEXT:    .cfi_def_cfa %esp, 4
; X86-NOSSE-NEXT:    retl
;
; X86-SSE2-LABEL: testmsxd:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    .cfi_def_cfa_offset 8
; X86-SSE2-NEXT:    .cfi_offset %ebp, -8
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    .cfi_def_cfa_register %ebp
; X86-SSE2-NEXT:    andl $-8, %esp
; X86-SSE2-NEXT:    subl $8, %esp
; X86-SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    movsd %xmm0, (%esp)
; X86-SSE2-NEXT:    fldl (%esp)
; X86-SSE2-NEXT:    fistpll (%esp)
; X86-SSE2-NEXT:    movl (%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    .cfi_def_cfa %esp, 4
; X86-SSE2-NEXT:    retl
;
; X86-AVX-LABEL: testmsxd:
; X86-AVX:       # %bb.0: # %entry
; X86-AVX-NEXT:    pushl %ebp
; X86-AVX-NEXT:    .cfi_def_cfa_offset 8
; X86-AVX-NEXT:    .cfi_offset %ebp, -8
; X86-AVX-NEXT:    movl %esp, %ebp
; X86-AVX-NEXT:    .cfi_def_cfa_register %ebp
; X86-AVX-NEXT:    andl $-8, %esp
; X86-AVX-NEXT:    subl $8, %esp
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    vmovsd %xmm0, (%esp)
; X86-AVX-NEXT:    fldl (%esp)
; X86-AVX-NEXT:    fistpll (%esp)
; X86-AVX-NEXT:    movl (%esp), %eax
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX-NEXT:    movl %ebp, %esp
; X86-AVX-NEXT:    popl %ebp
; X86-AVX-NEXT:    .cfi_def_cfa %esp, 4
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: testmsxd:
; X64-SSE:       # %bb.0: # %entry
; X64-SSE-NEXT:    cvtsd2si %xmm0, %rax
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: testmsxd:
; X64-AVX:       # %bb.0: # %entry
; X64-AVX-NEXT:    vcvtsd2si %xmm0, %rax
; X64-AVX-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.llrint.f64(double %x)
  ret i64 %0
}

define i64 @testmsll(x86_fp80 %x) {
; X86-LABEL: testmsll:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    fldt 8(%ebp)
; X86-NEXT:    fistpll (%esp)
; X86-NEXT:    movl (%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    retl
;
; X64-LABEL: testmsll:
; X64:       # %bb.0: # %entry
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fistpll -{{[0-9]+}}(%rsp)
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.llrint.f80(x86_fp80 %x)
  ret i64 %0
}

declare i64 @llvm.llrint.f32(float) nounwind readnone
declare i64 @llvm.llrint.f64(double) nounwind readnone
declare i64 @llvm.llrint.f80(x86_fp80) nounwind readnone
