; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -ipsccp -S | FileCheck %s

declare void @use(i1)
define void @sdiv1_cmp_constants(i32 %x) {
; CHECK-LABEL: @sdiv1_cmp_constants(
; CHECK-NEXT:    [[D:%.*]] = sdiv i32 1, [[X:%.*]]
; CHECK-NEXT:    [[C_0:%.*]] = icmp slt i32 0, [[D]]
; CHECK-NEXT:    call void @use(i1 [[C_0]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C_3:%.*]] = icmp eq i32 1, [[D]]
; CHECK-NEXT:    call void @use(i1 [[C_3]])
; CHECK-NEXT:    [[C_4:%.*]] = icmp eq i32 0, [[D]]
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    ret void
;
  %d = sdiv i32 1, %x
  %c.0 = icmp slt i32 0, %d
  call void @use(i1 %c.0)
  %c.1 = icmp slt i32 1, %d
  call void @use(i1 %c.1)
  %c.2 = icmp slt i32 2, %d
  call void @use(i1 %c.2)

  %c.3 = icmp eq i32 1, %d
  call void @use(i1 %c.3)
  %c.4 = icmp eq i32 0, %d
  call void @use(i1 %c.4)
  %c.5 = icmp eq i32 2, %d
  call void @use(i1 %c.5)

  ret void
}

define void @sdiv1_cmp_range_1(i32 %x, i1 %c) {
; CHECK-LABEL: @sdiv1_cmp_range_1(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 1, [[BB1]] ], [ 2, [[BB2]] ]
; CHECK-NEXT:    [[D:%.*]] = sdiv i32 1, [[X:%.*]]
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i32 [[P]], [[D]]
; CHECK-NEXT:    call void @use(i1 [[C_1]])
; CHECK-NEXT:    ret void
;
  br i1 %c, label %bb1, label %bb2
bb1:
  br label %bb3
bb2:
  br label %bb3

bb3:
  %p = phi i32 [1, %bb1], [2, %bb2]
  %d = sdiv i32 1, %x
  %c.0 = icmp slt i32 %p, %d
  call void @use(i1 %c.0)
  %c.1 = icmp eq i32 %p, %d
  call void @use(i1 %c.1)
  ret void
}


define void @sdiv1_cmp_range_2(i32 %x, i1 %c) {
; CHECK-LABEL: @sdiv1_cmp_range_2(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 3, [[BB1]] ], [ 2, [[BB2]] ]
; CHECK-NEXT:    [[D:%.*]] = sdiv i32 1, [[X:%.*]]
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    ret void
;
  br i1 %c, label %bb1, label %bb2
bb1:
  br label %bb3
bb2:
  br label %bb3

bb3:
  %p = phi i32 [3, %bb1], [2, %bb2]
  %d = sdiv i32 1, %x
  %c.0 = icmp slt i32 %p, %d
  call void @use(i1 %c.0)
  %c.1 = icmp eq i32 %p, %d
  call void @use(i1 %c.1)
  ret void
}
