<?php
require_once dirname(__DIR__) . '/../../wp-config.php';

$dsn = 'mysql:dbname='.$config['dbname'].';host='.$config['dbhost'].';charset=UTF8';
try {
    $dbh = new PDO($dsn, $config['dbname'], $config['dbpassword'], array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
} catch (PDOException $e) {
    echo 'Connexion échouée : ' . $e->getMessage();
}

$req = 'SELECT a.content, a.id, a.user_id, a.hide_sitewide, a.date_recorded, u.id, u.user_login AS comment_author
        FROM wp_bp_activity a, wp_users u
        WHERE a.Type = "activity_update"
        AND a.user_id = u.id
        AND a.hide_sitewide = :hide_sitewide
        ORDER BY a.id DESC
        LIMIT 0, 3';
$query = $dbh->prepare($req);
$query->bindValue(':hide_sitewide', '0');
$query->execute();
$data = $query->fetchAll(PDO::FETCH_OBJ);
$count = $query->rowCount();

if($count > 0){
    $message = 'Vous avez ' . $count . ngettext(' nouveau', ' nouveaux', $count) .  ngettext(' message', ' messages', $count) . ' dans le <a target="_blanck" title="Ouvrir le réseau social" href="/wordpress/activites-du-site/">réseau social</a><hr>';
    foreach ($data as $key => $value) {
        $message .= '<div class="comment" style="color: #000 !important;padding: 4px;margin-bottom: 1.875rem;position: relative;border: 1px solid #ebebeb;background-color: #f4f4f4;font-size: 12px;border-radius: 3px;">';
        $message .= '<div class="comment-body">';
        $message .= '<span class="comment-author" style="font-weight: 700;font-size: 1rem;">'.$value->comment_author.'</span>';
        $message .= '<span class="comment-date"> le ' . date('d/m/Y H:i:s', strtotime($value->date_recorded)) . '</span>';
        $message .= '<div class="comment-text" style="margin-top: .5rem;line-height: 1;">'. nl2br($value->content) .'</div>';
        $message .= '</div>';
        $message .= '</div>';
    }
}
else $message = 'Pas de nouveau message';

$message = preg_replace("/\r|\n/", "", $message);
$ret="<script>";
$ret=$ret."parent.getMails(".$_GET["id"].",'$message');";
$ret=$ret."</script>";
echo $ret;