<?php
/*
  Plugin Name: wpCAS-envole
  Version: 2.0
*/


$error_reporting = error_reporting(0); 				// Cacher les erreurs
include_once(dirname(__FILE__).'/wpcas-conf.php');	// Insérer la conf CAS
error_reporting($error_reporting);					// Visible les erreurs



//== IS_USER_LOGGED_IN ===============================================================================
// Remplacer la fonction définie dans "wp-includes/pluggable.php"
// pour permettre la déconnexion globale (Single Sign Out)

if (!function_exists('is_user_logged_in')) : //lors de l'install, pluggable.php est chargé en premier... (wpcas.php est chargé lors de l'activation par activate_plugin() dans wp-admin/includes/plugin.php, quelle utilité ?!)
	function is_user_logged_in()
	{
		//procédure de la fonction originale
		$user = wp_get_current_user();
		$existe_wordpress_user = !empty($user->ID);
		$existe_cas_user = !empty($_SESSION["phpCAS"]["user"]);
		$test = (!$existe_wordpress_user || !$existe_cas_user) ? : ($user->user_login==$_SESSION["phpCAS"]["user"]);

		if($existe_wordpress_user && !$test){
		wp_clear_auth_cookie();
			wp_set_current_user(0);
		}

		$user = wp_get_current_user();
		$existe_wordpress_user = !empty($user->ID);

		return $existe_wordpress_user;
	}
endif;

//== IS_ADMIN_LOGGED_IN ==============================================================================
// La partie d'administration n'utilise pas "is_user_logged_in()" mais "auth_redirect()"
// donc on ajoute un hook mais comme il se trouve après la vérification des cookies, on redirige

function is_admin_logged_in()
{
	$user = wp_get_current_user(); //on récupère les infos de l'utilisateur authentifié par cookies
	if(!eolephpCAS::isAuthenticated() || $user->user_login!=eolephpCAS::getUser())
	{
		wp_clear_auth_cookie();
		$login = "wp-login.php?redirect_to=/wp-admin/";
		wp_redirect(function_exists('site_url')  ? site_url($login) : $login);
		exit();
	}
}

//== AUTO_CONNECT =====================================================================================
// EOLE : gère l'auto connection à wordpress si l'utilisateur est identifié sur le SSO
// gère également la déconnection automatique et le changement d'utilisateur automatique
// utilise la fonction gateway du SSO, si l'utilisateur n'est pas identifié il accede
// quand même à la partie publique de wordpress

function auto_connect(){
	global $current_user;

	if(eolephpCAS::checkAuthentication()) {
		get_currentuserinfo();
		$wordpress_user=$current_user->user_login;
		$cas_user=eolephpCAS::getUser();
		
		if (!is_user_logged_in()){
			wp_redirect("wp-login.php?redirect_to=".str_replace("http://","https://",eolephpCAS::getServiceURL()));
			exit();
		}
		else if($cas_user!=$wordpress_user ) {
			wp_redirect("wp-login.php?redirect_to=".str_replace("http://","https://",eolephpCAS::getServiceURL()));
			exit();
		}
	}
	else {
		if (is_user_logged_in()){
			$urllogout=str_replace("amp;","",wp_logout_url(get_settings('siteurl')));
			wp_redirect($urllogout);
			exit();
		}
	}
}

//== TEST_PRIVATE ====================================================================================

function test_private(){
	global $current_user;

	// Récupérer le blog en cours
	$currentblog=get_current_blog_id();
	$detailsite=get_blog_details($currentblog);

	// Site privé
	if($detailsite->public==0) {
		// si l'utilisateur n'est pas connecté on le redirige vers une page d'interdiction
		if(!is_user_logged_in()) {
			header("location: /wordpress/wp-content/plugins/denied.php");
			exit();
		}
		// sinon on vérifie qu'il appartient à la liste des utilisateurs de ce site
		elseif(!current_user_can_for_blog($currentblog, "read")) {
			header("location: /wordpress/wp-content/plugins/denied.php");
			exit();
		}
	}
}

//== CLASS WPCAS =====================================================================================

class wpCAS{
	function authenticate(){
		global $wpdb;
		global $wpcas_options, $cas_configured;

		//forcer à redemander les infos auprès du serveur CAS
		unset($_SESSION["phpCAS"]);

		if(eolephpCAS::isAuthenticated()){
			$attributs=eolephpCAS::getDetails();
			if(!isset($attributs["utilisateur"])&&isset($attributs["attributes"])) {
				$attributs["utilisateur"]=$attributs["attributes"];
			}

			//correspondances des statuts
			$profils = array
				(
				"National_1" => "eleve",
				"National_2" => "responsable",
				"National_3" => "professeur",
				"National_6" => "administratif",
				"administrateur" => "administrateur",
				"autre" => "visiteur"
				);
		
			$login = $attributs['utilisateur']['user'][0];
			$mail = $attributs['utilisateur']['email'][0];
			$cas_profil = $attributs['utilisateur']['profil'][0];

			if(array_key_exists($cas_profil,$profils)) $profil =  $profils[$cas_profil];
			else $profil =  $profils["autre"];


			// Modification / Création utilsateur
			if ($user = get_userdatabylogin($login))
				wp_set_auth_cookie($user->ID);
			else 
				wpcas_nowpuser($login,$mail,$profil);

			error_log("WORPPRESS ROLE = ".$profil);

			if(isset($_REQUEST['redirect_to'])){
				$local_redirect_to=$_REQUEST['redirect_to'];
			
				// force la redirection en https lors d'un accès direct à la partie admin en http pour eviter une boucle de redirection infinie
				if(preg_match('/^http[^s]/', $local_redirect_to) && preg_match('/wp-admin/', $local_redirect_to))
					$local_redirect_to=preg_replace('/^http/', 'https', $local_redirect_to);
			
				// bad code is bad (but working) /!\ ne marche pas dans l'autre sens
				$local_redirect_to=function_exists('site_url') ? preg_match('/^http/', $local_redirect_to) ?
				$local_redirect_to : site_url($local_redirect_to) : $local_redirect_to;
				wp_redirect($local_redirect_to);
				
			}
			else{
				wp_redirect(function_exists('site_url')  ? site_url('index.php') : 'index.php');
			}
		  
			exit();
		}
		else{
			// hey, authenticate
			eolephpCAS::forceAuthentication();
			die();
		}
	}

	// hook CAS logout to WP logout
	function logout(){
		eolephpCAS::logout(array('service' => get_settings('siteurl')));
		exit();
	}

	// hide password fields on user profile page.
	function show_password_fields($show_password_fields){
		return false;
	}

	// disabled reset, lost, and retrieve password features
	function disable_function(){
		die(__('Sorry, this feature is disabled.', 'wpcas'));
	}
}




//== MAIN ============================================================================================

// Démarrage de session
@session_start(); 
if (__CAS_DEBUG){
	eolephpCAS::setDebug("/var/log/phpcas/phpCAS-wordpress.log");
}
eolephpCAS::client(CAS_VERSION_2_0, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, true);
eolephpCAS::setNoClearTicketsFromUrl();

if ($wpcas_options['cas_validation_ca']) {
	eolephpCAS::setCasServerCACert($wpcas_options['cas_ca_location']);
}
else {
    if (method_exists('eolephpCAS', 'setNoCasServerValidation')){
        eolephpCAS::setNoCasServerValidation();
    }
}

if (__CAS_LOGOUT){
	if(method_exists('eolephpCAS','EoleLogoutRequests')) eolephpCAS::EoleLogoutRequests(false);
}

// plugin hooks into authentication system
add_action('wp_authenticate', array('wpCAS', 'authenticate'), 10, 2);
add_action('wp_logout', array('wpCAS', 'logout'));
add_action('lost_password', array('wpCAS', 'disable_function'));
add_action('retrieve_password', array('wpCAS', 'disable_function'));
add_action('password_reset', array('wpCAS', 'disable_function'));
add_filter('show_password_fields', array('wpCAS', 'show_password_fields'));

// Hook présent dans "wp-admin/admin.php"
add_action('admin_init', 'is_admin_logged_in');


// Insérer les actions si nous ne sommes pas en lecture de flux
if (stripos(parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH),"/feed")==0) {
    add_action('template_redirect', 'auto_connect');
    add_action('template_redirect', 'test_private');
}

?>
