<?php

function execDnma($data) {
    $urlSite      = 'https://cent1d01.dnma-pp.orion.education.fr/';
    $idSite       = '10';
    $userId       = $data['login'];
    $time         = new DateTime($data['time']);
    $timestamp    = $time->getTimestamp() * 1000;
    $appli        = $data['appli'];
    $rubrique     = $data['rubrique'];
    $page         = $data['page']; 
    $urlPage      = $data['route'];
    $profil       = $data['profil'];

    $dimensions   = [
        // dimension1 = UAI
        1  =>  $data['etab'],
        // dimension2 = PROFIL
        2  => DnmaProfil($profil),   
        // dimension3 = EXPLOITANT
        3  => 'MEN-PCLL',         
        // dimension4 = PLATEFORME
        4  => 'ENVOLE',                             
        // dimension6 = OUTIL
        6  => strtoupperSansAccents($appli),   
        // dimension7 = TYPE
        7  => DnmaTypebyAppli($appli),                                      
        // dimension8 = SERVICE
        8  => DnmaServicebyAppli($appli,$rubrique),    
        // dimension9 = MODULE
        9  => '',       
        // dimension10 = RUBRIQUE
        10 => DnmaRubriquebyAppli($appli,$rubrique),
        // dimension11 = TECHNO_ACCES
        11 => 'WEB-PWA'                        
    ];

    // Construction de l'URL de tracking
    $query = [
        'idsite'      => $idSite,
        'rec'         => '1',
        'apiv'        => '1',
        'rand'        => bin2hex(random_bytes(4)), // ou uniqid()
        'uid'         => $userId,
        '_id'         => $userId,
        'url'         => $urlPage,
        'pv_id'       => $userId,
        'action_name' => DnmaPagebyAppli($appli,$page),
        'cdt'         => $timestamp,
    ];

    // Ajout des dimensions personnalisées
    foreach ($dimensions as $key => $value) {
        $query["dimension$key"] = $value;
    }

    $finalUrl = $urlSite . '/matomo.php?' . http_build_query($query);
    fetchUrl($finalUrl);
}

function DnmaTypebyAppli($appli) {
    switch (strtoupperSansAccents($appli)) {
        // Natif
        case 'NINEGATE':        return "NATIF";
        case 'NINEBOARD':       return "NATIF";
        case 'NINESCHOOL':      return "NATIF";
        case 'NINESKELETOR':    return "NATIF";
        case 'NINESURVEY':      return "NATIF";

        // Tiers maintenus
        case 'GRR':             return "TIERS";
        case 'KANBOARD':        return "TIERS";
        case 'LIMESURVEY':      return "TIERS";
        case 'MOODLE':          return "TIERS";
        case 'NEXTCLOUD':       return "TIERS";
        case 'OPENSONDAGE':     return "TIERS";
        case 'ROUNDCUBE':       return "TIERS";
        case 'WORDPRESS':       return "TIERS";

        // Tiers plus maintenus
        case 'BALADO':          return 'TIERS';
        case 'CALENDRIER':      return "TIERS";
        case 'CDT':             return "TIERS";
        case 'DOKUWIKI':        return "TIERS";
        case 'ECONNECT':        return "TIERS";
        case 'EDISPATCHER':     return "TIERS";
        case 'ETHERHOME':       return "TIERS";
        case 'FLUXBB':          return "TIERS";
        case 'GEPI':            return "TIERS";
        case 'MAHARA':          return "TIERS";
        case 'MINDMAPS':        return "TIERS";
        case 'PIWIGO':          return "TIERS";
        case 'SACOCHE':         return "TIERS";

        default:                return "TIERS";
    }
}

function DnmaServicebyAppli($appli,$rubrique) {
    switch (strtoupperSansAccents($appli)) {
        // Natif
        case "NINEGATE":
            switch($rubrique){
                case "Accueil": return "ACCUEIL";
                case "Mon profil": return "PAGE_ENT";
                case "Annuaire": return "CORRIER_ELECTRONIQUE";
                case "Charte": return "PAGE_ENT";
                case "Mes Groupes": return "PAGE_ENT";
                default: return "ACCUEIL";
            }
        case 'NINEBOARD':       return "PRODUCTION_COLLABORATIVE";
        case 'NINESCHOOL':      return "PARCOURS_PEDAGOGIQUE";
        case 'NINESKELETOR':    return "PAGE_ENT";
        case 'NINESURVEY':      return "GESTION_TEMPS";

        // Tiers maintenus
        case 'GRR':             return "RESERVATION_SALLES_MATERIELS";
        case 'KANBOARD':        return "GESTION_TEMPS";
        case 'LIMESURVEY':      return "PAGE_ENT";
        case 'MOODLE':          return "PARCOURS_PEDAGOGIQUE";
        case 'NEXTCLOUD':       return "PRODUCTION_COLLABORATIVE";
        case 'OPENSONDAGE':     return "GESTION_TEMPS";
        case 'ROUNDCUBE':       return "COURRIER_ELECTRONIQUE";
        case 'WORDPRESS':       return "PRODUCTION_COLLABORATIVE";

        // Tiers plus maintenus
        case 'BALADO':          return "PARCOURS_PEDAGOGIQUE";
        case 'CALENDRIER':      return "GESTION_TEMPS";
        case 'CDT':             return "SERVICES_VIE_SCOLAIRE";
        case 'DOKUWIKI':        return "PRODUCTION_COLLABORATIVE";
        case 'ECONNECT':        return "PAGE_ENT";
        case 'EDISPATCHER':     return "PAGE_ENT";
        case 'ETHERHOME':       return "PRODUCTION_COLLABORATIVE";
        case 'FLUXBB':          return "PRODUCTION_COLLABORATIVE";
        case 'GEPI':            return "SERVICES_VIE_SCOLAIRE";
        case 'MAHARA':          return "GESTION_COMPETENCES";
        case 'MINDMAPS':        return "PRODUCTION_COLLABORATIVE";
        case 'PIWIGO':          return "STOCKAGE_PARTAGE";
        case 'SACOCHE':         return "GESTION_COMPETENCES";

        
        default:                return ($rubrique?$rubrique:"PAGE_ENT");
    }
}

function DnmaRubriquebyAppli($appli,$rubrique) {
    switch (strtoupperSansAccents($appli)) {
        case 'NINEGATE': return $rubrique;
        case 'NINESCHOOL': return $rubrique;
        case 'NINEBOARD': return $rubrique;
        default: return $appli ? ucfirst(strtolower($appli)):'Accueil';
    }
}

function DnmaPagebyAppli($appli,$page) {
    switch (strtoupperSansAccents($appli)) {
        case 'NINEGATE': return $page;
        case 'NINESCHOOL': return $page;
        case 'NINEBOARD': return $page;
        default: return $appli ? 'ACCES_'.ucfirst(strtolower($appli)):'ACCES_Accueil';
    }
}

function DnmaProfil($profil) {
    switch ($profil) {
        case 'National_1':      return "ELEVE";
        case 'National_2':      return "PARENT";
        case 'National_3':      return "ENSEIGNANT";
        case 'National_6':      return "ADMIN_VIE_SCOL_TECH";
        case 'administrateur':  return "ADMIN_VIE_SCOL_TECH";
        case 'autre':           return "AUTRE";
        default:                return "AUTRE";
    }
}