<?php

namespace App\Entity;

use App\Repository\SurveyoptionRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SurveyoptionRepository::class)
 */
class Surveyoption
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(name="date", type="datetime")
     */
    private $date;

    /**
     * @ORM\Column(type="boolean")
     */
    private $choiced;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Surveyvote", mappedBy="surveyoption", cascade={"persist"}, orphanRemoval=true)
     */
    private $surveyvotes;
    
    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Survey", inversedBy="surveyoptions")
     */
    private $survey;

    public function __construct()
    {
        $this->surveyvotes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDate(): ?\DateTimeInterface
    {
        return $this->date;
    }

    public function setDate(\DateTimeInterface $date): self
    {
        $this->date = $date;

        return $this;
    }

    public function getChoiced(): ?bool
    {
        return $this->choiced;
    }

    public function setChoiced(bool $choiced): self
    {
        $this->choiced = $choiced;

        return $this;
    }

    /**
     * @return Collection|Surveyvote[]
     */
    public function getSurveyvotes(): Collection
    {
        return $this->surveyvotes;
    }

    public function addSurveyvote(Surveyvote $surveyvote): self
    {
        if (!$this->surveyvotes->contains($surveyvote)) {
            $this->surveyvotes[] = $surveyvote;
            $surveyvote->setOption($this);
        }

        return $this;
    }

    public function removeSurveyvote(Surveyvote $surveyvote): self
    {
        if ($this->surveyvotes->removeElement($surveyvote)) {
            // set the owning side to null (unless already changed)
            if ($surveyvote->getOption() === $this) {
                $surveyvote->setOption(null);
            }
        }

        return $this;
    }

    public function getSurvey(): ?Survey
    {
        return $this->survey;
    }

    public function setSurvey(?Survey $survey): self
    {
        $this->survey = $survey;

        return $this;
    }

}
