<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Cadoles\PortalBundle\Entity\Bookmark;
use Cadoles\PortalBundle\Form\BookmarkType;

class BookmarkController extends Controller
{
    private $labelroute  = 'cadoles_portal_config_bookmark';
    private $labelentity = 'CadolesPortalBundle:Bookmark';
    private $labeldata   = 'bookmark';
    private $labeldatas  = 'bookmarks';

    public function submitAction(Request $request,$idpage,$idwidget,$touser,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = new Bookmark();
        
        // On s'assure que le widget existe
        $pagewidget=null;
        if($touser=="false") {
            $pagewidget = $em->getRepository("CadolesPortalBundle:Pagewidget")->find($idwidget);
            if (!$pagewidget) throw $this->createNotFoundException('Unable to find entity.');
        }

        // Vérifier que cet enregistrement est modifiable
        if($access=="user") {
            if($usage=="user") {
                $user=$pagewidget->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            elseif($usage=="group") {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup or $usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }

        // Création du formulaire
        $form = $this->createForm(BookmarkType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            // Bookmark widget ou desktop
            if($touser=="true")
                $data->setUser($this->getUser());
            else 
                $data->setPagewidget($pagewidget);

            // Icon
            $idicon = $form->get('idicon')->getData();
            $icon=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);                

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            if($pagewidget) {
                foreach($pagewidget->getPage()->getGroups() as $groupchat) {
                    if($groupchat->getFgcanshare()) {
                        $message="Création favoris<br><a href='".$data->getUrl()."' target='_blank'>".$data->getTitle()."</a>";
                        $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$groupchat,"user"=>$this->getUser()]);
                        if($usergroup) {
                            $key=$usergroup->getKeyvalue();
                            $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$groupchat->getId(),$message);
                        }
                    }
                }
            }

            // Retour à la page
            return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_page_view',["id"=>$idpage,"usage"=>$usage,"group"=>$group]));
        }
        
        $icons=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findBy(["user"=>$this->getUser()]);

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                
            'entity'            => $data,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,
            'mode'              => "submit",
            'access'            => $access,   
            'idpage'            => $idpage,         
            'form'              => $form->createView(),
            'usage'             => $usage,
            'group'             => $group
        ]);
    }  

    public function updateAction(Request $request,$idpage,$id,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Récupération de l'enregistrement courant 
        $em = $this->getDoctrine()->getManager();
        $data=$this->getData($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que cet enregistrement est modifiable
        $user=$data->getUser();
        if($user) {
            if($usage=="user")
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
        }
        elseif($access=="user") {
            if($usage=="user") {
                $user=$data->getPagewidget()->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup or $usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }

        // Création du formulaire
        $form = $this->createForm(BookmarkType::class,$data,array(
            "mode"      => "update",
            "idicon"    => ($data->getIcon()?$data->getIcon()->getId():null),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            // Icon
            $idicon = $form->get('idicon')->getData();
            $icon=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);  

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            $pagewidget=$data->getPagewidget();
            if($pagewidget) {
                foreach($pagewidget->getPage()->getGroups() as $groupchat) {
                    if($groupchat->getFgcanshare()) {
                        $message="Modification favoris<br><a href='".$data->getUrl()."' target='_blank'>".$data->getTitle()."</a>";
                        $usergroup=$em->getRepository("CadolesCoreBundle:Usergroup")->findOneBy(["group"=>$groupchat,"user"=>$this->getUser()]);
                        if($usergroup) {
                            $key=$usergroup->getKeyvalue();
                            $websocket = $this->container->get('cadoles.websocket.pushmessage')->send($key,$this->getUser()->getId(),$groupchat->getId(),$message);
                        }
                    }
                }
            }

            // Retour à la page
            return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_page_view',["id"=>$idpage,"usage"=>$usage,"group"=>$group]));
        }
        
        $icons=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findBy(["user"=>$this->getUser()]);

        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                
            'entity'            => $data,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,
            'mode'              => "update",
            'access'            => $access,   
            'idpage'            => $idpage,         
            'form'              => $form->createView(),
            'usage'             => $usage,
            'group'             => $group
        ]);
    }

    public function deleteAction(Request $request,$idpage,$id,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Récupération de l'enregistrement courant 
        $em = $this->getDoctrine()->getManager();
        $data=$this->getData($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que cet enregistrement est supprimable
        $user=$data->getUser();
        if($user) {
            if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
        }
        elseif($access=="user") {
            if($usage=="user") {
                $user=$data->getPagewidget()->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup or $usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }


        // Supprimer la donnée
        $em = $this->getDoctrine()->getManager();
        $em->remove($data);
        $em->flush();
        
        // Retour à la page
        return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_page_view',["id"=>$idpage,"usage"=>$usage,"group"=>$group]));
    }

    public function heartAction(Request $request)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $iditem=$request->request->get('iditem');

        // On s'assure que l'item existe        
        $em = $this->getDoctrine()->getManager();
        $item = $em->getRepository("CadolesPortalBundle:Item")->find($iditem);
        if (!$item) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'item n'existe pas déjà dans les bookmark de l'utilisateur
        $user=$this->getUser();
        $bookmark = $em->getRepository($this->labelentity)->findOneBy(["user"=>$user,"item"=>$item]);
        if(!$bookmark) {
            $bookmark = new Bookmark();
            $bookmark->setTitle($item->getTitle());
            $bookmark->setSubtitle($item->getSubtitle());
            $bookmark->setUrl($item->getUrl());
            $bookmark->setIcon($item->getIcon());
            $bookmark->setColor($item->getColor());
            $bookmark->setTarget($item->getTarget());
            $bookmark->setItem($item);
            $bookmark->setUser($user);

            $em->persist($bookmark);
            $em->flush();            
        }
        $output=$bookmark->getId();
        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }

    protected function getDatas()
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
