<?php

namespace Cadoles\CoreBundle\EventListener;

use Doctrine\ORM\EntityManager;
use Cadoles\CoreBundle\Entity\Group;
use Cadoles\CoreBundle\Entity\UserGroup;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;

class syncUserGroup implements EventSubscriber
{
    protected $container;
    protected $em;
    protected $shouldSync;
    protected $oldid;
    protected $baseGroup;

    public function __construct($container, EntityManager $em) {
        $this->container = $container;
        $this->em = $em;
        $this->shouldSync = true;
    }

    public function getSubscribedEvents()
    {
        return array(
            'postPersist',
            'preUpdate',
            'postUpdate',
            'preRemove'
        );
    }

    public function preUpdate(PreUpdateEventArgs $args) {

        $entity = $args->getEntity();

        if(!($entity instanceof UserGroup)) return;

        // Aucune raison de mettre à jour LDAP et Only sur une modification
        $this->shouldSync = false;
    }

    public function postUpdate(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();

        // On met à jour/créé le rattachement utilisateur/group dans l'annuaire
        if ($entity instanceof UserGroup && $this->shouldSync) {
            $this->upsertGroup($entity);
        }
    }

    public function postPersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();

        // On créait le rattachement utilisateur/group dans l'annuaire
        if ($entity instanceof UserGroup) {
            $this->upsertGroup($entity);
        }
    }

    public function preRemove(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();

        if ($entity instanceof UserGroup) {
            $this->removeGroup($entity);
        }
    }

    public function removeGroup($group) {
        // Synchonisation LDAP
        $ldap = $this->container->get('cadoles.core.service.ldap');
        if($ldap->isEnabled()) {
            // On recherche dans l'annuaire
            $criteria = '(cn='.$group->getGroup()->getLabel().')';
            $subbranch= $this->baseGroup;
            $results = $ldap->search($criteria, array('cn'), $subbranch);

            if(count($results)) {
                $ldap->delUserGroup($group);
            }
        }    
        
        // Synchronisation Onlyoffice
        $only = $this->container->get('cadoles.core.service.only');
        if($only->isEnabled()) {
            $only->delUserGroup($group);
        }         
    }

    public function upsertGroup($group, $force = false)
    {
        // Synchonisation LDAP
        $ldap = $this->container->get('cadoles.core.service.ldap');
        if($ldap->isEnabled()) {
            // On recherche dans l'annuaire
            $criteria = '(cn='.$group->getGroup()->getLabel().')';

            $subbranch=$this->baseGroup;
            $results = $ldap->search($criteria, array('cn'), $subbranch);

            // Mise à jour si elle existe (pas normal que le group n'existe pas)
            if(count($results) > 0) {
                $ldap->addUserGroup($group);
            }
        }   
        
        // Synchronisation Onlyoffice
        $only = $this->container->get('cadoles.core.service.only');
        if($only->isEnabled()) {
            $only->addUserGroup($group);
        }         
    }

    public function getBaseGroup() {
        return $this->baseGroup;
    }

    public function setBaseGroup($baseGroup) {
        $this->baseGroup = $baseGroup;
        return $this;
    }    
}
