<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\HttpFoundation\Session\Session;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

class ConfigType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $session = new Session();
        $session->getFlashBag()->clear();

        $config = $session->get('configs');

        $builder->add('submit',
            SubmitType::class,
            array("label"       => "Valider",
                  "attr"        => array("class" => "btn btn-success")));

        $builder->add('id',
            TextType::class,
            array("label"       =>"Clé",
                  "attr"        => array("class" => "form-control"),
                  'disabled'    => true));

        switch($options["type"]) {
            case "string":
                $builder->add('value',
                    TextType::class,
                    array("label"       => "Valeur",
                          "attr"        => array("class" => "form-control"),
                          'required'    => ($options["required"]==0?false:true)));
                break;

            case "integer":
                $builder->add('value',
                    IntegerType::class,
                    array("label"       => "Valeur",
                          "attr"        => array("class" => "form-control"),
                          'required'    => ($options["required"]==0?false:true)));
                break;

            case "boolean":
                if($options["key"]=="LDAPactivate"&&$config["authentication"]=="LDAP") {
                    $session->getFlashBag()->add("notice", "Impossible de désactiver LDAP car votre mode d'authentification est LDAP");
                    $choices=array("oui" => "1");
                }
                else
                    $choices=array("oui" => "1","non" => "0");

                $builder->add("value", ChoiceType::class,
                    array("label"       =>"Valeur",
                          "attr"        => array("class" => "form-control"),
                          'required'    => ($options["required"]==0?false:true),
                          "choices"     => $choices));
                break;

            case "font":
                $choices=array(
                    "ABeeZee-Regular" => "ABeeZee-Regular",
                    "Acme-Regular" => "Acme-Regular",
                    "AlfaSlabOne-Regular" => "AlfaSlabOne-Regular",
                    "Anton-Regular" => "Anton-Regular",
                    "Baloo-Regular" => "Baloo-Regular",
                    "CarterOne-Regular" => "CarterOne-Regular",
                    "Chewy-Regular" => "Chewy-Regular",
                    "Courgette-Regular" => "Courgette-Regular",
                    "FredokaOne-Regular" => "FredokaOne-Regular",
                    "Gothic-Bold" => "Gothic-Bold",
                    "Gothic-Regular" => "Gothic-Regular",
                    "Grandstander" => "Grandstander",
                    "Helvetica" => "Helvetica",
                    "Justanotherhand-Regular" => "Justanotherhand-Regular",
                    "Lato-Regular" => "Lato-Regular",
                    "LexendDeca-Regular" => "LexendDeca-Regular",
                    "LuckiestGuy-Regular" => "LuckiestGuy-Regular",
                    "Marianne-Bold" => "Marianne-Bold",
                    "Marianne-Regular" => "Marianne-Regular",
                    "Overpass-Black" => "Overpass-Black",
                    "PassionOne" => "PassionOne",
                    "Peacesans" => "Peacesans",
                    "Redressed" => "Redressed",
                    "Righteous-Regular" => "Righteous-Regular",
                    "Roboto-Regular" => "Roboto-Regular",
                    "RubikMonoOne-Regular" => "RubikMonoOne-Regular",
                    "SigmarOne-Regular" => "SigmarOne-Regular",
                    "Signika-Regular" => "Signika-Regular",
                    "Teko-Bold" => "Teko-Bold",
                    "Viga-Regular" => "Viga-Regular",

                );

                $builder->add("value", ChoiceType::class,
                    array("label"       =>"Valeur",
                          'required'    => ($options["required"]==0?false:true),
                          "choices"     => $choices));
                break;
           
            case "editor":
                $builder->add('value', CKEditorType::class,
                    array("config_name" => 'full_config',
                          "required"    => ($options["required"]==0?false:true),
                          "config"      => array("height" => "250px")));

                break;

            case "logo":
                $builder->add('value',HiddenType::class);
                break;

            case "header":
                $builder->add('value',HiddenType::class);
                break;

            case "theme":
                $builder->add('value',
                TextType::class,
                array("label"       => "Valeur",
                      'required'    => ($options["required"]==0?false:true)));
                break;

            case "color":
                $builder->add('value',
                    TextType::class,
                    array("label"       => "Valeur",
                          "attr"        => array("class" => "pick-a-color"),
                          'required'    => ($options["required"]==0?false:true)));
                break;

            case "permgroup":
                $choices=array(
                    "NO_BODY" => "NO_BODY",
                    "ROLE_USER" => "ROLE_USER",
                    "ROLE_ANIM" => "ROLE_ANIM",
                    "ROLE_MODO" => "ROLE_MODO",
                );

                $builder->add("value", ChoiceType::class,
                    array("label"       =>"Valeur",
                          'required'    => ($options["required"]==0?false:true),
                          "choices"     => $choices));
                break;                
        }

        $builder->add('help',
            TextareaType::class,
            array("label"       =>"Aide",
                  "attr"        => array("style" => "margin-top:15px; height: 200px;"),
                  'required'    => false,
                  'disabled'    => true));
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\Config',
            'key' => "string",
            'type' => "string",
            'required' => "string",
        ));
    }
}
