<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Entity
 * @ORM\Table(name="alert")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="App\Repository\AlertRepository")
 */
class Alert
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=100)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="content", type="text", nullable=true)
     */
    private $content;

    /**
     * @var integer
     *
     * @ORM\Column(name="rowOrder", type="integer", nullable=true)
     */
    private $rowOrder;

    /**
     * @var datetime
     *
     * @ORM\Column(name="publishedat", type="date")
     */
    protected $publishedat;

    /**
     * @var datetime
     *
     * @ORM\Column(name="unpublishedat", type="date", nullable=true)
     */
    protected $unpublishedat;

    /**
     * @ORM\Column(name="fghideable", type="boolean")
     */
    private $fghideable;  

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

    /**
     * @ORM\ManyToOne(targetEntity="Alertcategory", inversedBy="alerts")
     * @ORM\JoinColumn(name="category", referencedColumnName="id", nullable=false, onDelete="CASCADE")
     */
    protected $alertcategory;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="alerts", cascade={"persist"})
     * @ORM\JoinTable(name="alertgroupe",
     *   joinColumns={@ORM\JoinColumn(name="alert", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Niveau01", inversedBy="alerts", cascade={"persist"})
     * @ORM\JoinTable(name="alertniveau01",
     *   joinColumns={@ORM\JoinColumn(name="alert", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="niveau01", referencedColumnName="id")}
     * )
     */
    protected $niveau01s;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="alertreaders", cascade={"persist"})
     * @ORM\JoinTable(name="alertuserread",
     *   joinColumns={@ORM\JoinColumn(name="alert", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $readers;

    /**
     * @ORM\ManyToMany(targetEntity="Item", inversedBy="alerts", cascade={"persist"})
     * @ORM\JoinTable(name="alertitem",
     *   joinColumns={@ORM\JoinColumn(name="alert", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="item", referencedColumnName="id")}
     * )
     */
    protected $items;

    // Is Online
    public function isOnline()
    {
        $today = new \DateTime();

        if (null === $this->unpublishedat &&
            $this->publishedat->getTimestamp() <= $today->getTimestamp()
        ) {
            return true;
        }
        if (
            $this->publishedat->getTimestamp() <= $today->getTimestamp() &&
            $this->unpublishedat->getTimestamp() >= $today->getTimestamp()
        ) {
            return true;
        }

        return false;
    }

    // IsPending
    public function isPending()
    {
        $today = new \DateTime();
        if ($this->publishedat->getTimestamp() > $today->getTimestamp()) {
            return true;
        }
        return false;
    }

    // IsArchived
    public function isArchived()
    {
        $today = new \DateTime();
        if (null === $this->unpublishedat) {
            return false;
        }
        if ($this->unpublishedat->getTimestamp() < $today->getTimestamp()) {
            return true;
        }
        return false;
    }


    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Alert
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set content
     *
     * @param string $content
     *
     * @return Alert
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * Get content
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set rowOrder
     *
     * @param integer $rowOrder
     *
     * @return Alert
     */
    public function setRowOrder($rowOrder)
    {
        $this->rowOrder = $rowOrder;

        return $this;
    }

    /**
     * Get rowOrder
     *
     * @return integer
     */
    public function getRowOrder()
    {
        return $this->rowOrder;
    }

    /**
     * Set publishedat
     *
     * @param \DateTime $publishedat
     *
     * @return Alert
     */
    public function setpublishedat($publishedat)
    {
        $this->publishedat = $publishedat;

        return $this;
    }

    /**
     * Get publishedat
     *
     * @return \DateTime
     */
    public function getpublishedat()
    {
        return $this->publishedat;
    }

    /**
     * Set unpublishedat
     *
     * @param \DateTime $unpublishedat
     *
     * @return Alert
     */
    public function setUnpublishedat($unpublishedat)
    {
        $this->unpublishedat = $unpublishedat;

        return $this;
    }

    /**
     * Get unpublishedat
     *
     * @return \DateTime
     */
    public function getUnpublishedat()
    {
        return $this->unpublishedat;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Alert
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Set alertcategory
     *
     * @param Alertcategory $alertcategory
     *
     * @return Alert
     */
    public function setAlertcategory(Alertcategory $alertcategory)
    {
        $this->alertcategory = $alertcategory;

        return $this;
    }

    /**
     * Get alertcategory
     *
     * @return Alertcategory
     */
    public function getAlertcategory()
    {
        return $this->alertcategory;
    }

    /**
     * Add group
     *
     * @param Group $group
     *
     * @return Alert
     */
    public function addGroup(Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param Group $group
     */
    public function removeGroup(Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add niveau01
     *
     * @param Niveau01 $niveau01
     *
     * @return Alert
     */
    public function addNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01s[] = $niveau01;

        return $this;
    }

    /**
     * Remove niveau01
     *
     * @param Niveau01 $niveau01
     */
    public function removeNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01s->removeElement($niveau01);
    }

    /**
     * Get niveau01s
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNiveau01s()
    {
        return $this->niveau01s;
    }

    /**
     * Set fghideable
     *
     * @param boolean $fghideable
     *
     * @return Alert
     */
    public function setFghideable($fghideable)
    {
        $this->fghideable = $fghideable;

        return $this;
    }

    /**
     * Get fghideable
     *
     * @return boolean
     */
    public function getFghideable()
    {
        return $this->fghideable;
    }

    /**
     * Add reader
     *
     * @param User $reader
     *
     * @return Alert
     */
    public function addReader(User $reader)
    {
        $this->readers[] = $reader;

        return $this;
    }

    /**
     * Remove reader
     *
     * @param User $reader
     */
    public function removeReader(User $reader)
    {
        $this->readers->removeElement($reader);
    }

    /**
     * Get readers
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getReaders()
    {
        return $this->readers;
    }

    /**
     * Add item
     *
     * @param Item $item
     *
     * @return Alert
     */
    public function addItem(Item $item)
    {
        $this->items[] = $item;

        return $this;
    }

    /**
     * Remove item
     *
     * @param Item $item
     */
    public function removeItem(Item $item)
    {
        $this->items->removeElement($item);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }
}
