<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Doctrine\Persistence\ManagerRegistry;
use App\Service\MailService;

use App\Form\MailType;

class MailController extends AbstractController
{
    private $mail;
    
    public function __construct(mailService $mail)
    {
        $this->mail = $mail;
    }

    public function invitationgroup($id,Request $request, ManagerRegistry $em)
    {
        // Recherche du groupe
        $group = $em->getRepository("App\Entity\Group")->find($id);
        if (!$group) {
            throw $this->createNotFoundException('Unable to find group');
        }

        // On récupère la liste des email invités
        $invitations=$group->getInvitations();
        if(!is_array($invitations)) $invitations=[];

        // Création du formulaire
        $form = $this->createForm(MailType::class);

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sujet
        $subject = $request->getSession()->get('appname')." : Invitation au groupe de travail ".$group->getLabel();

        // Sujet
        $url     = $this->generateUrl('app_core_registration',[], UrlGeneratorInterface::ABSOLUTE_URL)."?group=".$group->getId();
        $message = "Bonjour,<br><br>En tant que responsable du groupe <b>'".$group->getLabel()."'</b>, je vous ai invité à rejoindre cette communauté de travail<br><br>";
        $message.= "Merci de bien vouloir tout d’abord vous inscrire sur <b>".$request->getSession()->get('appname')."</b> en suivant le lien suivant<br>";
        $message.= "<a href='$url'>$url</a><br><br>";
        $message.= "Une fois le processus d'inscription complété, vous serez automatiquement rattaché à notre groupe de travail<br><br>";
        $message.= "Cordialement<br>";
        $message.= $this->getUser()->getFirstname()." ".$this->getUser()->getLastname();

        // To close ?
        $closed = false;

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $closed = true;    
            

            $destinataires=$form->get("destinataire")->getData();
            $to=explode(";",$destinataires);
            
            // On s'assure que les destinataires ne sont pas déjà inscrit dans le portail
            $usersnotin=[];
            $usersin=[];
            foreach($to as $key => $mail) {
                // Si le mail existe on l'enlève de la liste des utilisateurs à inviter
                $user=$em->getRepository("App\Entity\User")->findOneBy(["email"=>$mail]);
                if($user) {
                    unset($to[$key]);
                    $usergroup=$em->getRepository("App\Entity\UserGroup")->findOneBy(["user"=>$user,"group"=>$group]);
                    if($usergroup) array_push($usersin,$user);
                    else array_push($usersnotin,$user);
                }
                else {
                    // On enregistre l'invitation si elle n'existe pas déjà
                    if(!in_array($mail,$invitations)) {
                        array_push($invitations,$mail);
                    }                    
                }
            }

            $subject=$form->get("subject")->getData();
            $body=$form->get("message")->getData();
            $from =  $this->getParameter('noreply');
            $fromName = $this->getUser()->getFirstname()." ".$this->getUser()->getLastname();
            $this->mail->sendEmail($subject, $body, $to, $from, $fromName); 

            // Sauvegarde des invitation
            $group->setInvitations($invitations);
            $em->getManager()->flush();             
        }
        else {
            $email=$request->get("email");
            if($email) {
                $form->get('destinataire')->setData($email);
            }
        }

        if($closed && (!empty($usersin)||!empty($usersnotin))) {
            return $this->render('Mail\users.html.twig',[
                'useheader'     => false,
                'usemenu'       => false,
                'usesidebar'    => false,
                'usersin'       => $usersin,
                'usersnotin'    => $usersnotin,
                'group'         => $group
            ]);           
        }
        else {
            return $this->render('Mail\mail.html.twig',[
                'useheader'     => false,
                'usemenu'       => false,
                'usesidebar'    => false,
                'closed'        => $closed,
                'subject'       => $subject,
                'message'       => $message,
                'form'          => $form->createView()
            ]);
        }
    }

}
