<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Item;
use App\Form\ItemType;

class ItemController extends AbstractController
{
    private $nameentity = 'Item';
    private $labelentity = 'App\Entity\Item';
    private $labelroute  = 'app_portal_config_item';
    private $labeldata   = 'item';
    private $labeldatas  = 'items';

    public function list(ManagerRegistry $em)
    {
        $itemcategorys = $em->getRepository('App\Entity\Itemcategory')->findBy([], ['rowOrder' => 'asc']);
        $groups = $em->getRepository('App\Entity\Group')->findBy([], ['label' => 'asc']);

        return $this->render($this->nameentity.'\list.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            'itemcategorys'     => $itemcategorys,
            'groups'            => $groups
        ]);
    }

    public function ajaxseleclist(Request $request,ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from("App\Entity\Item",'table')
           ->where('table.title LIKE :value')
           ->setParameter("value", "%".$q."%")
           ->orderBy('table.title');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getTitle()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    public function submit(Request $request,ManagerRegistry $em)
    {
        // Initialisation de l'enregistrement
        $data = new Item();
        if($this->GetParameter("activate_widsonde")) {
            $data->setClicksonde(true);
            $data->setClicksondeservice("PAGE_ENT");
        }

        // Création du formulaire
        $form = $this->createForm(ItemType::class,$data,array(
            "mode"                  => "submit",
            "labelniveau01"         => $this->GetParameter("labelsniveau01"),
            "ssosynchroitem"        => $this->GetParameter("ssosynchroitem"),
            "user_attr_cas_item"    => $this->GetParameter("user_attr_cas_item"),
            "activate_widsonde"     => $this->GetParameter("activate_widsonde"),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);

            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'icons'             => $em->getRepository("App\Entity\Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,Request $request,ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(ItemType::class,$data,array(
            "mode"                  => "update",
            "idicon"                => ($data->getIcon()?$data->getIcon()->getId():null),
            "labelniveau01"         => $this->GetParameter("labelsniveau01"),
            "ssosynchroitem"        => $this->GetParameter("ssosynchroitem"),
            "user_attr_cas_item"    => $this->GetParameter("user_attr_cas_item"),
            "activate_widsonde"     => ($this->GetParameter("activate_widsonde")&&$data->getId()>0),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);
            
            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            $this->labeldata    => $data,
            'mode'              => 'update',
            'icons'             => $em->getRepository("App\Entity\Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }

    public function delete($id,Request $request,ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em->getManager()->remove($data);
        $em->getManager()->flush();
        
        return $this->redirectToRoute($this->labelroute);
    }

    public function order(Request $request,ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $id=$request->request->get('id');
        $categoryid=$request->request->get('categoryid');
        $order=$request->request->get('order');
        
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find entity.');
        }

        $entity->setRoworder($order);
        $entity->setItemcategory($em->getRepository("App\Entity\Itemcategory")->find($categoryid));
        $em->getManager()->flush();

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }


    public function forceorder(Request $request,ManagerRegistry $em)
    {
        $categorys=$em->getRepository("App\Entity\Itemcategory")->findAll();
        
        foreach($categorys as $category) {
            $i=0;
            $items=$em->getRepository("App\Entity\Item")->findBy(["itemcategory"=>$category],["title"=>"ASC"]);
            foreach($items as $item) {
                $i++;
                $item->setRowOrder($i);
                $em->getManager()->flush();
            }
        }

        // Retour à la liste
        return $this->redirectToRoute($this->labelroute);
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            // si clicksonde alors clicksondeservice obligatoire
            if ($data->getClicksonde() && !$data->getClicksondeservice()) {
                $form->addError(new FormError('Type de service sur le click sonde est obligatoire'));
            }
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
