<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;


use App\Entity\Page;

class CoreController extends AbstractController
{
    public function home(Request $request, ManagerRegistry $em) {
        $user=$this->getUser();

        $portal_activate=$this->getParameter("portal_activate");
        
        if(!$portal_activate) {
            $item_activate=$this->getParameter("item_activate");
            
            $bookmarks=null;
            $items=null;
            $itemcategorys=null;
            
            if($item_activate) {
                $em->getRepository("App\Entity\Item")->getUserItems($user,$bookmarks,$items,$itemcategorys,null,$request->getSession()->get('ssoitems'));
                return $this->render('Page\noportal.html.twig',[
                    'useheader'         => true,
                    'usemenu'           => false,
                    'usesidebar'        => false,
                    'item_activate'     => $item_activate,
                    'bookmarks'         => $bookmarks,
                    'items'             => $items,
                    'itemcategorys'     => $itemcategorys
                ]);
            }
            else {
                return $this->render('Core\home.html.twig',[
                    'useheader'     => true,
                    'usemenu'       => false,
                    'usesidebar'    => false,              
                ]);
            }
        }
        else {
            
            // Récupération de la page encours
            $id = $request->query->get('id');

            // Récupération redirection potentielle
            $gotoroute = $request->query->get('gotoroute');
            $gotoid = $request->query->get('gotoid');
            
            // L'utilisateur en cours
           

            // Chargement des chartes à signer
            if($user) {
                
                $notices=$em->getRepository("App\Entity\Notice")->getNoticeToRead($user);
                if(! $notices->isEmpty()) {
                    $notices=$em->getRepository("App\Entity\Notice")->getNoticeUser($user,false);
                    return $this->render('Notice\mustread.html.twig',[
                        'useheader'     => true,
                        'usemenu'       => false,
                        'usesidebar'    => false,    
                        'maxwidth'      => true,
                        'mustread'      => true,
                        'notices'       => $notices,
                        'id'            => $id,
                    ]);
                }

                // On s'assure que l'ensemble des champs user obligatoire sont bien renseignés sinon bascule sur le profil
                $config=$em->getRepository('App\Entity\Config')->find("datauser");
                $fields=$config->getValue(); 
                $fields=json_decode($fields,true);                               
                $toprofil=false;
                if($fields!="") {
                    foreach($fields as $key => $field) {
                        // Si champs obligatoire
                        if($field["perm"]==2) {
                            switch($key) {
                                case "firstname": if($user->getFirstname()=="") $toprofil=true; break;
                                case "visible": if($user->getVisible()=="") $toprofil=true; break;
                                //case "authlevel": if($user->getAuthlevel()=="") $toprofil=true; break;
                                //case "belongingpopulation": if($user->getBelongingpopulation()=="") $toprofil=true; break;
                                case "job": if($user->getJob()=="") $toprofil=true; break;
                                case "position": if($user->getPosition()=="") $toprofil=true; break;
                                case "niveau02": if($user->geNiveau02()=="") $toprofil=true; break;
                                case "usualname": if($user->getUsualname()=="") $toprofil=true; break;
                                case "gender": if($user->getGender()=="") $toprofil=true; break;
                                case "givensname": if($user->getGivensname()=="") $toprofil=true; break;
                                case "telephonenumber": if($user->getTelephonenumber()=="") $toprofil=true; break;
                                case "postaladress": if($user->getPostaladress()=="") $toprofil=true; break;
                                case "birthdate": if($user->getBirthdate()=="") $toprofil=true; break;
                                case "birthcountry": if($user->getBirthcountry()=="") $toprofil=true; break;
                                case "birthplace": if($user->getBirthplace()=="") $toprofil=true; break;
                            }
                        }
                    }
                }

                // Si niveau01 commence par autre = alors niveau01other obligatoire
                $message="";
                $niveau01=strtolower($user->getNiveau01()->getLabel());
                if(stripos($niveau01,"autre")===0) {
                    if(!$user->getNiveau01other()) {
                        $toprofil=true;
                        $message="<br>Merci d'indiquer votre ".$this->getParameter("labelniveau01");
                    }
                }

                if($toprofil) {
                    return $this->redirect($this->generateUrl('app_core_user',array("info"=>"Merci de compléter votre profil".$message)));                    
                }
            }



          
            
            // Calcul des pages de l'utilisateur
            $em->getRepository("App\Entity\Page")->getPagesUser($user,$id,$entity,$pagesuser,$pagesadmin,$groupsshared);

            // si aucune page = page par défaut
            if(!$entity) {
                return $this->render('Page\default.html.twig',[
                    'useheader'     => true,
                    'usemenu'       => false,
                    'usesidebar'    => false
                ]);
            }            

            return $this->render('Page\pages.html.twig', [
                'useheader'         => true,
                'usemenu'           => true,
                'usesidebar'        => false,                    
                'entity'            => $entity,
                'access'            => "user",
                'pagesadmin'        => $pagesadmin,
                'pagesuser'         => $pagesuser,
                'groupsshared'      => $groupsshared,
                'canadd'            => $request->getSession()->get('cancreatepage'),
                'widgetsuser'       => $em->getRepository("App\Entity\Widget")->getWidgetAccess("user"),
                'widgetsgroup'      => $em->getRepository("App\Entity\Widget")->getWidgetAccess("group"),
                'gotoroute'         => $gotoroute,
                'gotoid'            => $gotoid,
            ]);
        }
    }

    public function docrest()
    {
        return $this->render('Tool\frame.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            'url'               => $this->generateUrl('app_swagger_ui')
        ]); 
    }    
}
