<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Cadoles\PortalBundle\Entity\Slide;
use Cadoles\PortalBundle\Form\SlideType;

class SlideController extends Controller
{
    private $labelroute  = 'cadoles_portal_config_slide';
    private $labelentity = 'CadolesPortalBundle:Slide';
    private $labeldata   = 'slide';
    private $labeldatas  = 'slides';

    public function listAction(Request $request,$idpage,$idwidget,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // On s'assure que le widget existe
        $em = $this->getDoctrine()->getManager();
        $pagewidget = $em->getRepository("CadolesPortalBundle:Pagewidget")->find($idwidget);
        if (!$pagewidget) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que l'on générer un slide
        if($access=="user") {
            if($usage=="user") {
                $user=$pagewidget->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup||$usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }
        
        // Recherche des slides du widget
        $datas = $em->getRepository($this->labelentity)->findBy(["pagewidget"=>$idwidget],["roworder"=>"ASC","title"=>"ASC"]);

      	return $this->render($this->labelentity.':list.html.twig',[
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"), 
            'maxwidth'          => ($access=="user"),        
            'access'            => $access,
            'idpage'            => $idpage,
            'idwidget'          => $idwidget,
            'usage'             => $usage,
            'group'             => $group,
            $this->labeldatas   => $datas
        ]);
    }

    public function submitAction(Request $request,$idpage,$idwidget,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = new Slide();
        $data->setRoworder(0);

        // On s'assure que le widget existe
        $pagewidget = $em->getRepository("CadolesPortalBundle:Pagewidget")->find($idwidget);
        if (!$pagewidget) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que l'on générer un slide
        if($access=="user") {
            if($usage=="user") {
                $user=$pagewidget->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup||$usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }

        // Création du formulaire
        $form = $this->createForm(SlideType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $data->setPagewidget($pagewidget);           

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la page
            return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_slide_list',["idpage"=>$idpage,"idwidget"=>$idwidget,"usage"=>$usage,"group"=>$group]));
        }
        
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),  
            'maxwidth'          => ($access=="user"),                   
            'entity'            => $data,
            'mode'              => "submit",
            'access'            => $access,   
            'idpage'            => $idpage,    
            'idwidget'          => $idwidget,
            'usage'             => $usage,
            'group'             => $group,
            'form'              => $form->createView(),
        ]);
    }  

    public function updateAction(Request $request,$idpage,$id,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Récupération de l'enregistrement courant 
        $em = $this->getDoctrine()->getManager();
        $data=$this->getData($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que cet enregistrement est modifiable
        if($access=="user") {
            if($usage=="user") {
                $user=$data->getPagewidget()->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup||$usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }

        // Création du formulaire
        $form = $this->createForm(SlideType::class,$data,array(
            "mode"      => "update"
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la page
            return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_slide_list',["idpage"=>$idpage,"idwidget"=>$data->getPagewidget()->getId(),"usage"=>$usage,"group"=>$group]));
        }
        
       
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),    
            'maxwidth'          => ($access=="user"),                 
            'entity'            => $data,
            'mode'              => "update",
            'access'            => $access,   
            'idpage'            => $idpage,    
            'idwidget'          => $data->getPagewidget()->getId(),     
            'usage'             => $usage,
            'group'             => $group,
            'form'              => $form->createView(),
        ]);
    }

    public function deleteAction(Request $request,$idpage,$id,$access="config")
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Récupération de l'enregistrement courant 
        $em = $this->getDoctrine()->getManager();
        $data=$this->getData($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que cet enregistrement est supprimable
        if($access=="user") {
            if($usage=="user") {
                $user=$data->getPagewidget()->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$this->getDoctrine()->getRepository("CadolesCoreBundle:Group")->find($group);
                $usergroup=$this->getDoctrine()->getRepository("CadolesCoreBundle:UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup||$usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }
        
        // Widget encours
        $idwidget = $data->getPagewidget()->getId();

        // Supprimer la donnée
        $em = $this->getDoctrine()->getManager();
        $em->remove($data);
        $em->flush();
        
        // Retour à la page
        return $this->redirect($this->generateUrl('cadoles_portal_'.$access.'_slide_list',["idpage"=>$idpage,"idwidget"=>$idwidget,"usage"=>$usage,"group"=>$group]));
    }

    public function uploadAction($access="config")
    {
        return $this->render('CadolesPortalBundle:Slide:upload.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'access'        => $access
        ]);
    }

    protected function getDatas()
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
