<?php

namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\HttpFoundation\Session\Session;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

class DatauserType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $session = new Session();
        $session->getFlashBag()->clear();

        $config = $session->get('configs');

        $builder->add('submit',
            SubmitType::class,
            array("label"       => "Valider",
                  "attr"        => array("class" => "btn btn-success")));


        foreach($options["fields"] as $key => $field) {
            if($options["mode"]=="datauser") {
                if($key=="birthplace") 
                    $choices=array(
                        "Bloqué"        => 3,
                        "Facultatif"   => 1,
                        "Caché"         => 0,
                    );
                else
                    $choices=array(
                        "Bloqué"        => 3,
                        "Obligatoire"   => 2,
                        "Facultatif"    => 1,
                        "Caché"         => 0,
                    );
            }
            else {
                $choices=array(
                    "Visible"       => 1,
                    "Caché"         => 0,
                );                    
            }

            $builder->add($key, ChoiceType::class,
                array("label"       => $field["label"],
                      "label_attr"  => array("style" => 'margin-top:15px;'),
                      "attr"        => array("class" => "form-control"),
                      "data"        => $field["perm"],
                      "mapped"      => false,
                      'required'    => ($options["required"]==0?false:true),
                      "choices"     => $choices));
        }
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'    => 'Cadoles\CoreBundle\Entity\Config',
            'mode'          => 'string',
            'fields'        => "array",
        ));
    }
}
