#!/bin/bash


function upnineskeletor {
    if [[ $NINESKELETOR_ACTIVATE == 1 && $NINESKELETOR_LOCAL == 1 ]]
    then
        Title ${NINESKELETOR_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINESKELETOR_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINESKELETOR_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINESKELETOR_SERVICE_NAME}
        chmod -R a+wr ./services/50-nineskeletor/volume/data
        Echo
    fi    
}

function destroynineskeletor {
    if [[ $NINESKELETOR_LOCAL == 1 ]]
    then
        Title "DESTROY $NINESKELETOR_SERVICE_NAME"

        stop $NINESKELETOR_SERVICE_NAME 1
        docker-compose rm -s -v -f "$NINESKELETOR_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $NINESKELETOR_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = "$NINESKELETOR_SERVICE_NAME
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINESKELETOR_SERVICE_NAME
            rm -rf services/50-nineskeletor/volume/apache
        fi

        echo ""
    fi   
}