#!/bin/bash

function upredis {
    if [[ $REDIS_ACTIVATE == 1 && $REDIS_LOCAL == 1 ]]
    then
        Title "REDIS"
        EchoVert "CONTAINER"
        upservice $REDIS_SERVICE_NAME
        Echo
    fi
}

function destroyredis(){
    if [[ $REDIS_LOCAL == 1 ]]
    then
        Title "DESTROY $REDIS_SERVICE_NAME"

        stop $REDIS_SERVICE_NAME 1
        docker-compose rm -s -v -f "$REDIS_SERVICE_NAME"  

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $REDIS_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $REDIS_SERVICE_NAME"
            rm -rf services/30-redis/volume/data
        fi

        echo ""
   fi  
}