#!/bin/bash

function upminio {
    if [[ $MINIO_ACTIVATE == 1 && $MINIO_LOCAL == 1 ]]
    then
        Title "MINIO"
        EchoVert "CONTAINER"
        upservice $MINIO_SERVICE_NAME
        Echo
    fi
}

function destroyminio(){
    if [[ $MINIO_LOCAL == 1 ]]
    then
        Title "DESTROY $MINIO_SERVICE_NAME"

        stop $MINIO_SERVICE_NAME 1
        docker-compose rm -s -v -f "$MINIO_SERVICE_NAME"  

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer les fichiers stockés dans $MINIO_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Suppression des fichiers stockés sur $MINIO_SERVICE_NAME"
            sudo rm -rf ./services/30-minio/volume/data
        fi

        echo ""
   fi  
}