#!/bin/bash



function upmariadb {
    if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
    then
        Title "MARIADB"
        EchoVert "CONTAINER"
        upservice $MARIADB_SERVICE_NAME wait
        Echo
    fi
}

function destroymariadb(){
    if [[ $MARIADB_LOCAL == 1 ]]
    then
        Title "DESTROY $MARIADB_SERVICE_NAME"

        stop $MARIADB_SERVICE_NAME 1
        docker-compose rm -s -v -f "$MARIADB_SERVICE_NAME"
    
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer l'ensemble des bases ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Suppression de l'ensemble des bases"
            sudo rm -rf services/15-mariadb/volume/mysql
        fi

        echo ""
    fi  
}