    dir=$1

    if [ -f "$dir/dicos/.env.dicos" ]; then

        dicos="$dir/dicos/.env.dicos"

        # Exporter la variable
        set -o allexport; source <(grep -v '^#' $dir/env/.env.merge | sed 's/^/export /'); set +o allexport

        # Initialisation des tableaux
        templates=()
        destinations=()

        # Lecture du fichier de configuration
        while IFS='=' read -r key value; do
        case "$key" in
            templates)
            IFS=',' read -ra templates <<< "$value"
            ;;
            destinations)
            IFS=',' read -ra destinations <<< "$value"
            ;;
            *)
        esac
        done < "$dicos"

        # Boucle sur les templates et leurs destinations
        for i in "${!templates[@]}"; do
            template="${templates[$i]}"
            destination="${destinations[$i]}"

            # Extraire le répertoire de destination
            folder=$(dirname "$destination")

            # Créer le répertoire de destination
            mkdir -p "$folder"

            # Copier le template vers l'emplacement de destination
            cp "$template" "$destination"
            envsubst < "$destination" > temp.conf && mv temp.conf "$destination"
        done
    fi