#!/bin/bash


function upninecompta {
    if [[ $NINECOMPTA_ACTIVATE == 1 && $NINECOMPTA_LOCAL == 1 ]]
    then
        Title ${NINECOMPTA_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINECOMPTA_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINECOMPTA_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINECOMPTA_SERVICE_NAME}
        chmod -R a+wr ./services/50-ninecompta/volume/data
        Echo
    fi    
}

function destroyninecompta {
    if [[ $NINECOMPTA_LOCAL == 1 ]]
    then
        Title "DESTROY $NINECOMPTA_SERVICE_NAME"

        stop $NINECOMPTA_SERVICE_NAME 1
        docker-compose rm -s -v -f "$NINECOMPTA_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $NINECOMPTA_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $NINECOMPTA_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINECOMPTA_SERVICE_NAME
            rm -rf services/50-ninecompta/volume/data
        fi

        echo ""
    fi   
}