#!/bin/bash

function updokuwiki {
    if [[ $DOKUWIKI_ACTIVATE == 1 && $DOKUWIKI_LOCAL == 1 ]]
    then
        Title ${DOKUWIKI_SERVICE_NAME^^}
               
        EchoVert "CONTAINER"
        upservice ${DOKUWIKI_SERVICE_NAME}
        Echo
    fi    
}

function destroydokuwiki {
    if [[ $DOKUWIKI_LOCAL == 1 ]]
    then    
        Title "DESTROY ${DOKUWIKI_SERVICE_NAME}"

        stop ${DOKUWIKI_SERVICE_NAME} 1
        docker-compose rm -s -v -f "${DOKUWIKI_SERVICE_NAME}"    

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous purger $DOKUWIKI_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Purge = $DOKUWIKI_SERVICE_NAME"
            rm -rf services/50-dokuwiki/volume/data
        fi

        echo ""
    fi
}