#!/bin/bash

function upopenldap  {
    if [[ $OPENLDAP_ACTIVATE == 1 && $OPENLDAP_LOCAL == 1 ]]
    then
        Title ${OPENLDAP_SERVICE_NAME^^}
        EchoVert "CONTAINER"

        mkdir -p ./services/30-openldap/volume/data
        chmod a+wr ./services/30-openldap/volume/data
        
        upservice $OPENLDAP_SERVICE_NAME wait
        docker-compose exec $OPENLDAP_SERVICE_NAME /nine/init.sh
        Echo
    fi
}

function destroyopenldap {
    if [[ $OPENLDAP_LOCAL == 1 ]]
    then
        Title "DESTROY $OPENLDAP_SERVICE_NAME"

        stop $OPENLDAP_SERVICE_NAME 1
        docker-compose rm -s -v -f "$OPENLDAP_SERVICE_NAME"

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer l'annuaire associé à $OPENLDAP_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Suppression de l'annuaire"
            rm -rf ./services/30-openldap/volume/data
        fi

        echo ""
    fi   
}