#!/bin/bash

envfile=/etc/apache2/conf.d/env.conf
haveenv=/etc/apache2/haveenv.txt

# Vérification de la permission d'écriture
if touch "$envfile" &>/dev/null; then
    echo "GENERATION DES VARIABLES D'ENVIRONNEMENT"
    rm -rf $envfile
    rm -rf $haveenv

    printf "\n# Expose environment variables to scripts.\nPassEnv" >> $envfile
    compgen -e | while read name ; do
        if [[ "$name" != "TERM" && "$name" != "HOME" && "$name" != "HOSTNAME" && "$name" != "PATH" && "$name" != "PWD" && "$name" != "SHLVL" ]]
        then
            touch $haveenv
            printf " $name" >> $envfile
        fi
    done
    printf "\n" >> $envfile

    if [[ ! -f $haveenv ]]
    then
        rm -rf $envfile
    fi
    rm -rf $haveenv
fi

echo "START HTTPD"
httpd -DFOREGROUND

