/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.representations;

import java.io.StringWriter;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.keycloak.dom.saml.v1.assertion.SAML11AssertionType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionsType;
import org.keycloak.dom.saml.v1.assertion.SAML11NameIdentifierType;
import org.keycloak.dom.saml.v1.assertion.SAML11StatementAbstractType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectType;
import org.keycloak.dom.saml.v1.protocol.SAML11ResponseType;
import org.keycloak.dom.saml.v1.protocol.SAML11StatusCodeType;
import org.keycloak.dom.saml.v1.protocol.SAML11StatusType;
import org.keycloak.protocol.cas.utils.CASValidationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.saml.v1.writers.SAML11ResponseWriter;
import org.keycloak.services.validation.Validation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlResponseHelper {
    private static final DatatypeFactory factory;

    public static SAML11ResponseType errorResponse(CASValidationException ex) {
        ZonedDateTime nowZoned = ZonedDateTime.now(ZoneOffset.UTC);
        XMLGregorianCalendar now = factory.newXMLGregorianCalendar(GregorianCalendar.from(nowZoned));
        return SamlResponseHelper.applyTo(new SAML11ResponseType("_" + UUID.randomUUID().toString(), now), obj -> obj.setStatus(SamlResponseHelper.applyTo(new SAML11StatusType(), status -> {
            status.setStatusCode(new SAML11StatusCodeType(QName.valueOf("samlp:RequestDenied")));
            status.setStatusMessage(ex.getErrorDescription());
        })));
    }

    public static SAML11ResponseType successResponse(String issuer, String username, Map<String, Object> attributes) {
        ZonedDateTime nowZoned = ZonedDateTime.now(ZoneOffset.UTC);
        XMLGregorianCalendar now = factory.newXMLGregorianCalendar(GregorianCalendar.from(nowZoned));
        return SamlResponseHelper.applyTo(new SAML11ResponseType("_" + UUID.randomUUID().toString(), now), obj -> {
            obj.setStatus(SamlResponseHelper.applyTo(new SAML11StatusType(), status -> status.setStatusCode(SAML11StatusCodeType.SUCCESS)));
            obj.add(SamlResponseHelper.applyTo(new SAML11AssertionType("_" + UUID.randomUUID().toString(), now), assertion -> {
                assertion.setIssuer(issuer);
                assertion.setConditions(SamlResponseHelper.applyTo(new SAML11ConditionsType(), conditions -> {
                    conditions.setNotBefore(now);
                    conditions.setNotOnOrAfter(factory.newXMLGregorianCalendar(GregorianCalendar.from(nowZoned.plusMinutes(5L))));
                }));
                assertion.add((SAML11StatementAbstractType)SamlResponseHelper.applyTo(new SAML11AuthenticationStatementType(URI.create("urn:oasis:names:tc:SAML:1.0:am:password"), now), stmt -> stmt.setSubject(SamlResponseHelper.toSubject(username))));
                assertion.addAllStatements(SamlResponseHelper.toAttributes(username, attributes));
            }));
        });
    }

    private static List<SAML11StatementAbstractType> toAttributes(String username, Map<String, Object> attributes) {
        List<SAML11AttributeType> converted = SamlResponseHelper.attributeElements(attributes);
        if (converted.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList((SAML11StatementAbstractType)SamlResponseHelper.applyTo(new SAML11AttributeStatementType(), attrs -> {
            attrs.setSubject(SamlResponseHelper.toSubject(username));
            attrs.addAllAttributes(converted);
        }));
    }

    private static List<SAML11AttributeType> attributeElements(Map<String, Object> attributes) {
        return attributes.entrySet().stream().flatMap(e -> SamlResponseHelper.toAttribute((String)e.getKey(), e.getValue())).filter(a -> !a.get().isEmpty()).collect(Collectors.toList());
    }

    private static Stream<SAML11AttributeType> toAttribute(String name, Object value) {
        if (name == null || value == null) {
            return Stream.empty();
        }
        if (value instanceof Collection) {
            return Stream.of(SamlResponseHelper.samlAttribute(name, SamlResponseHelper.listString((Collection)value)));
        }
        return Stream.of(SamlResponseHelper.samlAttribute(name, Collections.singletonList(value.toString())));
    }

    private static SAML11AttributeType samlAttribute(String name, List<Object> listString) {
        return SamlResponseHelper.applyTo(new SAML11AttributeType(name, URI.create("http://www.ja-sig.org/products/cas/")), attr -> attr.addAll(listString));
    }

    private static List<Object> listString(Collection<?> value) {
        return value.stream().map(Object::toString).collect(Collectors.toList());
    }

    private static SAML11SubjectType toSubject(String username) {
        return SamlResponseHelper.applyTo(new SAML11SubjectType(), subject -> subject.setChoice(new SAML11SubjectType.SAML11SubjectTypeChoice(SamlResponseHelper.applyTo(new SAML11NameIdentifierType(username), ctype -> ctype.setFormat(SamlResponseHelper.nameIdFormat(username))))));
    }

    private static URI nameIdFormat(String username) {
        return URI.create(Validation.isEmailValid((String)username) ? "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress" : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    private static <A> A applyTo(A input, Consumer<A> setter) {
        setter.accept(input);
        return input;
    }

    public static String soap(SAML11ResponseType response) {
        try {
            Document result = SamlResponseHelper.toDOM(response);
            Document doc = SamlResponseHelper.wrapSoap(result.getDocumentElement());
            return SamlResponseHelper.toString(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDOM(SAML11ResponseType response) throws ParserConfigurationException, XMLStreamException, ProcessingException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        Document doc = dbf.newDocumentBuilder().newDocument();
        DOMResult result = new DOMResult(doc);
        XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(result);
        SAML11ResponseWriter writer = new SAML11ResponseWriter(xmlWriter);
        writer.write(response);
        return doc;
    }

    private static Document wrapSoap(Node node) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        Element envelope = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Envelope");
        envelope.appendChild(doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Header"));
        Element body = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Body");
        Node imported = doc.importNode(node, true);
        body.appendChild(imported);
        doc.appendChild(body);
        envelope.appendChild(body);
        doc.appendChild(envelope);
        return doc;
    }

    public static String toString(Document document) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        t.transform(source, result);
        return writer.toString();
    }

    static {
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

