/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.Map;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;

public abstract class AbstractCASProtocolMapper
implements ProtocolMapper,
CASAttributeMapper {
    public static final String TOKEN_MAPPER_CATEGORY = "Token mapper";

    public String getProtocol() {
        return "cas";
    }

    public void close() {
    }

    public final ProtocolMapper create(KeycloakSession session) {
        throw new RuntimeException("UNSUPPORTED METHOD");
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayCategory() {
        return TOKEN_MAPPER_CATEGORY;
    }

    protected void setMappedAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, Object attributeValue) {
        this.setPlainAttribute(attributes, mappingModel, OIDCAttributeMapperHelper.mapAttributeValue((ProtocolMapperModel)mappingModel, (Object)attributeValue));
    }

    protected void setPlainAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, Object attributeValue) {
        String protocolClaim = (String)mappingModel.getConfig().get("claim.name");
        if (protocolClaim == null || attributeValue == null) {
            return;
        }
        attributes.put(protocolClaim, attributeValue);
    }
}

