/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.endpoints;

import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapper;
import org.keycloak.protocol.cas.representations.CASErrorCode;
import org.keycloak.protocol.cas.utils.CASValidationException;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.DefaultClientSessionContext;

public abstract class AbstractValidateEndpoint {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected KeycloakSession session;
    protected RealmModel realm;
    protected EventBuilder event;
    protected ClientModel client;
    protected AuthenticatedClientSessionModel clientSession;

    public AbstractValidateEndpoint(KeycloakSession session, RealmModel realm, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.event = event;
    }

    protected void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.session.getContext().getConnection())) {
            throw new CASValidationException(CASErrorCode.INVALID_REQUEST, "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    protected void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CASValidationException(CASErrorCode.INTERNAL_ERROR, "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    protected void checkClient(String service) {
        if (service == null) {
            this.event.error("invalid_request");
            throw new CASValidationException(CASErrorCode.INVALID_REQUEST, "Missing parameter: service", Response.Status.BAD_REQUEST);
        }
        this.event.detail("redirect_uri", service);
        this.client = this.realm.getClientsStream().filter(c -> "cas".equals(c.getProtocol())).filter(c -> RedirectUtils.verifyRedirectUri((KeycloakSession)this.session, (String)service, (ClientModel)c) != null).findFirst().orElse(null);
        if (this.client == null) {
            this.event.error("client_not_found");
            throw new CASValidationException(CASErrorCode.INVALID_SERVICE, "Client not found", Response.Status.BAD_REQUEST);
        }
        if (!this.client.isEnabled()) {
            this.event.error("client_disabled");
            throw new CASValidationException(CASErrorCode.INVALID_SERVICE, "Client disabled", Response.Status.BAD_REQUEST);
        }
        this.event.client(this.client.getClientId());
        this.session.getContext().setClient(this.client);
    }

    protected void checkTicket(String ticket, boolean requireReauth) {
        if (ticket == null) {
            this.event.error("invalid_code");
            throw new CASValidationException(CASErrorCode.INVALID_REQUEST, "Missing parameter: ticket", Response.Status.BAD_REQUEST);
        }
        if (!ticket.startsWith("ST-")) {
            this.event.error("invalid_code");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET_SPEC, "Malformed service ticket", Response.Status.BAD_REQUEST);
        }
        String code = ticket.substring("ST-".length());
        OAuth2CodeParser.ParseResult parseResult = OAuth2CodeParser.parseCode((KeycloakSession)this.session, (String)code, (RealmModel)this.realm, (EventBuilder)this.event);
        if (parseResult.isIllegalCode()) {
            this.event.error("invalid_code");
            AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
            if (clientSession != null) {
                clientSession.detachFromUserSession();
            }
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "Code not valid", Response.Status.BAD_REQUEST);
        }
        this.clientSession = parseResult.getClientSession();
        if (parseResult.isExpiredCode()) {
            this.event.error("expired_code");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "Code is expired", Response.Status.BAD_REQUEST);
        }
        this.clientSession.setNote("service_ticket", ticket);
        if (requireReauth && AuthenticationManager.isSSOAuthentication((AuthenticatedClientSessionModel)this.clientSession)) {
            this.event.error("session_expired");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "Interactive authentication was requested but not performed", Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = this.clientSession.getUserSession();
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "User session not found", Response.Status.BAD_REQUEST);
        }
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "User not found", Response.Status.BAD_REQUEST);
        }
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "User disabled", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        this.event.session(userSession.getId());
        if (!this.client.getClientId().equals(this.clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new CASValidationException(CASErrorCode.INVALID_SERVICE, "Auth error", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid((RealmModel)this.realm, (UserSessionModel)userSession)) {
            this.event.error("user_session_not_found");
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, "Session not active", Response.Status.BAD_REQUEST);
        }
    }

    protected Map<String, Object> getUserAttributes() {
        UserSessionModel userSession = this.clientSession.getUserSession();
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter((AuthenticatedClientSessionModel)this.clientSession, null, (KeycloakSession)this.session);
        Set mappings = clientSessionCtx.getProtocolMappersStream().collect(Collectors.toSet());
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (!(mapper instanceof CASAttributeMapper)) continue;
            ((CASAttributeMapper)mapper).setAttribute(attributes, mapping, userSession, this.session, (ClientSessionContext)clientSessionCtx);
        }
        return attributes;
    }
}

