/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.cas.mappers.AbstractCASProtocolMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class UserSessionNoteMapper
extends AbstractCASProtocolMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "cas-usersessionmodel-note-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Session Note";
    }

    @Override
    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a custom user session note to a token claim.";
    }

    @Override
    public void setAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCt) {
        String noteName = (String)mappingModel.getConfig().get("user.session.note");
        String noteValue = userSession.getNote(noteName);
        if (noteValue == null) {
            return;
        }
        this.setMappedAttribute(attributes, mappingModel, noteValue);
    }

    public static ProtocolMapperModel create(String name, String userSessionNote, String tokenClaimName, String jsonType) {
        ProtocolMapperModel mapper = CASAttributeMapperHelper.createClaimMapper(name, tokenClaimName, jsonType, PROVIDER_ID);
        mapper.getConfig().put("user.session.note", userSessionNote);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.session.note");
        property.setLabel("userSession.modelNote.label");
        property.setHelpText("userSession.modelNote.tooltip");
        property.setType("String");
        configProperties.add(property);
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        OIDCAttributeMapperHelper.addJsonTypeConfig(configProperties);
    }
}

