/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.cas.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.utils.RoleResolveUtil;

public class UserRealmRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "cas-usermodel-realm-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Realm Role";
    }

    @Override
    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user realm role to a token claim.";
    }

    @Override
    public void setAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCtx) {
        String rolePrefix = (String)mappingModel.getConfig().get("usermodel.realmRoleMapping.rolePrefix");
        AccessToken.Access access = RoleResolveUtil.getResolvedRealmRoles((KeycloakSession)session, (ClientSessionContext)clientSessionCtx, (boolean)false);
        if (access == null) {
            return;
        }
        this.setAttribute(attributes, mappingModel, access.getRoles(), rolePrefix);
    }

    public static ProtocolMapperModel create(String realmRolePrefix, String name, String tokenClaimName) {
        ProtocolMapperModel mapper = CASAttributeMapperHelper.createClaimMapper(name, tokenClaimName, "String", PROVIDER_ID);
        mapper.getConfig().put("usermodel.realmRoleMapping.rolePrefix", realmRolePrefix);
        return mapper;
    }

    static {
        ProviderConfigProperty realmRolePrefix = new ProviderConfigProperty();
        realmRolePrefix.setName("usermodel.realmRoleMapping.rolePrefix");
        realmRolePrefix.setLabel("usermodel.realmRoleMapping.rolePrefix.label");
        realmRolePrefix.setHelpText("usermodel.realmRoleMapping.rolePrefix.tooltip");
        realmRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(realmRolePrefix);
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(CONFIG_PROPERTIES);
    }
}

