/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.cas.mappers.AbstractCASProtocolMapper;
import org.keycloak.protocol.cas.mappers.CASAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeMapper
extends AbstractCASProtocolMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "cas-usermodel-attribute-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public String getHelpText() {
        return "Map a custom user attribute to a token claim.";
    }

    @Override
    public void setAttribute(Map<String, Object> attributes, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCt) {
        UserModel user = userSession.getUser();
        String attributeName = (String)mappingModel.getConfig().get("user.attribute");
        boolean aggregateAttrs = Boolean.valueOf((String)mappingModel.getConfig().get("aggregate.attrs"));
        Collection attributeValue = KeycloakModelUtils.resolveAttribute((UserModel)user, (String)attributeName, (boolean)aggregateAttrs);
        this.setMappedAttribute(attributes, mappingModel, attributeValue);
    }

    public static ProtocolMapperModel create(String name, String userAttribute, String tokenClaimName, String claimType, boolean multivalued) {
        return UserAttributeMapper.create(name, userAttribute, tokenClaimName, claimType, multivalued, false);
    }

    public static ProtocolMapperModel create(String name, String userAttribute, String tokenClaimName, String claimType, boolean multivalued, boolean aggregateAttrs) {
        ProtocolMapperModel mapper = CASAttributeMapperHelper.createClaimMapper(name, tokenClaimName, claimType, PROVIDER_ID);
        mapper.getConfig().put("user.attribute", userAttribute);
        if (multivalued) {
            mapper.getConfig().put("multivalued", "true");
        }
        if (aggregateAttrs) {
            mapper.getConfig().put("aggregate.attrs", "true");
        }
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.attribute");
        property.setLabel("usermodel.attr.label");
        property.setHelpText("usermodel.attr.tooltip");
        property.setType("String");
        configProperties.add(property);
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        OIDCAttributeMapperHelper.addJsonTypeConfig(configProperties);
        property = new ProviderConfigProperty();
        property.setName("multivalued");
        property.setLabel("multivalued.label");
        property.setHelpText("multivalued.tooltip");
        property.setType("boolean");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("aggregate.attrs");
        property.setLabel("aggregate.attrs.label");
        property.setHelpText("aggregate.attrs.tooltip");
        property.setType("boolean");
        configProperties.add(property);
    }
}

