/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.endpoints;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.StringReader;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.keycloak.dom.saml.v1.protocol.SAML11ResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.cas.endpoints.AbstractValidateEndpoint;
import org.keycloak.protocol.cas.representations.CASErrorCode;
import org.keycloak.protocol.cas.representations.SamlResponseHelper;
import org.keycloak.protocol.cas.utils.CASValidationException;
import org.keycloak.services.Urls;
import org.xml.sax.InputSource;

public class SamlValidateEndpoint
extends AbstractValidateEndpoint {
    public SamlValidateEndpoint(KeycloakSession session, RealmModel realm, EventBuilder event) {
        super(session, realm, event.event(EventType.CODE_TO_TOKEN));
    }

    @POST
    @Consumes(value={"text/xml;charset=utf-8"})
    @Produces(value={"text/xml;charset=utf-8"})
    public Response validate(String input) {
        MultivaluedMap queryParams = this.session.getContext().getUri().getQueryParameters();
        try {
            String soapAction = Optional.ofNullable(this.session.getContext().getRequestHeaders().getHeaderString("SOAPAction")).map(s -> s.trim().replace("\"", "")).orElse("");
            if (!soapAction.equals("http://www.oasis-open.org/committees/security")) {
                throw new CASValidationException(CASErrorCode.INTERNAL_ERROR, "Not a validation request", Response.Status.BAD_REQUEST);
            }
            String service = (String)queryParams.getFirst((Object)"TARGET");
            boolean renew = queryParams.containsKey((Object)"renew");
            this.checkRealm();
            this.checkSsl();
            this.checkClient(service);
            String issuer = Urls.realmIssuer((URI)this.session.getContext().getUri().getBaseUri(), (String)this.realm.getName());
            String ticket = this.getTicket(input);
            this.checkTicket(ticket, renew);
            UserModel user = this.clientSession.getUserSession().getUser();
            Map<String, Object> attributes = this.getUserAttributes();
            SAML11ResponseType response = SamlResponseHelper.successResponse(issuer, user.getUsername(), attributes);
            return Response.ok((Object)SamlResponseHelper.soap(response)).build();
        }
        catch (CASValidationException ex) {
            this.logger.warnf("Invalid SAML1.1 token %s", (Object)ex.getErrorDescription());
            SAML11ResponseType response = SamlResponseHelper.errorResponse(ex);
            return Response.ok().entity((Object)SamlResponseHelper.soap(response)).build();
        }
    }

    private String getTicket(String input) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new MapNamespaceContext(Collections.singletonMap("samlp", "urn:oasis:names:tc:SAML:1.0:protocol")));
            XPathExpression expression = xPath.compile("//samlp:AssertionArtifact/text()");
            return expression.evaluate(new InputSource(new StringReader(input)));
        }
        catch (XPathExpressionException ex) {
            throw new CASValidationException(CASErrorCode.INVALID_TICKET, ex.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    private static class MapNamespaceContext
    implements NamespaceContext {
        Map<String, String> map;

        private MapNamespaceContext(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public String getNamespaceURI(String s) {
            return this.map.get(s);
        }

        @Override
        public String getPrefix(String s) {
            return this.map.entrySet().stream().filter(e -> ((String)e.getValue()).equals(s)).findFirst().map(Map.Entry::getKey).orElse(null);
        }

        @Override
        public Iterator<String> getPrefixes(String s) {
            return this.map.keySet().iterator();
        }
    }
}

