'use strict'

var HAS_OWN       = Object.prototype.hasOwnProperty
var STR_OBJECT    = 'object'
var STR_UNDEFINED = 'undefined'

/**
 * Copies all properties from source to destination, if the property does not exist into the destination
 *
 *      copyIf({name: 'jon',age:5}, {age:7})
 *      // => { name: 'jon', age: 7}
 *
 * @param {Object} source
 * @param {Object} destination
 *
 * @return {Object} destination
 */
module.exports = function(source, destination){
    destination = destination || {}

    if (source != null && typeof source === STR_OBJECT){

        for (var i in source) if ( HAS_OWN.call(source, i) && (typeof destination[i] === STR_UNDEFINED) ) {

            destination[i] = source[i]

        }
    }

    return destination
}