<?php
/**
 * UTF-8 lookup table for lower case accented letters
 *
 * This lookuptable defines replacements for accented characters from the ASCII-7
 * range. This are lower case letters only.
 *
 * @author Andreas Gohr <andi@splitbrain.org>
 * @see    \dokuwiki\Utf8\Clean::deaccent()
 */
return [
    'á' => 'a',
    'à' => 'a',
    'ă' => 'a',
    'â' => 'a',
    'å' => 'a',
    'ä' => 'ae',
    'ã' => 'a',
    'ą' => 'a',
    'ā' => 'a',
    'æ' => 'ae',
    'ḃ' => 'b',
    'ć' => 'c',
    'ĉ' => 'c',
    'č' => 'c',
    'ċ' => 'c',
    'ç' => 'c',
    'ď' => 'd',
    'ḋ' => 'd',
    'đ' => 'd',
    'ð' => 'dh',
    'é' => 'e',
    'è' => 'e',
    'ĕ' => 'e',
    'ê' => 'e',
    'ě' => 'e',
    'ë' => 'e',
    'ė' => 'e',
    'ę' => 'e',
    'ē' => 'e',
    'ḟ' => 'f',
    'ƒ' => 'f',
    'ğ' => 'g',
    'ĝ' => 'g',
    'ġ' => 'g',
    'ģ' => 'g',
    'ĥ' => 'h',
    'ħ' => 'h',
    'í' => 'i',
    'ì' => 'i',
    'î' => 'i',
    'ï' => 'i',
    'ĩ' => 'i',
    'į' => 'i',
    'ī' => 'i',
    'ĵ' => 'j',
    'ķ' => 'k',
    'ĺ' => 'l',
    'ľ' => 'l',
    'ļ' => 'l',
    'ł' => 'l',
    'ṁ' => 'm',
    'ń' => 'n',
    'ň' => 'n',
    'ñ' => 'n',
    'ņ' => 'n',
    'ó' => 'o',
    'ò' => 'o',
    'ô' => 'o',
    'ö' => 'oe',
    'ő' => 'o',
    'õ' => 'o',
    'ø' => 'o',
    'ō' => 'o',
    'ơ' => 'o',
    'ṗ' => 'p',
    'ŕ' => 'r',
    'ř' => 'r',
    'ŗ' => 'r',
    'ś' => 's',
    'ŝ' => 's',
    'š' => 's',
    'ṡ' => 's',
    'ş' => 's',
    'ș' => 's',
    'ß' => 'ss',
    'ť' => 't',
    'ṫ' => 't',
    'ţ' => 't',
    'ț' => 't',
    'ŧ' => 't',
    'ú' => 'u',
    'ù' => 'u',
    'ŭ' => 'u',
    'û' => 'u',
    'ů' => 'u',
    'ü' => 'ue',
    'ű' => 'u',
    'ũ' => 'u',
    'ų' => 'u',
    'ū' => 'u',
    'ư' => 'u',
    'ẃ' => 'w',
    'ẁ' => 'w',
    'ŵ' => 'w',
    'ẅ' => 'w',
    'ý' => 'y',
    'ỳ' => 'y',
    'ŷ' => 'y',
    'ÿ' => 'y',
    'ź' => 'z',
    'ž' => 'z',
    'ż' => 'z',
    'þ' => 'th',
    'µ' => 'u',
];
