/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class CircleObject
extends PrimitiveCircleObject
implements MoveableObject {
    protected PointObject P2;
    boolean Fixed = false;
    Expression E;
    boolean ExpressionFailed;
    boolean Ellipse = false;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public CircleObject(Construction construction, PointObject pointObject, PointObject pointObject2) {
        super(construction, pointObject);
        this.P2 = pointObject2;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Circle";
    }

    public void updateText() {
        if (this.Fixed) {
            if (this.E == null) {
                this.setText(CircleObject.text3(Zirkel.name("text.circle.fixed"), this.M.getName(), this.P2.getName(), "" + this.round(this.R)));
            } else {
                this.setText(CircleObject.text3(Zirkel.name("text.circle.fixed"), this.M.getName(), this.P2.getName(), "\"" + this.E.toString() + "\""));
            }
        } else {
            this.setText(CircleObject.text2(Zirkel.name("text.circle"), this.M.getName(), this.P2.getName()));
        }
    }

    public void validate() {
        super.validate();
        this.ExpressionFailed = false;
        if (!this.M.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        double d2 = this.P2.getX();
        double d3 = this.P2.getY();
        double d4 = d2 - this.X;
        double d5 = d3 - this.Y;
        this.R = Math.sqrt(d4 * d4 + d5 * d5);
        if (this.Fixed) {
            if (!this.P2.moveableBy(this)) {
                this.Fixed = false;
            } else {
                try {
                    double d6 = this.E.getValue();
                    if (d6 < 0.0) {
                        d6 = 0.0;
                    }
                    if (this.R < 1.0E-10) {
                        this.P2.move(this.X + d6, this.Y);
                    } else {
                        this.P2.move(this.X + d4 * d6 / this.R, this.Y + d5 * d6 / this.R);
                    }
                    this.R = d6;
                    this.P2.movedBy(this);
                }
                catch (Exception exception) {
                    this.R = 0.0;
                    this.P2.move(this.X, this.Y);
                    this.ExpressionFailed = true;
                    this.Valid = false;
                }
            }
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("through", this.P2.getName());
        if (this.Fixed && this.E != null) {
            xmlWriter.printArg("fixed", this.E.toString());
        }
        super.printArgs(xmlWriter);
    }

    public boolean canFix() {
        return this.P2.moveableBy(this);
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean bl, String string) throws ConstructionException {
        if (!bl || string.equals("")) {
            this.Fixed = false;
            this.E = null;
        } else {
            this.E = new Expression(string, this.getConstruction(), this);
            if (!this.E.isValid()) {
                throw new ConstructionException(this.E.getErrorText());
            }
            this.Fixed = true;
        }
        this.updateText();
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (this.ExpressionFailed && this.M.valid()) {
            return this.M.nearto(n, n2, zirkelCanvas);
        }
        return super.nearto(n, n2, zirkelCanvas);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        super.edit(zirkelCanvas);
        if (this.E != null && !this.E.isValid()) {
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.E.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
    }

    public boolean isValidFix() {
        return this.E != null && this.E.isValid();
    }

    public void updateCircleDep() {
        this.addDep(this.P2);
    }

    public void translate() {
        super.translate();
        this.P2 = (PointObject)this.P2.getTranslation();
        try {
            this.setFixed(this.Fixed, this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            this.Fixed = false;
        }
    }

    public String getStringLength() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "" + this.roundDisplay(this.R);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public Enumeration depending() {
        super.depending();
        if (!this.Fixed || this.E == null) {
            return this.depset(this.P2);
        }
        this.depset(this.P2);
        Enumeration enumeration = this.E.getDepList().elements();
        while (enumeration.hasMoreElements()) {
            DL.add((ConstructionObject)enumeration.nextElement());
        }
        return DL.elements();
    }

    public PointObject getP2() {
        return this.P2;
    }

    public boolean contains(PointObject pointObject) {
        return pointObject == this.P2;
    }

    public void dragTo(double d2, double d3) {
        this.M.move(this.x1 + (d2 - this.x3), this.y1 + (d3 - this.y3));
        this.P2.move(this.x2 + (d2 - this.x3), this.y2 + (d3 - this.y3));
    }

    public void move(double d2, double d3) {
    }

    public boolean moveable() {
        return !this.Fixed && this.M.moveable() && this.P2.moveable();
    }

    public void startDrag(double d2, double d3) {
        this.x1 = this.M.getX();
        this.y1 = this.M.getY();
        this.x2 = this.P2.getX();
        this.y2 = this.P2.getY();
        this.x3 = d2;
        this.y3 = d3;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        if (this.moveable()) {
            this.M.snap(zirkelCanvas);
            this.P2.snap(zirkelCanvas);
        }
    }
}

