# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class CommonResourceProperties(_serialization.Model):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type. Example: "Microsoft.Quota/quotas".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class CreateGenericQuotaRequestParameters(_serialization.Model):
    """Quota change requests information.

    :ivar value: Quota change requests.
    :vartype value: list[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CurrentQuotaLimitBase]"},
    }

    def __init__(self, *, value: Optional[List["_models.CurrentQuotaLimitBase"]] = None, **kwargs):
        """
        :keyword value: Quota change requests.
        :paramtype value: list[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        """
        super().__init__(**kwargs)
        self.value = value


class CurrentQuotaLimitBase(_serialization.Model):
    """Quota limit.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar properties: Quota properties for the specified resource, based on the API called, Quotas
     or Usages.
    :vartype properties: ~azure.mgmt.quota.models.QuotaProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "QuotaProperties"},
    }

    def __init__(self, *, properties: Optional["_models.QuotaProperties"] = None, **kwargs):
        """
        :keyword properties: Quota properties for the specified resource, based on the API called,
         Quotas or Usages.
        :paramtype properties: ~azure.mgmt.quota.models.QuotaProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.properties = properties


class CurrentUsagesBase(_serialization.Model):
    """Resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar properties: Usage properties for the specified resource.
    :vartype properties: ~azure.mgmt.quota.models.UsagesProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "UsagesProperties"},
    }

    def __init__(self, *, properties: Optional["_models.UsagesProperties"] = None, **kwargs):
        """
        :keyword properties: Usage properties for the specified resource.
        :paramtype properties: ~azure.mgmt.quota.models.UsagesProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.properties = properties


class ExceptionResponse(_serialization.Model):
    """Error.

    :ivar error: API error details.
    :vartype error: ~azure.mgmt.quota.models.ServiceError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ServiceError"},
    }

    def __init__(self, *, error: Optional["_models.ServiceError"] = None, **kwargs):
        """
        :keyword error: API error details.
        :paramtype error: ~azure.mgmt.quota.models.ServiceError
        """
        super().__init__(**kwargs)
        self.error = error


class LimitJsonObject(_serialization.Model):
    """LimitJson abstract class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LimitObject

    All required parameters must be populated in order to send to Azure.

    :ivar limit_object_type: The limit object type. Required. "LimitValue"
    :vartype limit_object_type: str or ~azure.mgmt.quota.models.LimitType
    """

    _validation = {
        "limit_object_type": {"required": True},
    }

    _attribute_map = {
        "limit_object_type": {"key": "limitObjectType", "type": "str"},
    }

    _subtype_map = {"limit_object_type": {"LimitValue": "LimitObject"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.limit_object_type = None  # type: Optional[str]


class LimitObject(LimitJsonObject):
    """The resource quota limit value.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_object_type: The limit object type. Required. "LimitValue"
    :vartype limit_object_type: str or ~azure.mgmt.quota.models.LimitType
    :ivar value: The quota/limit value. Required.
    :vartype value: int
    :ivar limit_type: The quota or usages limit types. Known values are: "Independent" and
     "Shared".
    :vartype limit_type: str or ~azure.mgmt.quota.models.QuotaLimitTypes
    """

    _validation = {
        "limit_object_type": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "limit_object_type": {"key": "limitObjectType", "type": "str"},
        "value": {"key": "value", "type": "int"},
        "limit_type": {"key": "limitType", "type": "str"},
    }

    def __init__(self, *, value: int, limit_type: Optional[Union[str, "_models.QuotaLimitTypes"]] = None, **kwargs):
        """
        :keyword value: The quota/limit value. Required.
        :paramtype value: int
        :keyword limit_type: The quota or usages limit types. Known values are: "Independent" and
         "Shared".
        :paramtype limit_type: str or ~azure.mgmt.quota.models.QuotaLimitTypes
        """
        super().__init__(**kwargs)
        self.limit_object_type = "LimitValue"  # type: str
        self.value = value
        self.limit_type = limit_type


class OperationDisplay(_serialization.Model):
    """OperationDisplay.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """OperationList.

    :ivar value:
    :vartype value: list[~azure.mgmt.quota.models.OperationResponse]
    :ivar next_link: URL to get the next page of items.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationResponse"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.quota.models.OperationResponse]
        :keyword next_link: URL to get the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResponse(_serialization.Model):
    """OperationResponse.

    :ivar name:
    :vartype name: str
    :ivar display:
    :vartype display: ~azure.mgmt.quota.models.OperationDisplay
    :ivar origin:
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display:
        :paramtype display: ~azure.mgmt.quota.models.OperationDisplay
        :keyword origin:
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class QuotaLimits(_serialization.Model):
    """Quota limits.

    :ivar value: List of quota limits.
    :vartype value: list[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
    :ivar next_link: The URI used to fetch the next page of quota limits. When there are no more
     pages, this string is null.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CurrentQuotaLimitBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CurrentQuotaLimitBase"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of quota limits.
        :paramtype value: list[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :keyword next_link: The URI used to fetch the next page of quota limits. When there are no more
         pages, this string is null.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaLimitsResponse(_serialization.Model):
    """Quota limits request response.

    :ivar value: List of quota limits with the quota request status.
    :vartype value: list[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
    :ivar next_link: The URI used to fetch the next page of quota limits. When there are no more
     pages, this is null.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CurrentQuotaLimitBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CurrentQuotaLimitBase"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of quota limits with the quota request status.
        :paramtype value: list[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :keyword next_link: The URI used to fetch the next page of quota limits. When there are no more
         pages, this is null.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaProperties(_serialization.Model):
    """Quota properties for the specified resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: Resource quota limit properties.
    :vartype limit: ~azure.mgmt.quota.models.LimitJsonObject
    :ivar unit: The quota units, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name: Resource name provided by the resource provider. Use this property name when
     requesting quota.
    :vartype name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: Resource type name.
    :vartype resource_type: str
    :ivar quota_period: The time period over which the quota usage values are summarized. For
     example:
     *P1D (per one day)*\ PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because, for some resources like compute, the period is irrelevant.
    :vartype quota_period: str
    :ivar is_quota_applicable: States if quota can be requested for this resource.
    :vartype is_quota_applicable: bool
    :ivar properties: Additional properties for the specific resource provider.
    :vartype properties: JSON
    """

    _validation = {
        "unit": {"readonly": True},
        "quota_period": {"readonly": True},
        "is_quota_applicable": {"readonly": True},
    }

    _attribute_map = {
        "limit": {"key": "limit", "type": "LimitJsonObject"},
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "ResourceName"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "is_quota_applicable": {"key": "isQuotaApplicable", "type": "bool"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        limit: Optional["_models.LimitJsonObject"] = None,
        name: Optional["_models.ResourceName"] = None,
        resource_type: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword limit: Resource quota limit properties.
        :paramtype limit: ~azure.mgmt.quota.models.LimitJsonObject
        :keyword name: Resource name provided by the resource provider. Use this property name when
         requesting quota.
        :paramtype name: ~azure.mgmt.quota.models.ResourceName
        :keyword resource_type: Resource type name.
        :paramtype resource_type: str
        :keyword properties: Additional properties for the specific resource provider.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.limit = limit
        self.unit = None
        self.name = name
        self.resource_type = resource_type
        self.quota_period = None
        self.is_quota_applicable = None
        self.properties = properties


class QuotaRequestDetails(_serialization.Model):
    """List of quota requests with details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Quota request ID.
    :vartype id: str
    :ivar name: Quota request name.
    :vartype name: str
    :ivar type: Resource type. "Microsoft.Quota/quotas".
    :vartype type: str
    :ivar provisioning_state: The quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar error: Error details of the quota request.
    :vartype error: ~azure.mgmt.quota.models.ServiceErrorDetail
    :ivar request_submit_time: The quota request submission time. The date conforms to the
     following format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar value: Quota request details.
    :vartype value: list[~azure.mgmt.quota.models.SubRequest]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "message": {"readonly": True},
        "request_submit_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "error": {"key": "properties.error", "type": "ServiceErrorDetail"},
        "request_submit_time": {"key": "properties.requestSubmitTime", "type": "iso-8601"},
        "value": {"key": "properties.value", "type": "[SubRequest]"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ServiceErrorDetail"] = None,
        value: Optional[List["_models.SubRequest"]] = None,
        **kwargs
    ):
        """
        :keyword error: Error details of the quota request.
        :paramtype error: ~azure.mgmt.quota.models.ServiceErrorDetail
        :keyword value: Quota request details.
        :paramtype value: list[~azure.mgmt.quota.models.SubRequest]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.error = error
        self.request_submit_time = None
        self.value = value


class QuotaRequestDetailsList(_serialization.Model):
    """Quota request information.

    :ivar value: Quota request details.
    :vartype value: list[~azure.mgmt.quota.models.QuotaRequestDetails]
    :ivar next_link: The URI for fetching the next page of quota limits. When there are no more
     pages, this string is null.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[QuotaRequestDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.QuotaRequestDetails"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Quota request details.
        :paramtype value: list[~azure.mgmt.quota.models.QuotaRequestDetails]
        :keyword next_link: The URI for fetching the next page of quota limits. When there are no more
         pages, this string is null.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaRequestOneResourceSubmitResponse(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Quota request response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :ivar type: Resource type. "Microsoft.Quota/ServiceLimitRequests".
    :vartype type: str
    :ivar provisioning_state: Quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar request_submit_time: Quota request submission time. The date conforms to the following
     ISO 8601 standard format: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar limit: Resource quota limit properties.
    :vartype limit: ~azure.mgmt.quota.models.LimitObject
    :ivar current_value: Usage information for the current resource.
    :vartype current_value: int
    :ivar unit: The quota limit units, such as Count and Bytes. When requesting quota, use the
     **unit** value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name_properties_name: Resource name provided by the resource provider. Use this property
     name when requesting quota.
    :vartype name_properties_name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: Resource type name.
    :vartype resource_type: str
    :ivar quota_period: The time period over which the quota usage values are summarized. For
     example:
     *P1D (per one day)*\ PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because, for some resources like compute, the period is irrelevant.
    :vartype quota_period: str
    :ivar is_quota_applicable: States if quota can be requested for this resource.
    :vartype is_quota_applicable: bool
    :ivar error: Error details of the quota request.
    :vartype error: ~azure.mgmt.quota.models.ServiceErrorDetail
    :ivar properties: Additional properties for the specific resource provider.
    :vartype properties: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "message": {"readonly": True},
        "request_submit_time": {"readonly": True},
        "current_value": {"readonly": True},
        "quota_period": {"readonly": True},
        "is_quota_applicable": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "request_submit_time": {"key": "properties.requestSubmitTime", "type": "iso-8601"},
        "limit": {"key": "properties.limit", "type": "LimitObject"},
        "current_value": {"key": "properties.currentValue", "type": "int"},
        "unit": {"key": "properties.unit", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "ResourceName"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "quota_period": {"key": "properties.quotaPeriod", "type": "str"},
        "is_quota_applicable": {"key": "properties.isQuotaApplicable", "type": "bool"},
        "error": {"key": "properties.error", "type": "ServiceErrorDetail"},
        "properties": {"key": "properties.properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        limit: Optional["_models.LimitObject"] = None,
        unit: Optional[str] = None,
        name_properties_name: Optional["_models.ResourceName"] = None,
        resource_type: Optional[str] = None,
        error: Optional["_models.ServiceErrorDetail"] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword limit: Resource quota limit properties.
        :paramtype limit: ~azure.mgmt.quota.models.LimitObject
        :keyword unit: The quota limit units, such as Count and Bytes. When requesting quota, use the
         **unit** value returned in the GET response in the request body of your PUT operation.
        :paramtype unit: str
        :keyword name_properties_name: Resource name provided by the resource provider. Use this
         property name when requesting quota.
        :paramtype name_properties_name: ~azure.mgmt.quota.models.ResourceName
        :keyword resource_type: Resource type name.
        :paramtype resource_type: str
        :keyword error: Error details of the quota request.
        :paramtype error: ~azure.mgmt.quota.models.ServiceErrorDetail
        :keyword properties: Additional properties for the specific resource provider.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.request_submit_time = None
        self.limit = limit
        self.current_value = None
        self.unit = unit
        self.name_properties_name = name_properties_name
        self.resource_type = resource_type
        self.quota_period = None
        self.is_quota_applicable = None
        self.error = error
        self.properties = properties


class QuotaRequestProperties(_serialization.Model):
    """Quota request properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar error: Error details of the quota request.
    :vartype error: ~azure.mgmt.quota.models.ServiceErrorDetail
    :ivar request_submit_time: The quota request submission time. The date conforms to the
     following format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ.
    :vartype request_submit_time: ~datetime.datetime
    :ivar value: Quota request details.
    :vartype value: list[~azure.mgmt.quota.models.SubRequest]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "message": {"readonly": True},
        "request_submit_time": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "error": {"key": "error", "type": "ServiceErrorDetail"},
        "request_submit_time": {"key": "requestSubmitTime", "type": "iso-8601"},
        "value": {"key": "value", "type": "[SubRequest]"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ServiceErrorDetail"] = None,
        value: Optional[List["_models.SubRequest"]] = None,
        **kwargs
    ):
        """
        :keyword error: Error details of the quota request.
        :paramtype error: ~azure.mgmt.quota.models.ServiceErrorDetail
        :keyword value: Quota request details.
        :paramtype value: list[~azure.mgmt.quota.models.SubRequest]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.message = None
        self.error = error
        self.request_submit_time = None
        self.value = value


class QuotaRequestSubmitResponse(_serialization.Model):
    """Quota request response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Quota request ID.
    :vartype id: str
    :ivar name: Quota request name.
    :vartype name: str
    :ivar properties: Quota request details.
    :vartype properties: ~azure.mgmt.quota.models.QuotaRequestProperties
    :ivar type: Resource type. "Microsoft.Quota/quotas".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "QuotaRequestProperties"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, properties: Optional["_models.QuotaRequestProperties"] = None, **kwargs):
        """
        :keyword properties: Quota request details.
        :paramtype properties: ~azure.mgmt.quota.models.QuotaRequestProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = properties
        self.type = None


class QuotaRequestSubmitResponse202(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The quota request response with the quota request ID.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID. To check the request status, use the **id** value in a `Quota
     Request Status
     <https://docs.microsoft.com/en-us/rest/api/reserved-vm-instances/quotarequeststatus/get>`_ GET
     operation.
    :vartype id: str
    :ivar name: Operation ID.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly message.
    :vartype message: str
    :ivar limit: Resource quota limit properties.
    :vartype limit: ~azure.mgmt.quota.models.LimitObject
    :ivar unit: The quota limit units, such as Count and Bytes. When requesting quota, use the
     **unit** value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name_properties_name: Resource name provided by the resource provider. Use this property
     name when requesting quota.
    :vartype name_properties_name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: Resource type name.
    :vartype resource_type: str
    :ivar quota_period: The time period over which the quota usage values are summarized. For
     example:
     *P1D (per one day)*\ PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because, for some resources like compute, the period is irrelevant.
    :vartype quota_period: str
    :ivar properties: Additional properties for the specific resource provider.
    :vartype properties: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "message": {"readonly": True},
        "quota_period": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "limit": {"key": "properties.limit", "type": "LimitObject"},
        "unit": {"key": "properties.unit", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "ResourceName"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "quota_period": {"key": "properties.quotaPeriod", "type": "str"},
        "properties": {"key": "properties.properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        limit: Optional["_models.LimitObject"] = None,
        unit: Optional[str] = None,
        name_properties_name: Optional["_models.ResourceName"] = None,
        resource_type: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword limit: Resource quota limit properties.
        :paramtype limit: ~azure.mgmt.quota.models.LimitObject
        :keyword unit: The quota limit units, such as Count and Bytes. When requesting quota, use the
         **unit** value returned in the GET response in the request body of your PUT operation.
        :paramtype unit: str
        :keyword name_properties_name: Resource name provided by the resource provider. Use this
         property name when requesting quota.
        :paramtype name_properties_name: ~azure.mgmt.quota.models.ResourceName
        :keyword resource_type: Resource type name.
        :paramtype resource_type: str
        :keyword properties: Additional properties for the specific resource provider.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.limit = limit
        self.unit = unit
        self.name_properties_name = name_properties_name
        self.resource_type = resource_type
        self.quota_period = None
        self.properties = properties


class ResourceName(_serialization.Model):
    """Name of the resource provided by the resource Provider. When requesting quota, use this property name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Resource name.
    :vartype value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    _validation = {
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs):
        """
        :keyword value: Resource name.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = None


class ServiceError(_serialization.Model):
    """API error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar details: List of error details.
    :vartype details: list[~azure.mgmt.quota.models.ServiceErrorDetail]
    """

    _validation = {
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ServiceErrorDetail]"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = None


class ServiceErrorDetail(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class SubRequest(_serialization.Model):
    """Request property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: Resource type for which the quota properties were requested.
    :vartype resource_type: str
    :ivar unit: Quota limit units, such as Count and Bytes. When requesting quota, use the **unit**
     value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar provisioning_state: The quota request status. Known values are: "Accepted", "Invalid",
     "Succeeded", "Failed", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.quota.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar sub_request_id: Quota request ID.
    :vartype sub_request_id: str
    :ivar limit: Resource quota limit properties.
    :vartype limit: ~azure.mgmt.quota.models.LimitJsonObject
    """

    _validation = {
        "resource_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "message": {"readonly": True},
        "sub_request_id": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "ResourceName"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "sub_request_id": {"key": "subRequestId", "type": "str"},
        "limit": {"key": "limit", "type": "LimitJsonObject"},
    }

    def __init__(
        self,
        *,
        name: Optional["_models.ResourceName"] = None,
        unit: Optional[str] = None,
        limit: Optional["_models.LimitJsonObject"] = None,
        **kwargs
    ):
        """
        :keyword name: Resource name.
        :paramtype name: ~azure.mgmt.quota.models.ResourceName
        :keyword unit: Quota limit units, such as Count and Bytes. When requesting quota, use the
         **unit** value returned in the GET response in the request body of your PUT operation.
        :paramtype unit: str
        :keyword limit: Resource quota limit properties.
        :paramtype limit: ~azure.mgmt.quota.models.LimitJsonObject
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_type = None
        self.unit = unit
        self.provisioning_state = None
        self.message = None
        self.sub_request_id = None
        self.limit = limit


class UsagesLimits(_serialization.Model):
    """Quota limits.

    :ivar value: List of quota limits.
    :vartype value: list[~azure.mgmt.quota.models.CurrentUsagesBase]
    :ivar next_link: The URI used to fetch the next page of quota limits. When there are no more
     pages, this is null.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CurrentUsagesBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CurrentUsagesBase"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of quota limits.
        :paramtype value: list[~azure.mgmt.quota.models.CurrentUsagesBase]
        :keyword next_link: The URI used to fetch the next page of quota limits. When there are no more
         pages, this is null.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UsagesObject(_serialization.Model):
    """The resource usages value.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The usages value. Required.
    :vartype value: int
    :ivar usages_type: The quota or usages limit types. Known values are: "Individual" and
     "Combined".
    :vartype usages_type: str or ~azure.mgmt.quota.models.UsagesTypes
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "int"},
        "usages_type": {"key": "usagesType", "type": "str"},
    }

    def __init__(self, *, value: int, usages_type: Optional[Union[str, "_models.UsagesTypes"]] = None, **kwargs):
        """
        :keyword value: The usages value. Required.
        :paramtype value: int
        :keyword usages_type: The quota or usages limit types. Known values are: "Individual" and
         "Combined".
        :paramtype usages_type: str or ~azure.mgmt.quota.models.UsagesTypes
        """
        super().__init__(**kwargs)
        self.value = value
        self.usages_type = usages_type


class UsagesProperties(_serialization.Model):
    """Usage properties for the specified resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar usages: The quota limit properties for this resource.
    :vartype usages: ~azure.mgmt.quota.models.UsagesObject
    :ivar unit: The units for the quota usage, such as Count and Bytes. When requesting quota, use
     the **unit** value returned in the GET response in the request body of your PUT operation.
    :vartype unit: str
    :ivar name: Resource name provided by the resource provider. Use this property name when
     requesting quota.
    :vartype name: ~azure.mgmt.quota.models.ResourceName
    :ivar resource_type: The name of the resource type.
    :vartype resource_type: str
    :ivar quota_period: The time period for the summary of the quota usage values. For example:
     *P1D (per one day)*\ PT1M (per one minute)
     *PT1S (per one second).
     This parameter is optional because it is not relevant for all resources such as compute.
    :vartype quota_period: str
    :ivar is_quota_applicable: States if quota can be requested for this resource.
    :vartype is_quota_applicable: bool
    :ivar properties: Additional properties for the specific resource provider.
    :vartype properties: JSON
    """

    _validation = {
        "unit": {"readonly": True},
        "quota_period": {"readonly": True},
        "is_quota_applicable": {"readonly": True},
    }

    _attribute_map = {
        "usages": {"key": "usages", "type": "UsagesObject"},
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "ResourceName"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "is_quota_applicable": {"key": "isQuotaApplicable", "type": "bool"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        usages: Optional["_models.UsagesObject"] = None,
        name: Optional["_models.ResourceName"] = None,
        resource_type: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword usages: The quota limit properties for this resource.
        :paramtype usages: ~azure.mgmt.quota.models.UsagesObject
        :keyword name: Resource name provided by the resource provider. Use this property name when
         requesting quota.
        :paramtype name: ~azure.mgmt.quota.models.ResourceName
        :keyword resource_type: The name of the resource type.
        :paramtype resource_type: str
        :keyword properties: Additional properties for the specific resource provider.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.usages = usages
        self.unit = None
        self.name = name
        self.resource_type = resource_type
        self.quota_period = None
        self.is_quota_applicable = None
        self.properties = properties
