---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet parser'
canonical: "/puppet/latest/man/parser.html"
---

# Man Page: puppet parser

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-parser** - Interact directly with the parser.

## SYNOPSIS
puppet parser *action*

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

## ACTIONS
-   **dump** - Outputs a dump of the internal parse tree for debugging:
    **SYNOPSIS**

    puppet parser dump \[\--e *source*\] \[\--\[no-\]validate\]
    \[\--format *old, pn, or json*\] \[\--pretty\] \[\--format
    *old\|pn\|json*\] \[\--pretty\] { -e *source* \| \[*templates*
    \...\] }

    **DESCRIPTION**

    This action parses and validates the Puppet DSL syntax without
    compiling a catalog or syncing any resources.

    The output format can be controlled using the \--format
    *old\|pn\|json* where:

-   \'old\' is the default, but now deprecated format which is not API.

-   \'pn\' is the Puppet Extended S-Expression Notation.

-   \'json\' outputs the same graph as \'pn\' but with JSON syntax.

    The output will be \"pretty printed\" when the option \--pretty is
    given together with \--format \'pn\' or \'json\'. This option has no
    effect on the \'old\' format.

    The command accepts one or more manifests (.pp) files, or an -e
    followed by the puppet source text. If no arguments are given, the
    stdin is read (unless it is attached to a terminal)

    The output format of the dumped tree is intended for debugging
    purposes and is not API, it may change from time to time.

    **OPTIONS** *\--e \<source*\> - dump one source expression given on
    the command line.

    *\--format \<old, pn, or json*\> - Get result in \'old\' (deprecated
    format), \'pn\' (new format), or \'json\' (new format in JSON).

    *\--pretty* - Pretty print output. Only applicable together with
    \--format pn or json

    *\--\[no-\]validate* - Whether or not to validate the parsed result,
    if no-validate only syntax errors are reported

    **RETURNS**

    A dump of the resulting AST model unless there are syntax or
    validation errors.

-   **validate** - Validate the syntax of one or more Puppet manifests.:
    **SYNOPSIS**

    puppet parser validate \[*manifest*\] \[*manifest* \...\]

    **DESCRIPTION**

    This action validates Puppet DSL syntax without compiling a catalog
    or syncing any resources. If no manifest files are provided, it will
    validate the default site manifest.

    When validating multiple issues per file are reported up to the
    settings of max_error, and max_warnings. The processing stops after
    having reported issues for the first encountered file with errors.

    **RETURNS**

    Nothing, or the first syntax error encountered.

## EXAMPLES
**validate**

Validate the default site manifest at
/etc/puppetlabs/puppet/manifests/site.pp:

\$ puppet parser validate

Validate two arbitrary manifest files:

\$ puppet parser validate init.pp vhost.pp

Validate from STDIN:

\$ cat init.pp \| puppet parser validate

## COPYRIGHT AND LICENSE
Copyright 2014 by Puppet Inc. Apache 2 license; see COPYING
