/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/PAM170, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_PAM170_H_
#define _PARASAIL_PAM170_H_

#include "parasail.h"
#include "pam_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* # */
/* # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93] */
/* # */
/* # PAM 170 substitution matrix, scale = ln(2)/3 = 0.231049 */
/* # */
/* # Expected score = -1.57, Entropy = 0.640 bits */
/* # */
/* # Lowest score = -10, Highest score = 18 */
/* # */

static const int parasail_pam170_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   3, -3,  0,  0, -3, -1,  0,  1, -3, -1, -3, -2, -2, -5,  1,  2,  2, -8, -5,  0,  0,  0, -1,-10,
/* R */  -3,  8, -1, -3, -5,  1, -2, -4,  2, -3, -4,  4, -1, -6, -1, -1, -2,  2, -6, -4, -2,  0, -2,-10,
/* N */   0, -1,  4,  3, -5,  0,  2,  0,  2, -3, -4,  1, -3, -5, -1,  1,  0, -5, -3, -3,  3,  1, -1,-10,
/* D */   0, -3,  3,  6, -7,  2,  5,  0,  0, -4, -6, -1, -4, -8, -2,  0, -1, -9, -6, -4,  5,  4, -1,-10,
/* C */  -3, -5, -5, -7, 13, -8, -8, -5, -5, -3, -9, -8, -7, -6, -4,  0, -3,-10,  0, -3, -6, -8, -4,-10,
/* Q */  -1,  1,  0,  2, -8,  6,  3, -2,  4, -3, -2,  0, -1, -7,  0, -1, -2, -7, -6, -3,  1,  5, -1,-10,
/* E */   0, -2,  2,  5, -8,  3,  6,  0,  0, -3, -5, -1, -3, -8, -1, -1, -1,-10, -6, -3,  3,  5, -1,-10,
/* G */   1, -4,  0,  0, -5, -2,  0,  6, -4, -4, -6, -3, -4, -6, -2,  1, -1, -9, -7, -2,  0, -1, -2,-10,
/* H */  -3,  2,  2,  0, -5,  4,  0, -4,  9, -4, -3, -1, -4, -3, -1, -2, -2, -4,  0, -3,  1,  2, -1,-10,
/* I */  -1, -3, -3, -4, -3, -3, -3, -4, -4,  7,  2, -3,  2,  1, -3, -2,  0, -7, -2,  5, -3, -3, -1,-10,
/* L */  -3, -4, -4, -6, -9, -2, -5, -6, -3,  2,  7, -4,  4,  1, -4, -4, -3, -3, -2,  2, -5, -4, -2,-10,
/* K */  -2,  4,  1, -1, -8,  0, -1, -3, -1, -3, -4,  6,  1, -8, -2, -1,  0, -5, -6, -4,  0,  0, -2,-10,
/* M */  -2, -1, -3, -4, -7, -1, -3, -4, -4,  2,  4,  1, 10,  0, -3, -2, -1, -6, -4,  2, -4, -2, -1,-10,
/* F */  -5, -6, -5, -8, -6, -7, -8, -6, -3,  1,  1, -8,  0, 10, -6, -4, -5, -1,  7, -2, -6, -7, -4,-10,
/* P */   1, -1, -1, -2, -4,  0, -1, -2, -1, -3, -4, -2, -3, -6,  8,  1,  0, -8, -7, -2, -2, -1, -1,-10,
/* S */   2, -1,  1,  0,  0, -1, -1,  1, -2, -2, -4, -1, -2, -4,  1,  3,  2, -3, -4, -2,  1, -1,  0,-10,
/* T */   2, -2,  0, -1, -3, -2, -1, -1, -2,  0, -3,  0, -1, -5,  0,  2,  5, -7, -4,  0,  0, -1, -1,-10,
/* W */  -8,  2, -5, -9,-10, -7,-10, -9, -4, -7, -3, -5, -6, -1, -8, -3, -7, 18, -1, -9, -7, -8, -6,-10,
/* Y */  -5, -6, -3, -6,  0, -6, -6, -7,  0, -2, -2, -6, -4,  7, -7, -4, -4, -1, 12, -4, -4, -6, -4,-10,
/* V */   0, -4, -3, -4, -3, -3, -3, -2, -3,  5,  2, -4,  2, -2, -2, -2,  0, -9, -4,  6, -3, -3, -1,-10,
/* B */   0, -2,  3,  5, -6,  1,  3,  0,  1, -3, -5,  0, -4, -6, -2,  1,  0, -7, -4, -3,  4,  3, -1,-10,
/* Z */   0,  0,  1,  4, -8,  5,  5, -1,  2, -3, -4,  0, -2, -7, -1, -1, -1, -8, -6, -3,  3,  5, -1,-10,
/* X */  -1, -2, -1, -1, -4, -1, -1, -2, -1, -1, -2, -2, -1, -4, -1,  0, -1, -6, -4, -1, -1, -1, -2,-10,
/* * */ -10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,  1
};

static const parasail_matrix_t parasail_pam170 = {
    "pam170",
    parasail_pam170_,
    parasail_pam_map,
    24,
    18,
    -10,
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_PAM170_H_ */

