/* OsmGpsMap.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "OsmGps", gir_namespace = "OsmGpsMap", gir_version = "1.0", lower_case_cprefix = "osm_gps_")]
namespace OsmGps {
	[CCode (cheader_filename = "osm-gps-map.h", type_id = "osm_gps_map_get_type ()")]
	public class Map : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Map ();
		[Version (since = "0.7.0")]
		public void convert_geographic_to_screen (OsmGps.MapPoint pt, out int pixel_x, out int pixel_y);
		[Version (since = "0.7.0")]
		public void convert_screen_to_geographic (int pixel_x, int pixel_y, OsmGps.MapPoint pt);
		[Version (since = "0.7.0")]
		public void download_cancel_all ();
		public void download_maps (OsmGps.MapPoint pt1, OsmGps.MapPoint pt2, int zoom_start, int zoom_end);
		[NoWrapper]
		public virtual void draw_gps_point (Cairo.Context cr);
		public void get_bbox (OsmGps.MapPoint pt1, OsmGps.MapPoint pt2);
		public static string get_default_cache_directory ();
		[Version (since = "0.7.0")]
		public OsmGps.MapPoint get_event_location (Gdk.EventButton event);
		public float get_scale ();
		[Version (since = "0.7.0")]
		public void gps_add (float latitude, float longitude, float heading);
		[Version (since = "0.7.0")]
		public void gps_clear ();
		[Version (since = "0.7.0")]
		public unowned OsmGps.MapTrack gps_get_track ();
		[Version (since = "0.7.0")]
		public OsmGps.MapImage image_add (float latitude, float longitude, Gdk.Pixbuf image);
		[Version (since = "0.7.0")]
		public OsmGps.MapImage image_add_with_alignment (float latitude, float longitude, Gdk.Pixbuf image, float xalign, float yalign);
		[Version (since = "0.7.4")]
		public OsmGps.MapImage image_add_with_alignment_z (float latitude, float longitude, Gdk.Pixbuf image, float xalign, float yalign, int zorder);
		[Version (since = "0.7.4")]
		public OsmGps.MapImage image_add_z (float latitude, float longitude, Gdk.Pixbuf image, int zorder);
		[Version (since = "0.7.0")]
		public bool image_remove (OsmGps.MapImage image);
		[Version (since = "0.7.0")]
		public void image_remove_all ();
		[Version (since = "0.7.0")]
		public void layer_add (OsmGps.MapLayer layer);
		[Version (since = "0.7.0")]
		public bool layer_remove (OsmGps.MapLayer layer);
		[Version (since = "0.7.0")]
		public void layer_remove_all ();
		public bool map_redraw ();
		public void map_redraw_idle ();
		public void polygon_add (OsmGps.MapPolygon poly);
		public bool polygon_remove (OsmGps.MapPolygon poly);
		public void polygon_remove_all ();
		public void scroll (int dx, int dy);
		public void set_center (float latitude, float longitude);
		[Version (since = "0.7.0")]
		public void set_center_and_zoom (float latitude, float longitude, int zoom);
		public void set_keyboard_shortcut (OsmGps.MapKey_t key, uint keyval);
		public int set_zoom (int zoom);
		public void set_zoom_offset (int zoom_offset);
		public static unowned string source_get_copyright (OsmGps.MapSource_t source);
		public static unowned string source_get_friendly_name (OsmGps.MapSource_t source);
		public static unowned string source_get_image_format (OsmGps.MapSource_t source);
		public static int source_get_max_zoom (OsmGps.MapSource_t source);
		public static int source_get_min_zoom (OsmGps.MapSource_t source);
		public static unowned string source_get_repo_uri (OsmGps.MapSource_t source);
		public static bool source_is_valid (OsmGps.MapSource_t source);
		[Version (since = "0.7.0")]
		public void track_add (OsmGps.MapTrack track);
		[Version (since = "0.7.0")]
		public bool track_remove (OsmGps.MapTrack track);
		[Version (since = "0.7.0")]
		public void track_remove_all ();
		public void zoom_fit_bbox (float latitude1, float latitude2, float longitude1, float longitude2);
		public int zoom_in ();
		public int zoom_out ();
		[NoAccessorMethod]
		public bool auto_center { get; set construct; }
		[NoAccessorMethod]
		public float auto_center_threshold { get; set construct; }
		[NoAccessorMethod]
		public bool auto_download { get; set construct; }
		[NoAccessorMethod]
		public int drag_limit { get; construct; }
		[NoAccessorMethod]
		public int gps_track_highlight_radius { get; set construct; }
		[NoAccessorMethod]
		public int gps_track_point_radius { get; set construct; }
		[NoAccessorMethod]
		public float gps_track_width { get; set construct; }
		[NoAccessorMethod]
		public string image_format { owned get; construct; }
		[NoAccessorMethod]
		public float latitude { get; }
		[NoAccessorMethod]
		public float longitude { get; }
		[NoAccessorMethod]
		public int map_source { get; set construct; }
		[NoAccessorMethod]
		public int map_x { get; construct; }
		[NoAccessorMethod]
		public int map_y { get; construct; }
		[NoAccessorMethod]
		public int max_zoom { get; construct; }
		[NoAccessorMethod]
		public int min_zoom { get; construct; }
		[NoAccessorMethod]
		public string proxy_uri { owned get; construct; }
		[NoAccessorMethod]
		public bool record_trip_history { get; set construct; }
		[NoAccessorMethod]
		public string repo_uri { owned get; construct; }
		[NoAccessorMethod]
		public bool show_gps_point { get; set construct; }
		[NoAccessorMethod]
		public bool show_trip_history { get; set construct; }
		[NoAccessorMethod]
		public string tile_cache { owned get; set construct; }
		[NoAccessorMethod]
		public string tile_cache_base { owned get; construct; }
		[NoAccessorMethod]
		public int tile_zoom_offset { get; construct; }
		[NoAccessorMethod]
		public int tiles_queued { get; }
		[NoAccessorMethod]
		public string user_agent { owned get; set construct; }
		[NoAccessorMethod]
		public int zoom { get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "osm-gps-map.h", type_id = "osm_gps_map_image_get_type ()")]
	public class MapImage : GLib.Object {
		[CCode (has_construct_function = false)]
		public MapImage ();
		public void draw (Cairo.Context cr, Gdk.Rectangle rect);
		public unowned OsmGps.MapPoint get_point ();
		public float get_rotation ();
		public int get_zorder ();
		public void set_rotation (float rot);
		[NoAccessorMethod]
		public Gdk.Pixbuf pixbuf { owned get; set construct; }
		[NoAccessorMethod]
		public OsmGps.MapPoint point { owned get; set construct; }
		public float rotation { get; set construct; }
		[NoAccessorMethod]
		public float x_align { get; set construct; }
		[NoAccessorMethod]
		public float y_align { get; set construct; }
		[NoAccessorMethod]
		public int z_order { get; set construct; }
	}
	[CCode (cheader_filename = "osm-gps-map.h", type_id = "osm_gps_map_osd_get_type ()")]
	public class MapOsd : GLib.Object, OsmGps.MapLayer {
		[CCode (has_construct_function = false)]
		public MapOsd ();
		[NoAccessorMethod]
		public uint dpad_radius { get; set construct; }
		[NoAccessorMethod]
		public int osd_x { get; set construct; }
		[NoAccessorMethod]
		public int osd_y { get; set construct; }
		[NoAccessorMethod]
		public bool show_coordinates { get; set construct; }
		[NoAccessorMethod]
		public bool show_copyright { get; set construct; }
		[NoAccessorMethod]
		public bool show_crosshair { get; set construct; }
		[NoAccessorMethod]
		public bool show_dpad { get; set construct; }
		[NoAccessorMethod]
		public bool show_gps_in_dpad { get; set construct; }
		[NoAccessorMethod]
		public bool show_gps_in_zoom { get; set construct; }
		[NoAccessorMethod]
		public bool show_scale { get; set construct; }
		[NoAccessorMethod]
		public bool show_zoom { get; set construct; }
	}
	[CCode (cheader_filename = "osm-gps-map.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "osm_gps_map_point_get_type ()")]
	[Compact]
	public class MapPoint {
		public float rlat;
		public float rlon;
		[Version (since = "0.7.2")]
		public OsmGps.MapPoint copy ();
		[CCode (has_construct_function = false)]
		public MapPoint.degrees (float lat, float lon);
		[Version (since = "0.7.2")]
		public void free ();
		public void get_degrees (out float lat, out float lon);
		public void get_radians (float rlat, float rlon);
		[CCode (has_construct_function = false)]
		public MapPoint.radians (float rlat, float rlon);
		public void set_degrees (float lat, float lon);
		public void set_radians (float rlat, float rlon);
	}
	[CCode (cheader_filename = "osm-gps-map.h", type_id = "osm_gps_map_polygon_get_type ()")]
	public class MapPolygon : GLib.Object {
		[CCode (has_construct_function = false)]
		public MapPolygon ();
		public unowned OsmGps.MapTrack get_track ();
		[NoAccessorMethod]
		public bool editable { get; set construct; }
		[NoAccessorMethod]
		public float shade_alpha { get; set construct; }
		[NoAccessorMethod]
		public bool shaded { get; set construct; }
		[NoAccessorMethod]
		public void* track { get; set construct; }
		[NoAccessorMethod]
		public bool visible { get; set construct; }
		[NoAccessorMethod]
		public bool breakable { get; set construct; }
	}
	[CCode (cheader_filename = "osm-gps-map.h", type_id = "osm_gps_map_track_get_type ()")]
	public class MapTrack : GLib.Object {
		[CCode (has_construct_function = false)]
		public MapTrack ();
		[Version (since = "0.7.0")]
		public void add_point (OsmGps.MapPoint point);
		public void get_color (Gdk.RGBA color);
		public double get_length ();
		public unowned OsmGps.MapPoint get_point (int pos);
		[Version (since = "0.7.0")]
		public unowned GLib.SList<OsmGps.MapPoint> get_points ();
		public void insert_point (OsmGps.MapPoint np, int pos);
		public int n_points ();
		public void remove_point (int pos);
		public void set_color (Gdk.RGBA color);
		[NoAccessorMethod]
		public float alpha { get; set construct; }
		[NoAccessorMethod]
		public Gdk.RGBA color { get; set; }
		[NoAccessorMethod]
		public bool editable { get; set construct; }
		[NoAccessorMethod]
		public float line_width { get; set construct; }
		[NoAccessorMethod]
		public void* track { get; construct; }
		[NoAccessorMethod]
		public bool visible { get; set construct; }
		public signal void point_added (OsmGps.MapPoint arg1);
		public signal void point_changed (int object);
		public signal void point_inserted (int object);
		public signal void point_removed (int object);
	}
	[CCode (cheader_filename = "osm-gps-map.h", type_id = "osm_gps_map_layer_get_type ()")]
	public interface MapLayer : GLib.Object {
		public abstract bool busy ();
		public abstract bool button_press (OsmGps.Map map, Gdk.EventButton event);
		public abstract void draw (OsmGps.Map map, Cairo.Context cr);
		public abstract void render (OsmGps.Map map);
	}
	[CCode (cheader_filename = "osm-gps-map.h", cprefix = "OSM_GPS_MAP_KEY_", has_type_id = false)]
	public enum MapKey_t {
		FULLSCREEN,
		ZOOMIN,
		ZOOMOUT,
		UP,
		DOWN,
		LEFT,
		RIGHT,
		MAX
	}
	[CCode (cheader_filename = "osm-gps-map.h", cprefix = "OSM_GPS_MAP_SOURCE_", has_type_id = false)]
	public enum MapSource_t {
		NULL,
		OPENSTREETMAP,
		OPENSTREETMAP_RENDERER,
		OPENAERIALMAP,
		MAPS_FOR_FREE,
		OPENCYCLEMAP,
		OSM_PUBLIC_TRANSPORT,
		GOOGLE_STREET,
		GOOGLE_SATELLITE,
		GOOGLE_HYBRID,
		VIRTUAL_EARTH_STREET,
		VIRTUAL_EARTH_SATELLITE,
		VIRTUAL_EARTH_HYBRID,
		OSMC_TRAILS,
		LAST
	}
	[CCode (cheader_filename = "osm-gps-map.h", cname = "OSM_GPS_MAP_CACHE_AUTO")]
	public const string MAP_CACHE_AUTO;
	[CCode (cheader_filename = "osm-gps-map.h", cname = "OSM_GPS_MAP_CACHE_DISABLED")]
	public const string MAP_CACHE_DISABLED;
	[CCode (cheader_filename = "osm-gps-map.h", cname = "OSM_GPS_MAP_CACHE_FRIENDLY")]
	public const string MAP_CACHE_FRIENDLY;
	[CCode (cheader_filename = "osm-gps-map.h", cname = "OSM_GPS_MAP_INVALID")]
	public const int MAP_INVALID;
}
